/*
	math.h
	Definitions for the math floating point package.
*/

#ifndef  __MATH_H
#define  __MATH_H
#include <_ansi.h>

#define HUGE_VAL	1.7976931348623157E+308	/* largest mag represent as  double */

double	_EXFUN(acos  ,(double x));
double	_EXFUN(asin  ,(double x));
double	_EXFUN(atan  ,(double x));
double	_EXFUN(atan2 ,(double y, double x));
double	_EXFUN(cos   ,(double x));
double	_EXFUN(sin   ,(double x));
double	_EXFUN(tan   ,(double x));
double	_EXFUN(cosh  ,(double x));
double	_EXFUN(sinh  ,(double x));
double	_EXFUN(tanh  ,(double x));
double	_EXFUN(exp   ,(double x));
double	_EXFUN(log1p   ,(double x));
double	_EXFUN(frexp ,(double x, int *exp));
double	_EXFUN(ldexp ,(double x, int exp));
double	_EXFUN(log   ,(double x));
double	_EXFUN(log10 ,(double x));
double	_EXFUN(log2 ,(double x));
double	_EXFUN(modf  ,(double x, double *ipart));
double	_EXFUN(pow   ,(double x, double y));
double	_EXFUN(sqrt  ,(double x));
double	_EXFUN(cbrt  ,(double x));
double	_EXFUN(ceil  ,(double x));
double	_EXFUN(expm1  ,(double x));
double	_EXFUN(fabs  ,(double x));
double	_EXFUN(floor ,(double x));
double	_EXFUN(fmod  ,(double x, double y));
double	_EXFUN(atanh, (double x));
double	_EXFUN(acosh, (double x));
double	_EXFUN(asinh, (double x));

#ifndef __STRICT_ANSI
/* Additions */ 
_FLOAT_RET _EXFUN(acosf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(asinf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(atanf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(atan2f,(_FLOAT_ARG, _FLOAT_ARG));
_FLOAT_RET _EXFUN(cosf , (_FLOAT_ARG));
_FLOAT_RET _EXFUN(sinf , (_FLOAT_ARG));
_FLOAT_RET _EXFUN(tanf , (_FLOAT_ARG));
_FLOAT_RET _EXFUN(expm1f , (_FLOAT_ARG));
_FLOAT_RET _EXFUN(log1pf , (_FLOAT_ARG));
_FLOAT_RET _EXFUN(coshf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(sinhf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(tanhf, (_FLOAT_ARG));
_FLOAT_RET _EXFUN(expf,   (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(frexpf, (_FLOAT_ARG x, int *exp));
_FLOAT_RET _EXFUN(ldexpf, (_FLOAT_ARG x, int exp));
_FLOAT_RET _EXFUN(logf,   (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(log10f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(log2f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(modff,  (_FLOAT_ARG x, float *ipart));
_FLOAT_RET _EXFUN(powf,   (_FLOAT_ARG x, _FLOAT_ARG y));
_FLOAT_RET _EXFUN(sqrtf,  (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(cbrtf,  (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(ceilf,  (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(fabsf,  (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(floorf, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(fmodf, (_FLOAT_ARG x, _FLOAT_ARG y));
_FLOAT_RET _EXFUN(asinhf, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(acoshf, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(atanhf, (_FLOAT_ARG x));

double _EXFUN(gamma, (double x));
_FLOAT_RET _EXFUN(gammaf, (_FLOAT_ARG x));
extern int signgam;
#ifdef SYSV
#define lgamma gamma
#endif

double _EXFUN(erf,(double x));
double _EXFUN(erfc,(double x));


_FLOAT_RET _EXFUN(erff,(_FLOAT_ARG x));
_FLOAT_RET _EXFUN(erfcf,(_FLOAT_ARG x));


double _EXFUN(y0, (double x));
double _EXFUN(y1, (double x));
double _EXFUN(yn, (int n, double x));
double _EXFUN(j0, (double x));
double _EXFUN(j1, (double x));
double _EXFUN(jn, (int n, double x));

_FLOAT_RET _EXFUN(y0f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(y1f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(ynf, (int n, _FLOAT_ARG x));
_FLOAT_RET _EXFUN(j0f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(j1f, (_FLOAT_ARG x));
_FLOAT_RET _EXFUN(jnf, (int n, _FLOAT_ARG x));

double _EXFUN(hypot,(double,double));
_FLOAT_RET _EXFUN(hypotf,(_FLOAT_ARG, _FLOAT_ARG));

double _EXFUN(infinity,(void));
_FLOAT_RET _EXFUN(infinityf,(void));

double _EXFUN(nan,(void));
_FLOAT_RET _EXFUN(nanf,(void));

struct exception 
{
  int type;
  char *name;
  double arg1;
  double arg2;
  double retval;
};

int _EXFUN(matherr,(struct exception *e));

#define DOMAIN 1
#define SING 2
#define OVERFLOW 3
#define UNDERFLOW 4
#define TLOSS 5
#define PLOSS 6

#define M_E		2.7182818284590452354
#define M_LOG2E		1.4426950408889634074
#define M_LOG10E	0.43429448190325182765
#define M_LN2		0.69314718055994530942
#define M_LN10		2.30258509299404568402
#define M_PI		3.14159265358979323846
#define M_TWOPI         (M_PI * 2.0)
#define M_PI_2		1.57079632679489661923
#define M_PI_4		0.78539816339744830962
#define M_3PI_4		2.3561944901923448370E0
#define M_SQRTPI        1.77245385090551602792981
#define M_1_PI		0.31830988618379067154
#define M_2_PI		0.63661977236758134308
#define M_2_SQRTPI	1.12837916709551257390
#define M_SQRT2		1.41421356237309504880
#define M_SQRT1_2	0.70710678118654752440
#define M_LN2LO         1.9082149292705877000E-10
#define M_LN2HI         6.9314718036912381649E-1
#define M_SQRT3   	1.73205080756887719000
#define M_IVLN10        0.43429448190325182765 /* 1 / log(10) */
#define M_LOG2_E        0.693147180559945309417
#define M_INVLN2        1.4426950408889633870E0  /* 1 / log(2) */



#ifdef _SINGLE_PREC
#undef HUGE_VAL
#define HUGE_VAL 	3.40282347E+38
#define double  float
#define acos	acosf
#define asin	asinf
#define atan	atanf
#define atan2   atan2f
#define cosf	cosff
#define sinf	sinff
#define tanf	tanff
#define cosh	coshf
#define sinh	sinhf
#define tanh	tanhf
#define exp	expf
#define frexp   frexpf
#define ldexp   ldexpf
#define log	logf
#define log10	log10f
#define log2	log2f
#define modf    modff
#define pow     powf
#define sqrt	sqrtf
#define cbrt	cbrtf
#define ceil	ceilf
#define fabs	fabsf
#define floor	floorf
#define fmod fmodf
#define asinh	asinhf
#define acosh	acoshf
#define atanh	atanhf
#endif

#endif
#endif /* __MATH_H */
