/*	float.h

	Defines implementation specific macros for dealing with
	floating point. 
*/

#ifndef __FLOAT_H
#define __FLOAT_H

#define FLT_ROUNDS		1		/* rounds to nearest */
/* -1 is indeterminate, 0 is towards 0,  2 is towards +infinity, 3 is towards
 -infinity, and any other value is implementation defined */ 

/*
	The following describes floating point requirements for 
	single-precision and double- precision normalized numbers 
	in ANSI/IEEE 754-1985.

*/
#ifdef __STDC__
#define FLT_EPSILON		1.19209290E-07F	/* must be <= 1E-5 */
#define FLT_MIN			1.17549435E-38F /* must be <= 1E-37 */
#define FLT_MAX			3.40282347E+38F	/* must be >= 1E+37 */
#else
#define FLT_EPSILON		1.19209290E-07	/* must be <= 1E-5 */
#define FLT_MIN			1.17549435E-38 /* must be <= 1E-37 */
#define FLT_MAX			3.40282347E+38	/* must be >= 1E+37 */
#endif

#define FLT_RADIX		2		/* must be >= 2 by X3J11  */
#define FLT_MANT_DIG		24		/* can be anything */
#define FLT_DIG			6		/* must be >= 6 */
#define FLT_MIN_EXP		-125		/* can be anything */
#define FLT_MIN_10_EXP		-37		/* must be >= -37 */
#define FLT_MAX_EXP		128		/* can be anything */
#define FLT_MAX_10_EXP		38		/* must be >= +37 */

#define DBL_MANT_DIG		53		/* can be anything */
#define DBL_EPSILON		2.2204460492503131E-16	/* must be <= 1E-9 */
#define DBL_DIG			15		/* must be >=10 */
#define DBL_MIN_EXP		-1021		/* can be anything */
#define DBL_MIN			2.2250738585072014E-308 /* must be <= 1E-37 */
#define DBL_MIN_10_EXP		-307		/* must be <= -37 */
#define DBL_MAX_EXP		1024		/* can be anything */
#define DBL_MAX			1.7976931348623157E+308	/* must be >= 1E+37 */
#define DBL_MAX_10_EXP		308		/* must be >= +37 */

/* 
	Here is long double precision.  This is for an 80x87.  Your
	fp processor may be very different.
 */

#define LDBL_MANT_DIG		64		/* can be anything */
#define LDBL_EPSILON		1.084202172485504E-19 /* must be <= 1E-9 */
#define LDBL_DIG		19		/* must be >= 10 */
#define LDBL_MIN_EXP		-16381		/* can be anything */
#define LDBL_MIN		3.3621031431120935E-4932 /* must be <= 1E-37 */	
#define LDBL_MIN_10_EXP		-4931		/* must be <= -37 */
#define LDBL_MAX_EXP		16384		/* can be anything */
#define LDBL_MAX		1.1897314953572317E+4932 /* must be >= 1E+37 */
#define LDBL_MAX_10_EXP		4932		/* must be >= +37 */

#endif /* __FLOAT_H */
