/*
FUNCTION
	<<isnan, isnanf, isinf, isinf, finite, finitef>>---IEEE special functions

INDEX
	isnan
INDEX
	isinf
INDEX
	finite

INDEX
	isnanf
INDEX
	isinff
INDEX
	finitef

ANSI_SYNOPSIS
	#include <ieeefp.h>
	int isnan(double <[arg]>);
	int isinf(double <[arg]>);
	int finite(double <[arg]>);
	int isnanf(float <[arg]>);
	int isinff(float <[arg]>);
	int finitef(float <[arg]>);

TRAD_SYNOPSIS
	#include <ieeefp.h>
	int isnan(<[arg]>)
	double <[arg]>;
	int isinf(<[arg]>)
	double <[arg]>;
	int finite(<[arg]>);
	double <[arg]>;
	int isnanf(<[arg]>);
	float <[arg]>;
	int isinff(<[arg]>);
	float <[arg]>;
	int finitef(<[arg]>);
	float <[arg]>;


DESCRIPTION
	These functions provide information on the floating point
	argument supplied.

	There are five major number formats - 
	o+
	o zero
	 a number which contains all zero bits.
	o subnormal
	 Is used to represent  number with a zero exponent, but a non zero fraction.
	 o normal
	  A number with an exponent, and a fraction
     	o infinity
	  A number with an all 1's exponent and a zero fraction.
	o NAN
	  A number with an all 1's exponent and a non zero fraction.

	o-

	<<isnan>> returns 1 if the argument is a nan. <<isinf>>
	returns 1 if the argument is infinity.  <<finite>> returns 1 if the
	argument is zero, subnormal or normal.
	
	The <<isnanf>>, <<isinff>> and <<finitef>> perform the same
	operations as their <<isnan>>, <<isinf>> and <<finite>>
	counterparts, but on single precision floating point numbers.

QUICKREF
	isnan - pure
QUICKREF
	isinf - pure
QUICKREF
	finite - pure
QUICKREF
	isnan - pure
QUICKREF
	isinf - pure
QUICKREF
	finite - pure
*/




	
	 

#include <ieeefp.h>
#undef isnanf
#undef isinff
#undef finitef



int
 _DEFUN(finite,(x), double x)
{
  __ieee_double_shape_type v;
  v.value = x;
  return (v.number.exponent != __IEEE_DBL_NAN_EXP) ;
}

int
 _DEFUN(finitef,(x), _FLOAT_ARG x)
{
  __ieee_float_shape_type v;
  v.value = x;
  return (v.number.exponent != __IEEE_FLT_NAN_EXP) ;
}


int
 _DEFUN(isnan,(x), double x)
{
  __ieee_double_shape_type v;
  v.value = x;
  if (v.number.exponent == __IEEE_DBL_NAN_EXP)
  {
    v.number.exponent = 0;
    return v.value != 0;
  }
  return 0;
}

int
 _DEFUN(isnanf,(x), _FLOAT_ARG x)
{
  __ieee_float_shape_type v;
  v.value = x;
  if (v.number.exponent == __IEEE_FLT_NAN_EXP)
  {
    v.number.exponent = 0;
    return v.value != 0;
  }
  return 0;

}

int
 _DEFUN(isinf,(x), double x)
{
  __ieee_double_shape_type v;
  v.value = x;
  if (v.number.exponent == __IEEE_DBL_NAN_EXP)
  {
    v.number.exponent = 0;
    return v.value == 0;
  }
  return 0;
}

int
 _DEFUN(isinff,(x), _FLOAT_ARG x)
{
  __ieee_float_shape_type v;
  v.value = x;
  if (v.number.exponent == __IEEE_FLT_NAN_EXP)
  {
    v.number.exponent = 0;
    return v.value == 0;
  }
  return 0;

}
