/* 
FUNCTION
	<<fpgetsticky>>, <<fpsetsticky>>---IEEE floating-point exception flags

INDEX
fpgetmask
INDEX
fpsetmask

ANSI_SYNOPSIS
	#include <ieeefp.h>
	fp_except fpgetsticky(void);
	fp_except fpsetsticky(fp_except <[flags]>);

TRAD_SYNOPSIS
	#include <ieeefp.h>
	fp_except fpgetsticky();
	fp_except fpsetsticky(<[flags]>)
	fp_except <[flags]>;

DESCRIPTION
Whenever one of five possible errors occurs during IEEE floating-point
calculations, the processor sets a flag to record that the error took
place.

You can get the most recent value of these flags at any time with
<<fpgetsticky>>.  The flags are not cleared automatically; you can use
<<fpsetsticky>> to clear them when you wish.

The flag values are defined in `<<ieeefp.h>>'.  They are the same
values used for exception masks with <<fpgetmask>> and <<fpsetmask>>:
o+
o FP_X_INV
invalid operation

o FP_X_DZ
division by zero

o FP_X_OFL
overflow (number too large to represent)

o FP_X_UFL
underflow (number too small to represent)

o FP_X_IMP
loss of precision
o-

RETURNS
<<fpgetsticky>> returns the current exception flags without changing
them; <<fpsetsticky>> returns the most recent exception flags, and
clears those specified in its argument.

PORTABILITY
These functions are not ANSI C.
*/
