.TH Shell 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Shell \- shell interactor
.SH SYNOPSIS
.B #include <InterViews/shell.h>
.SH DESCRIPTION
A shell is an interactor that contains a frame around a banner and
terminal emulator.
A shell reads keystroke events and writes the corresponding characters
to the file descriptor identified by the \fIpty\fP member variable.
It also reads characters from the file descriptor and
sends the text to the terminal emulator, which in turn
writes characters on the screen.
The terminal emulation interprets escape sequences defined
by the ``xterm'' termcap entry, roughly corresponding to a VT102.
.SH PUBLIC OPERATIONS
.TP
.B "Shell(Sensor*, Painter*)"
.ns
.TP
.B "Shell(int rows, int cols, Sensor*, Painter*)"
.ns
.TP
.B "Shell(const char*, int rows, int cols, Sensor*, Painter*)"
Create a new shell with optional name and size.
The sensor defines the events of interest;
it should be nil for normal behavior.
The painter colors are used for drawing the text.
.TP
.B "Run()"
Read events until an EOF is received on the \fIpty\fP file descriptor.
Keystrokes are written to the file; text from the file is written
to the terminal emulator.
.TP
.B "void Write(const char*, int)"
Write characters to the file associated with the shell.
.SH SEE ALSO
Emulator(3I), Interactor(2I), OldTextBuffer(3I)
