.TH GraphicBlock 3I "7 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
GraphicBlock \- interactor containing a Graphic
.SH SYNOPSIS
.B #include <InterViews/Graphic/grblock.h>
.SH DESCRIPTION
A GraphicBlock is an interactor that contains a graphic.  GraphicBlocks are
useful for interactors whose appearance is most conveniently defined using
structured graphics.
The graphic will
be drawn whenever the interactor's Draw member function is called.  

The graphic can be aligned with respect to the GraphicBlock's canvas.
When the canvas is first allocated, the
graphic is positioned so that its bounding box is aligned with the canvas.
On subsequent resizes, the portion of the graphic
within the canvas is aligned.  With the default alignment, for example, a
graphic will be centered in the canvas initially.  If the canvas is resized,
then the part of the graphic in the center of the canvas prior to resizing
will appear in the center of the canvas after resizing.

The graphic 
can be scrolled and zoomed as well using a perspective.  Zooming is
performed by changing either the curwidth/curheight or the width/height
members of the GraphicBlock's perspective.  For example, to enlarge the view
of the graphic by a factor of two, call the Adjust member function with a
perspective whose curwidth and curheight are half that of the GraphicBlock's
or whose width and height are double that of the GraphicBlock's.  Zooming
can be limited to magnifications that are powers of two by specifying Binary
for the Zooming parameter.

The natural size of a GraphicBlock depends on the size of the graphic it
contains and on any padding (white space surrounding the graphic) specified.
GraphicBlocks are infinitely stretchable horizontally and vertically by
default.
.SH PUBLIC OPERATIONS
.TP
.B "GraphicBlock(Sensor*, Graphic*, Coord pad = 0, Alignment = Center, Zooming = Continuous)"
Create a new GraphicBlock with the specified sensor, graphic, padding,
alignment, and zooming.
.TP
.B "virtual void Invert()"
Invert displays the GraphicBlock with the graphic's foreground and
background colors exchanged.
.TP
.B "void Update()"
The Update operation should be called after the graphic is changed.
.TP
.B "Graphic* GetGraphic()"
Get the graphic in the GraphicBlock.
.TP
.B "float GetMagnification()"
.ns
.TP
.B "void SetMagnification(float)"
Get and set the magnification applied to the graphic, relative to its
magnification when the GraphicBlock was created.
.SH PROTECTED OPERATIONS
.TP
.B "virtual void Zoom(Perspective&)"
.ns
.TP
.B "virtual void Scroll(Perspective&)"
These functions define how zooming and scrolling are inferred from the
perspective that is supplied to the Adjust function.  The default behaviors
implement standard scroller-style semantics and zooming as described above.
.TP
.B "virtual float LimitMagnification(float)"
Limit the amount of magnification that can be applied to the graphic.  This
function is used as a filter to convert desired magnifications into legal
ones.  By default, the argument is returned; no limits are imposed.
.TP
.B "void UpdatePerspective()"
Changes the GraphicBlock's perspective to reflect the
bounding box of the graphic and calls Update on the perspective.
UpdatePerspective encapsulates this functionality to facilitate
redefinition of the Update function in derived classes.
.SH SEE ALSO
Interactor(2I), libInterViews(3I), libgraphic(3I), Scroller(3I)
