.TH Table 3I "15 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
Table \- associative store for single-word objects
.SH SYNOPSIS
.B #include <InterViews/table.h>
.SH DESCRIPTION
A table is an index where the key and data
are both single-word objects (either integers or pointers).
The types TableKey and TableValue are arbitrary pointers (void*);
all the operations below are also provided
for integer, unsigned, long, and unsigned long keys.
.SH PUBLIC OPERATIONS
.TP
.B "Table(int size)"
Construct a table of the given size.
The size will be rounded up to the next power of two
so that indexing the table does not require division
(just take the bitwise-and of the key and (size-1)).
.TP
.B "~Table()"
Free storage associated with the table.
.TP
.B "void Insert(TableKey key, TableValue value)"
Add (\fIkey\fP,\ \fIvalue\fP) pair to the table.
Insert does not prevent a key
from being entered in the table more than once.
.TP
.B "boolean Find(TableValue& value, TableKey key)"
If \fIkey\fP has been inserted into the table,
set \fIvalue\fP to the associated value and return true.
Otherwise, do not modify \fIvalue\fP and return false.
In the presence of duplicate keys, Find gets
the most recently inserted value.
.TP
.B "void Remove(TableKey key)"
Delete \fIkey\fP from the table.
If \fIkey\fP appears in the table more than once, the most recently
inserted entry is removed.
