.TH iwm 1 "5 July 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
iwm \- window manager
.SH SYNOPSIS
iwm [ help ]
.SH DESCRIPTION
\fIiwm\fP provides functionality for binding special window management
functions or user commands to chorded mouse buttons or user-definable menu
entries.
.PP
The configuration of the window manager is determined by the ~/.iwmrc file.
It contains any number of entries of the following format:
.PP
\fIactivator\fP \fIfunction\fP [[\fI*\fP] \fImenu-text\fP]
.PP
\fIActivator\fP can be:
.TP 8
\fBa chorded button\fP
Any combination of ``shift'', ``meta'', ``lock'', ``ctrl'', and ``logo''
(including
none of these) followed by ``left'', ``middle'', or ``right''.  All keywords
are separated by spaces.  Examples: ``shift meta left'', ``middle'',
``logo right''.  Specifying ``logo'' redefines a button press
within the logo icon (see below). If no chord is specified, ``meta'' is
assumed.
.TP
\fBthe name of a menu\fP
This may be any single word (no double quotes or spaces allowed).  An entry
in the menu is added with the text \fImenu-text\fP.  The \fIfunction\fP will
be performed when that selection is made from the menu.  See the description
of sub-menus below to find out more about what happens when \fIfunction\fP is
also the name of a menu (as well as a description of the ``*'' option).  If
\fIfunction\fP is one of the ten built-in functions, then \fImenu-text\fP is
optional, otherwise, it is mandatory.
.PP
\fIFunction\fP can be:
.TP 8
\fBa built-in command\fP
These are the ten predefined operations the window manager knows how to
perform.  See the detailed list of these operations below.
.TP
\fBthe name of a menu\fP
This will cause the named menu to "pop-up" when the corresponding
\fIactivator\fP is performed.
.TP
\fBa shell command\fP
Must be surrounded by double quotation marks.  This can be any shell command.
Note that if the shell command has output, then that output will be lost
unless you tell \fIiwm\fP NOT to fork (see .Xdefaults options below).
.SH SUB-MENUS
If both the \fIactivator\fP and the \fIfunction\fP are a menu, then the
\fIfunction\fP menu is considered a "sub-menu" of the \fIactivator\fP menu.
There are two types of sub-menus: persistent and non-persistent.
.PP
A persistent menu will not pop-up until it is actually selected (by releasing
the mouse button).  Once it has popped up, it's parent will go away, and
it will not go away until a selection is made, or until the mouse is clicked
on the background.
.PP
A non-persistent menu will appear if the mouse moves from the left part of
the menu selection which activates it into the right part.  It will then
pop-up, and will go away as soon as the mouse leaves its borders.  If the
parent menu is also non-persistent, then, if the mouse leaves the borders of
the child and does not return to within the borders of the parent, both the
child and the parent menu will disappear.
.PP
It is common practice to have a top-level menu be persistent, and the
children be either persistent or non-persistent to suit individual taste.
In the sample .iwmrc (see below), the "done" menu is persistent.  Menus are,
by default, non-persistent.  Placing a ``*'' before the \fImenu-text\fP makes
a menu persistent.
.SH BUILT-IN OPERATIONS
Here are the built-in operations currently supported by the window manager:
.TP 8
\fBMove\fP
Move a window by "grabbing" and moving it with the mouse.  The command can
be aborted by clicking again before releasing the mouse button.
.TP
\fBResize\fP
Resize the window by "grabbing" a corner or an edge with the mouse and moving
it.  The command can be aborted by clicking again before releasing the mouse
button.
.TP
\fBRedraw\fP
Redraw the entire screen.
.TP
\fBRepair\fP
Redraw a portion of the screen specified by dragging out a rectangle.
.TP
\fBRaise\fP
Raise a window (chosen with the mouse) to the top of the pile of windows on
the screen.
.TP
\fBLower\fP
Lower a window (chosen with the mouse) to the bottom of the pile of windows
on the screen.
.TP
\fBFocus\fP
Choose a window (with the mouse) to gain control of the keyboard.  The chosen
window will receive all future keyboard events until focus is given to another
window or until focus is given to the background.
.TP
\fBLock\fP
Locks the screen.  Puts up a message and waits for user's password to unlock
the screen (the root password will also unlock the screen).
.TP
\fBIconify\fP
Turns the window into an Icon (if the window has an Icon).  If the selected
window is itself an Icon, then it will be converted back to its original
form (and position).  When a window is iconified, the icon is put at the
current mouse position.
.TP
\fBExit\fP
Exits the window manager.
.TP
\fBNull\fP
Does nothing.
.SH EXAMPLE
The best way to see how the .iwmrc file works is to look at
/usr/local/lib/iwmrc.default.  This is the .iwmrc which will be used if
there is no .iwmrc in the user's home directory.  Start up \fIiwm\fP and
see how it behaves, then compare that behaviour to
/usr/local/lib/iwmrc.default.  It is reproduced here:
.PP
left		Move
.br
middle		commands *
.br
right		menu *
.br
menu		Focus
.br
menu		Lower
.br
menu		Raise
.br
menu		Redraw
.br
menu		Iconify
.br
menu		Lock
.br
menu		Resize
.br
commands	"idraw -l"		idraw -l
.br
commands	"idraw -s"		idraw -s
.br
commands	"xterm =80x24"		Shell
.br
commands	"dclock -f -j"		Clock
.br
commands	done *			Exit
.br
done		Exit			Really exit?
.br
done		Null			No, don't exit.
.SH CONVENIENCE
If any button has only
one chord combination, then that button will work with or without chording.
If an application is listening for a button, however, you may have to use the
chording to force the button events to get to the window manager (since using
chording will ALWAYS work: not using chording is simply a convenience).
.PP
Clicking a non-chorded button that normally pops up a menu while you are on
top of some icons will cause that icon to deiconify itself.  This will only
work with icons that are created from the name of the window or icons which
the applications have specially designed to work in this fashion.
.SH OPTIONS
.PP
There is only one command line argument to \fIiwm\fP, ``help'',
which displays
a brief description of how to use \fIiwm\fP.
.SH PARAMETERS
\fIiwm\fP understands the following entries in .Xdefaults:
.TP 8
\fBiwm.fork\fP
If ``true'' \fIiwm\fP will fork when it starts up.  This should be set to
``false'' if some user-defined function has output (since if fork is true,
then \fIiwm\fP will be disassociated with its terminal and will not be able to
output).  The default is ``true''.
.TP
\fBiwm.logo\fP
An X geometry specification.  The logo is used to remind the user
that \fIiwm\fP is running.  Also, mouse button clicks within the logo
can be distinct from clicks elsewhere by specifying the ``logo'' chording 
modifier in the ~/.iwmrc file.
Only the width of the logo need be specified (and not the
height) since it is square.  A size of 0 will prevent the logo from
begin displayed.  The default logo will be scaled to fit the specified size.
If a bitmap logo is used the bitmap will be centered on a blank background
of the specified size.
Sizes of the form 13n + 1 where n is an integer greater
than 3 work best for the default logo.  The default geometry is =53-4+4.
.TP
\fBiwm.bitmap\fP
Specifies a bitmap(1) file to be used in constructing a bitmapped logo
instead of the default logo.
.TP
\fBiwm.inverse\fP
If ``true'', the menus, logo, and lock message will be white on
black rather than black on white.
.TP
\fBiwm.lock\fP
If ``true'', then, when the screen is locked (using Lock above),
the X screen-saver will continue to function (by inhibiting the output of all
programs on the desktop.  If ``false'', programs will continue to output even
while the desktop is locked.  Default: ``false''.
.TP
\fBiwm.ignorecaps\fP
If ``true'', buttons will continue to perform their designated
function even if the Shift-Lock key is engaged (note that the shift lock key is
a valid chord when designating an activator, e.g., ``lock ctrl left'').
.TP
\fBiwm.font\fP
The named font will be used for text in \fIiwm\fP menus and the lock message.
.TP
\fBiwm.snapresize\fP
.ns
.TP
\fBiwm.constrainresize\fP
These options modify the behaviour of the rubber band used 
in the resize operation.  If
\fIsnapresize\fP is ``true'' the rubber band will snap a corner or edge
to the mouse position; if it is ``false'' (the default) the relative
position of the mouse within the window will be kept constant.
If \fIconstrainresize\fP is ``true'' (the default) the resize operation can be
constrained to one dimension by grabbing the window near the center of an
edge; if it is ``false'' only corners can be grabbed.
.SH FILES
~/.Xdefaults	parameters
.br
~/.iwmrc		menu definitions
