;;!emacs
;; $Id:
;;
;; LCD-ENTRY:    hyperbole|Bob Weiner|hyperbole@cs.brown.edu|Everyday Info Manager|See below|See below
;;
;; FILE:         hyperbole.el
;; SUMMARY:      Sets up Hyperbole for autoloading and use.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Motorola, Inc., PWDG
;;
;; ORIG-DATE:     6-Oct-92 at 11:52:51
;; LAST-MOD:      7-Oct-92 at 15:12:26 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; 
;; Copyright (C) 1992, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   Don't put site-specific customizations in here.  They belong in
;;   "hsite.el" which is created from "hsite-ex.el" by the person who
;;   installs Hyperbole at your site.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(autoload 'hui:menu          "hsite"      "Hyperbole info manager."      t)
(fset     'hyperbole         'hui:menu)

(autoload 'rolo-fgrep        "wrolo"      "Hierarchical rolodex"         t)
(autoload 'rolo-grep         "wrolo"      "Hierarchical rolodex"         t)

;;; ************************************************************************
;;; Public key bindings
;;; ************************************************************************

;;; Setup so Hyperbole can be autoloaded from a key.
;;; This key binding is repeated in "hsite.el" in case
;;; this file is bypassed.
;;;
(or (where-is-internal 'hui:menu)
    (define-key help-map "h" 'hui:menu))


(provide 'hyperbole)
