;;!emacs
;;
;; FILE:         hui-epV3-b.el
;; SUMMARY:      Epoch V3-specific button support.
;; USAGE:        Epoch Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    27-Apr-91 at 05:37:10
;; LAST-MOD:     13-Dec-91 at 14:58:42 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; It is for use with Epoch, a modified version of GNU Emacs.
;; 
;; Copyright (C) 1991, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   Requires Epoch 3.2 or greater, but less than 4.0.
;;
;;   This is truly prototype code.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************

(require 'hui-ep-but)

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(defun ep:cycle-but-color (&optional color)
  (interactive)
  (if (<= (epoch::number-of-colors) 2)
      nil
    (if color (setq ep:color-ptr nil))
    (set-attribute-global
     ep:but (or color (car (ep:list-cycle ep:color-ptr ep:good-colors)))
     (background))
    (redraw-display)
    t))

(defun ep:but-flash ()
  "Flash a Hyperbole button at point to indicate selection, when using Epoch."
  (interactive)
  (let ((ibut) (prev)
	(start (hattr:get 'hbut:current 'lbl-start))
	(end   (hattr:get 'hbut:current 'lbl-end)))
    (and start end (setq prev (epoch::button-at (point) (current-buffer))
			 ibut t)
	 (if (not prev) (ep:but-add start end ep:but)))
    (let* ((b (epoch::button-at (point) (current-buffer)))
	   (a (and (epoch::buttonp b) (epoch::button-attribute b))))
      (if a
	  (progn
	    (epoch::set-button-attribute b ep:flash-attribute)
	    (epoch::redisplay-screen)
	    ;; Delay before redraw button
	    (let ((i 0)) (while (< i ep:but-flash-time) (setq i (1+ i))))
	    (epoch::set-button-attribute b a)
	    (epoch::redisplay-screen)
	    )))
    (if (and ibut (not prev)) (ep:but-delete))
    ))

;;; ************************************************************************
;;; Private variables
;;; ************************************************************************

(defvar ep:but (reserve-attribute) "Attribute for hyper-buttons.")

(defvar ep:flash-style (make-style) "The style for a flashing button")
(defvar ep:flash-attribute (reserve-attribute)
  "The attribute for a flashing button")

;;; You can set the style for the flash in ep:flash-style, and then use:
;;; the following to use that style.
(set-attribute-style ep:flash-attribute ep:flash-style)

(provide 'hui-epV3-b)
