/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** include files **/

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/openmenu.h>

#include "browser.h"


/** Global variabels for canvas things **/

int delete_node_dragging = FALSE;
int delete_links_draggnig = FALSE;
int show_dragging = FALSE;
int update_all_canvas = FALSE;
int show_dir_in_hierarchy = TRUE;


/** Global variabels for EHTS options **/

int data_to_ehts = FALSE;
int nodeatt_to_ehts = FALSE;
int linkatt_to_ehts = FALSE;


/** extern definitions **/

extern Frame baseframe;
extern Panel basepanel;


/*******************************************************************
** sel_quit()
*******************************************************************/

void sel_quit(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  disconnect_to_hb();		/* make sure we disconnect before exit() */
  exit(0);
}


/*******************************************************************
** sel_menu_layout() --- parse the layout menu
*******************************************************************/

void sel_menu_layout(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  char default_file[256];
  
  strcpy(default_file, getenv("HOME"));
  strcat(default_file, "/.ehts-browser");
  
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Quit"))
  {
    disconnect_to_hb();		/* make sure we disconnect before exit() */
    exit(0);
  }
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Save layout"))
    save_layout_file(default_file);
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Load layout"))
    load_layout_file(default_file);
}

/*******************************************************************
** canvas_options() --- get the canvas repaint setings
*******************************************************************/

canvas_options(item,value,event)
Panel_item item;
int value;
Event *event;
{
  
  if (value >> 4)
  {
    show_dir_in_hierarchy = TRUE;
    value = value & (value - 16);
    redraw_all_paintwin();
  }
  else
  {
    show_dir_in_hierarchy = FALSE;
    redraw_all_paintwin();
  }
  if (value >> 3)
  {
    update_all_canvas = TRUE;
    value = value & (value - 8);
  }
  else
    update_all_canvas = FALSE;
  if (value >> 2)
  {
    show_dragging = TRUE;
    value = value & (value - 4);
  }
  else
    show_dragging = FALSE;
  if (value >> 1)
  {
    delete_links_draggnig = TRUE;
    value = value & (value - 2);
  }
  else
    delete_links_draggnig = FALSE;
  if (value)
    delete_node_dragging = TRUE;
  else
    delete_node_dragging = FALSE;
}


/*******************************************************************
** ehts_options()
*******************************************************************/

ehts_options(item,value,event)
Panel_item item;
int value;
Event *event;
{
  if (value >> 2)
  {
    linkatt_to_ehts = TRUE;
    value = value & (value - 4);
  }
  else
    linkatt_to_ehts = FALSE;
  if (value >> 1)
  {
    nodeatt_to_ehts = TRUE;
    value = value & (value - 2);
  }
  else
    nodeatt_to_ehts = FALSE;
  if (value)
    data_to_ehts = TRUE;
  else
    data_to_ehts = FALSE;
}
  

/*******************************************************************
** sel_options() --- display the options panel
*******************************************************************/

void sel_option(item, event)
Panel_item item;
Event *event;
{
  Frame option_frame;
  Panel option_panel;
  Panel_item canvas_item, ehts_item;
  unsigned char canvas_value = 0;
  unsigned char ehts_value = 0;
  char tmp;

  if (show_dir_in_hierarchy)	/* CANVAS REPAINT */
  {
    tmp = 16;
    canvas_value = canvas_value | tmp;
  }
  if (update_all_canvas)	
  {
    tmp = 8;
    canvas_value = canvas_value | tmp;
  }
  if (show_dragging)
  {
    tmp = 4;
    canvas_value = canvas_value | tmp;
  }
  if (delete_links_draggnig)
  {
    tmp = 2;
    canvas_value = canvas_value | tmp;
  }
  if (delete_node_dragging)
  {
    tmp = 1;
    canvas_value = canvas_value | tmp;
  }
  
  if (linkatt_to_ehts)		/* EHTS */
  {
    tmp = 4;
    ehts_value = ehts_value | tmp;
  }
  if (nodeatt_to_ehts)
  {
    tmp = 2;
    ehts_value = ehts_value | tmp;
  }
  if (data_to_ehts)
  {
    tmp = 1;
    ehts_value = ehts_value | tmp;
  }
  
  option_frame = (Frame)xv_create(baseframe, FRAME_CMD,
				  XV_X, event_x(event),
				  XV_Y, event_y(event),
				  XV_WIDTH, 10,
				  XV_HEIGHT, 10,
				  FRAME_LABEL, "Browser Options",
				  NULL);
  option_panel = (Panel)xv_create(option_frame, PANEL, NULL);

  ehts_item = (Panel_item)xv_create(option_panel, PANEL_CHECK_BOX,
				      PANEL_LAYOUT, PANEL_VERTICAL,
				      PANEL_CHOOSE_ONE, FALSE,
				      PANEL_LABEL_STRING, "EHTS Options",
				      PANEL_CHOICE_STRINGS,
				        "Show data in EHTS",
				        "Show node attributes in EHTS",
				        "Show link attributes in EHTS",
				        NULL,
				      PANEL_NOTIFY_PROC, ehts_options,
				      PANEL_VALUE, (int)ehts_value,
				      NULL);

  canvas_item = (Panel_item)xv_create(option_panel, PANEL_CHECK_BOX,
				      PANEL_LAYOUT, PANEL_VERTICAL,
				      PANEL_CHOOSE_ONE, FALSE,
				      PANEL_LABEL_STRING, "Canvas Repainting",
				      PANEL_CHOICE_STRINGS,
				        "Delete node when moving",
				        "... also links to node",
				        "Repaint when moving node",
				        "... only in current view",
				        "Show dir in hierarchy",
				        NULL,
				      PANEL_NOTIFY_PROC, canvas_options,
				      PANEL_VALUE, (int)canvas_value,
				      NULL);

  window_fit(option_panel);
  window_fit(option_frame);

  xv_set(option_frame, XV_SHOW, TRUE, NULL);
}


/*******************************************************************
** selection() --- the panel menu buttons selection proc.
*******************************************************************/

int selction(item, event)
Panel_item item;
Event *event;
{
  /* print_right_footer(xv_get(item, PANEL_LABEL_STRING)); */
  return;
}  


/*******************************************************************
** sel_menu_machine() --- get the machine name
*******************************************************************/

int sel_menu_machine(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  extern char hb_on_machine[];
  
  strcpy(hb_on_machine, xv_get(menu_item, MENU_STRING));
}


/*******************************************************************
** sel_menu_hb() --- parse the HyperBase menu
*******************************************************************/

int sel_menu_hb(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Connect"))
    connect_to_hb();
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Disconnect"))
    disconnect_to_hb();
}


/*******************************************************************
** set_up_panel()  --- setup the panel
*******************************************************************/

set_up_panel()
{
  Menu layout_menu;
  Menu hb_menu;
  Menu machine_menu;
  
  basepanel = (Panel)xv_create(baseframe, PANEL, NULL);

  machine_menu = (Menu)xv_create(NULL, MENU,
				 MENU_NOTIFY_PROC, sel_menu_machine,
				 MENU_STRINGS, "Aiken", "Banach", "Blue",
				 "Dirac", "Euler", "Green", "Laplace",
				 "Pink", "Purple", "Shannon", "Thiele", NULL,
				 NULL);

  hb_menu = (Menu)xv_create(NULL, MENU,
			    MENU_STRINGS, "Connect", "Disconnect", NULL,
			    MENU_NOTIFY_PROC, sel_menu_hb,
			    MENU_ITEM,
			        MENU_STRING, "Machine",
			        MENU_PULLRIGHT, machine_menu,
			        NULL,
			    NULL);

  layout_menu = (Menu)xv_create(NULL, MENU,
			      MENU_NOTIFY_PROC, sel_menu_layout,
			      MENU_STRINGS, "Load layout",
			      "Load layout file", "Save layout",
			      "Save layout file", NULL,
			      NULL);
  
  (void) xv_create(basepanel, PANEL_BUTTON,
		   PANEL_LABEL_STRING, " QUIT ",
		   PANEL_NOTIFY_PROC, sel_quit,
		   NULL);

  (void) xv_create(basepanel, PANEL_BUTTON,
		   PANEL_LABEL_STRING, "Layout",
		   PANEL_NOTIFY_PROC, selction,
		   PANEL_ITEM_MENU, layout_menu,
		   NULL);

  (void) xv_create(basepanel, PANEL_BUTTON,
		   PANEL_LABEL_STRING, "HyperBase",
		   PANEL_NOTIFY_PROC, selction,
		   PANEL_ITEM_MENU, hb_menu,
		   NULL);

  (void) xv_create(basepanel, PANEL_BUTTON,
		   PANEL_LABEL_STRING, "Options...",
		   PANEL_NOTIFY_PROC, sel_option,
		   NULL);

  window_fit(basepanel); 

}




