/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** include files **/

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/notify.h>

#include "browser.h"
#include "hb_config.h"

/** extern definitions **/

extern Frame baseframe;
extern Panel basepanel;
extern Canvas canvas;
extern HBNODE *node_root; /* root pointer to the node list */
extern HBLINK *link_root; /* root pointer to the link list */
extern HBNODE *node_dir_ptr;	/*  the directory pointer */

extern int debug;		/* the on/off debug int */

/** global variabels **/

int removelink_node = 0;	/* used to store event from REMOVELINK */
int link_from_num = 0;


/*******************************************************************
** redraw_if_needed() --- redraw if node is in current paintwind.
*******************************************************************/

redraw_if_needed(ent_no)
int ent_no;
{
  if (find_dir_node(ent_no, node_root) != NULL)
    redraw_all_paintwin();
  else if (find_dir_node(ent_no, node_dir_ptr->dir) != NULL)
    redraw_all_paintwin();
}


/*******************************************************************
** event_input_func() --- parse incomming events
*******************************************************************/

event_input_func(client, fd)
Notify_client client;
int fd;
{
  char buf[100];
  char user[100];
  char *buf_ptr;
  int *int_ptr;
  int ent_no, operation, key;
  HBNODE *node_ptr;
  HBLINK *link_ptr;

  
  read(fd, &buf[0], 100);

  /* debug = 1; */
  
  strcpy(user, buf);
  buf_ptr = (char *)strchr(buf, '\0');
  buf_ptr++;
  memcpy((char *)&ent_no, buf_ptr, 4); 
  buf_ptr += 4;
  memcpy((char *)&operation, buf_ptr, 4);
  buf_ptr += 4;
  memcpy((char *)&key, buf_ptr, 4);

  if (debug)
    fprintf(stderr,"\"%s\" - ", user);
  
  switch(operation)
  {
  case READ:
    if (debug)
      fprintf(stderr,"READ: ent_no = %d, key = %d\n", ent_no, key);
    break;
  case WRITE:
    if (debug)
      fprintf(stderr,"WRITE: ent_no = %d, key = %d\n", ent_no, key);
    switch(key)
    {
      HBNODE *tmp;
      HBLINK *link_tmp;
      char *str;
      int len;
      
    case NNAME:
      tmp = (HBNODE *)find_node(ent_no, node_root);
      hb_Read(ent_no, NNAME, &str, &len);
      strcpy(tmp->name, str);
      free(str);
      tmp->att_frame = NULL;
      redraw_if_needed(ent_no);
      break;
    case NLASTMODIFIEDDATE:
      tmp = (HBNODE *)find_node(ent_no, node_root);
      tmp->att_frame = NULL;
      break;
    case LNAME:
      link_tmp = (HBLINK *)find_link(ent_no);
      if (link_tmp != NULL)
      {
	hb_Read(ent_no, LNAME, &str, &len);
	link_tmp->att_frame = NULL;
	strcpy(link_tmp->name, str);
	free(str);
      }
      else
      {
	HBNODE *tmp;
	HBLINKLIST *link_ptr, *ptr;
	
	insert_new_link(ent_no);

	tmp = (HBNODE *)find_node(link_from_num, node_root);

	link_ptr = (HBLINKLIST *)malloc(sizeof(HBLINKLIST));

	ptr = tmp->link_num;
	tmp->link_num = link_ptr;
	link_ptr->next = ptr;

	link_ptr->num = ent_no;
      }
      redraw_if_needed(link_from_num);
      break;
    case LLASTMODIFIEDDATE:
      link_tmp = (HBLINK *)find_link(ent_no);
      link_tmp->att_frame = NULL;
      break;
    default:
      break;
    }
    break;			/* !!!!!!!!!!!!!!!!!!!! (cbn) */
  case CREATE_NODE:
    if (debug)
      fprintf(stderr,"CREATE_NODE: %d\n", ent_no);
    insert_new_node(ent_no);
    break;
  case DELETE:
    if (debug)
      fprintf(stderr,"DELETE: %d\n", ent_no);
    if (ent_no%2)		/* is it a link or a node ? */
    {
      delete_link(ent_no);
      if (removelink_node != 0)
      {
	delete_link_from_node(removelink_node, ent_no);
	redraw_if_needed(removelink_node);
	removelink_node = 0;
      }
    }
    else
    {
      int update = FALSE;
      
      if (find_dir_node(ent_no, node_root) != NULL)
	update = TRUE;
      else if (find_dir_node(ent_no, node_dir_ptr->dir) != NULL)
	update = TRUE;
      
      delete_node(ent_no);

      if (update)
	redraw_all_paintwin();
    }
    break;
  case LINK:
    if (debug)
      fprintf(stderr,"LINK: ent_no = %d, key = %d\n", ent_no, key);
    if (!(ent_no%2))
      link_from_num = ent_no;
    break;
  case MOVELINK:
    if (debug)
      fprintf(stderr,"MOVELINK: %d\n", ent_no);
    link_ptr = (HBLINK *)find_link(ent_no);
    if (link_ptr != NULL)
    {
      int *ret, len;
      
      hb_Read(ent_no, TODATANODE_NO, &ret, &len);
      link_ptr->to_node = *ret;
      redraw_all_paintwin();
    }
    break;
  case REMOVELINK:
    if (debug)
      fprintf(stderr,"REMOVELINK: %d\n", ent_no);
    removelink_node = ent_no;
    break;
  case EVENT:
    if (debug)
      fprintf(stderr,"EVENT: %d\n", ent_no);
    break;
  case UNEVENT:
    if (debug)
      fprintf(stderr,"UNEVENT: %d\n", ent_no);
    break;
  case SHOWEVENT:
    if (debug)
      fprintf(stderr,"SHOWEVENT: %d\n", ent_no);
    break;
  case LOCK:
  case UNLOCK:
    node_ptr = (HBNODE *)find_node(ent_no, node_root);
    if (node_ptr->num == ent_no) /* did we find it ? */
    {
      if (operation == LOCK)
      {
	if (debug)
	  fprintf(stderr,"LOCK: ent_no = %d, key = %d\n", ent_no, key);
	node_ptr->locked = TRUE;
      }
      else
      {
	if (debug)
	  fprintf(stderr,"UNLOCK: ent_no = %d, key = %d\n", ent_no, key);
	node_ptr->locked = FALSE;
      }
      redraw_if_needed(ent_no);
    }
    break;
  case SHOWLOCK:
    if (debug)
      fprintf(stderr,"SHOWLOCK: %d\n", ent_no);
    break;
  case CONNECT:
    if (debug)
      fprintf(stderr,"CONNECT\n");
    break;
  case DISCONNECT:
    if (debug)
      fprintf(stderr,"DISCONNECT\n");
    break;
  case BROWSER:
    if (debug)
      fprintf(stderr,"BROWSER\n");
    break;
  default:
    if (debug)
      fprintf(stderr,"Received unknown event !!! (`%s', %d, %d, %d)\n",
	  user, ent_no, operation, key);
    break;
  }
}


/*******************************************************************
** setup_events() --- setup the events
*******************************************************************/

setup_events()
{
  extern int eventfd;

  hb_Event(ALLOP, CREATE_NODE, ALLOP);
  hb_Event(ALLOP, DELETE, ALLOP);
  hb_Event(ALLOP, LOCK, ALLOP);
  hb_Event(ALLOP, UNLOCK, ALLOP);
  hb_Event(ALLOP, WRITE, NNAME);
  hb_Event(ALLOP, WRITE, NLASTMODIFIEDDATE);
  hb_Event(ALLOP, WRITE, LNAME);
  hb_Event(ALLOP, WRITE, LLASTMODIFIEDDATE);
  hb_Event(ALLOP, LINK, ALLOP);
  hb_Event(ALLOP, MOVELINK, ALLOP);
  hb_Event(ALLOP, REMOVELINK, ALLOP);

  /*  hb_Event(ALLOP, EVENT, ALLOP);
  hb_Event(ALLOP, UNEVENT, ALLOP);
  hb_Event(ALLOP, SHOWEVENT, ALLOP);
  hb_Event(ALLOP, SHOWLOCK, ALLOP);
  hb_Event(ALLOP, CONNECT, ALLOP);
  hb_Event(ALLOP, DISCONNECT, ALLOP);
  hb_Event(ALLOP, BROWSER, ALLOP); 

  hb_Event(ALLOP, ALLOP, ALLOP); */
  
  notify_set_input_func(baseframe, event_input_func, eventfd);

}
