/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <fcntl.h>		/* file control */
#include <signal.h>		/* signals (alarm etc.) */

#include <sys/types.h>		/* include all the socket stuff */
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>

#include <stdio.h>

#include "hb_config.h"		/* include the HyperBase interface */

#define FALSE 0			/* define TRUE and FALSE */
#define TRUE 1
#define INTSIZE 4		/* define the sizeof int and long */
#define LONGSIZE 4
#define OK 234539

/** Extern variables **/
extern int debug;		/* Global var. to define debug */
extern int socketid;		/* Global var. to define socketid */

/** Global variables **/
int is_connected = FALSE;	/* is_connected=TRUE if the client */
				/* is connected */ 
int readfd;			/* the file descriptor for the read socket */
int writefd;			/*  -    -    -   -     -   -  write  - */
int eventfd;			/*  -    -    -   -     -   -  event  - */

char *network_buffer = NULL;	/* buffer to keep the network */
				/* communication  */
int network_buffer_size = 0;	/* and the size of the network buffer */



/*******************************************************************
** append_network_buffer()
*******************************************************************/

void append_network_buffer(str, str_len)
char *str;
int str_len;
{
  char *tmp, *new_buf;
  int new_size;
  int toggle = 100;
  
  if (network_buffer_size == 0)
  {
    network_buffer_size = INTSIZE;
    network_buffer = (char *)malloc(network_buffer_size);
    memcpy(network_buffer, &toggle, network_buffer_size);
  }
  
  new_size = network_buffer_size + str_len; /* find new size */
  new_buf = tmp = (char *)malloc(new_size); /* allocate new memory */
  memcpy(tmp, network_buffer, network_buffer_size); /* copy old */
  tmp += network_buffer_size;	/* goto end */
  memcpy(tmp, str, str_len);	/* append the string */
  network_buffer_size = new_size; /* new buffer size */
  free(network_buffer);		/* free old memory */
  network_buffer = new_buf;	/* point to new memory */
}


/*******************************************************************
** send_network_buffer()
*******************************************************************/

void send_network_buffer()
{
  int toggel = 100;		/* the TOGGEL name */
  
  append_network_buffer(&toggel, INTSIZE); /* append TOGGEL */
  
  write(writefd, network_buffer, network_buffer_size); /* send! */

  free(network_buffer);		/* free old buffer */
  network_buffer_size = 0;	/* and size = 0 */
}  


/*******************************************************************
** hb_Write() 
*******************************************************************/
		 
int hb_Write(ent_no, key, value, len)
long ent_no;
int key;
char *value;
long len;
{
  int func=WRITE;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  sendsok(value, len);
  /* delete value ??? */
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_multi_Read() 
*******************************************************************/

int hb_multi_Read(ent_no, key)
long ent_no;
int key;
{
  int str[3];

  str[0] = READ;
  str[1] = ent_no;
  str[2] = key;

  append_network_buffer((char *)&str[0], 12);
}


/*******************************************************************
** hb_read_sok_int()
*******************************************************************/

int hb_read_sok_int()
{
  int ret;
  
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Read() 
*******************************************************************/

int hb_Read(ent_no, key, value, len)
long ent_no;
int key;
char **value;
long *len;
{
  int func=READ;
  int ret;
  
  int str[3];

  str[0] = READ;
  str[1] = ent_no;
  str[2] = key;

  (void) write(writefd, (char *)&str[0], (3*INTSIZE));

  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(value, len);
  return ret;
}


/*******************************************************************
** hb_CreateNode()
*******************************************************************/

int hb_CreateNode(ent_no)
long *ent_no;
{
  int func=CREATE_NODE;
  long tmp;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
  {
    read(readfd, &tmp, LONGSIZE);
    *ent_no = tmp;
  }
  return ret;
}


/*******************************************************************
** hb_Delete() 
*******************************************************************/

int hb_Delete(ent_no)
long ent_no;
{
  int func=DELETE;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Link() 
*******************************************************************/

int hb_Link(ent_no, ToNode)
long *ent_no;
long ToNode;
{
  int func=LINK;
  long tmp;
  int ret;
  
  tmp = *ent_no;

  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &tmp, LONGSIZE);
  (void) write(writefd, &ToNode, LONGSIZE);
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
  {
    read(readfd, &tmp, LONGSIZE);
    *ent_no = tmp;
  }
  return ret;
}


/*******************************************************************
** hb_MoveLink() 
*******************************************************************/

int hb_MoveLink(Linkno, NewNode)
long Linkno;
long NewNode;
{
  int func=MOVELINK;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &Linkno, LONGSIZE);
  (void) write(writefd, &NewNode, LONGSIZE);
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_RemoveLink() 
*******************************************************************/

int hb_RemoveLink(ent_no, Link)
long ent_no;
long Link;
{
  int func=REMOVELINK;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &Link, LONGSIZE);
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Event() 
*******************************************************************/

int hb_Event(ent_no, operation, key)
long ent_no;
int operation;
int key;
{
  int func=EVENT;
  int ret;
  int str[4];
  
  str[0] = func;
  str[1] = ent_no;
  str[2] = operation;
  str[3] = key;

  (void) write(writefd, (char *)&str[0], (INTSIZE*4));

  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_UnEvent() 
*******************************************************************/

int hb_UnEvent(ent_no, operation, key)
long ent_no;
int operation;
int key;
{
  int func=UNEVENT;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &operation, INTSIZE);
  (void) write(writefd, &key, INTSIZE);
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_ShowEvent() 
*******************************************************************/

int hb_ShowEvent(Users, ent_no, operation, key)
char **Users;
long ent_no;
int operation;
int key;
{
  int func=SHOWEVENT;
  long larg;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &operation, INTSIZE);
  (void) write(writefd, &key, INTSIZE);
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(Users, &larg);
  return ret;
}


/*******************************************************************
** hb_Lock() 
*******************************************************************/

int hb_Lock(ent_no, key)
long ent_no;
int key;
{
  int func=LOCK;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  read(readfd, &ret, INTSIZE);

  return ret;
}


/*******************************************************************
** hb_UnLock() 
*******************************************************************/

int hb_UnLock(ent_no, key)
long ent_no;
int key;
{
  int func=UNLOCK;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  read(readfd, &ret, INTSIZE);

  return ret;
}


/*******************************************************************
** hb_ShowLock() 
*******************************************************************/

int hb_ShowLock(User, ent_no, key)
char **User;
long ent_no;
int key;
{
  int func=SHOWLOCK;
  long larg;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(User, &larg);
  return ret;
}


/*******************************************************************
** hb_Connect()  ---  get connected to a HyperBase server (that is 
**                    make the read and write sockets)
*******************************************************************/

int hb_Connect(host, username)
char *host;
char *username;
{
  int uniqportfd;		/* uniq port file descriptor */
  int readport, writeport, eventport;	/* ports for read, write and event */
  int ret;				/* return value */
  char i= '\0';			/* terminate a string */
  int toggel = 100;		/* the TOGGEL name */
  
  if (is_connected == TRUE)		/* allready connected */
    return -401;
  
  if(debug)
    fprintf(stderr,"Connect: socketid is: `%d'\n", socketid);

  if(debug)
    fprintf(stderr,"Connect: Conneting to the HyperBase Server ..... ");

  if ((ret=makeclientsock(host, socketid, &uniqportfd)) != 0)
    return ret;
  
  (void) read(uniqportfd, &readport, INTSIZE); /* first the read port */
  if ((ret=makeclientsock(host, readport, &readfd)) != 0) /* the read socket*/
    return ret;

  (void) read(uniqportfd, &writeport, INTSIZE); /* and then the write port */
  if ((ret=makeclientsock(host, writeport, &writefd)) != 0)/* write socket */
    return ret;
  
  (void) read(uniqportfd, &eventport, INTSIZE); /* and then the event port */
  if ((ret=makeclientsock(host, eventport, &eventfd)) != 0)/* event socket */
    return ret;

  (void) close(uniqportfd);		/* I don't need it any more */

  if(debug)
    fprintf(stderr,"OK!\nConnect: readport `%d', writeport `%d' \
and eventport `%d'\n", readport, writeport, eventport);

  write(writefd,username,strlen(username));
  write(writefd,&i,1);

  if(debug)
    fprintf(stderr,"Connect: the username is: `%s'\n",username);
  
  is_connected = TRUE;
  
  return 0;			/* it's all ok */
}


/*******************************************************************
** hb_Disconnect()
*******************************************************************/

int hb_Disconnect()
{
  int func=DISCONNECT, rec;
  
  (void) write(writefd, &func, INTSIZE);
  (void) read(readfd, &rec, INTSIZE);


  is_connected = FALSE;

  if (rec != OK)		/* the server can't disconnect */
    return -405;

  (void) close(readfd);
  (void) close(writefd);
  (void) close(eventfd);

  return 0;
}

/*******************************************************************
** hb_GetEvent()
*******************************************************************/
			     
int hb_GetEvent(event, timelimit, ent_no, operation, key)
char **event;
int timelimit;
long *ent_no;
int *operation;
int *key;
{
  fd_set fds;
  struct timeval waittime;
  int ret;
  
  FD_ZERO(&fds);
  FD_SET(eventfd, &fds);

  if (timelimit == 0)
    ret=select(FD_SETSIZE, &fds, (fd_set *)0,(fd_set *)0,(struct timeval *)0);
  else
  {
    waittime.tv_sec = timelimit;
    waittime.tv_usec = 0;
    ret = select(FD_SETSIZE, &fds, (fd_set *)0,(fd_set *)0,&waittime);
  }
  if (ret <= 0)
    return -411;

  if(hb_ReadEvent(event, ent_no, operation, key) != 0)
    return -411;
  return 0;
}


/*******************************************************************
** hb_ReadEvent()
*******************************************************************/
		     
int hb_ReadEvent(event, ent_no, operation, key)
char **event;
long *ent_no;
int *operation;
int *key;
{
  char c;
  char *eventbuffer = '\0';
  
  read(eventfd, &c, 1); 
  while(c != '\0')
  {
    eventbuffer += c;
    read(eventfd, &c, 1);
  }

  *event = (char *) eventbuffer;

  read(eventfd, &ent_no, LONGSIZE);
  read(eventfd, &operation, INTSIZE);
  read(eventfd, &key, INTSIZE);

  return 0;
}


/*******************************************************************
** hb_Browse()
*******************************************************************/
		     
int hb_Browse(type, vals)
int type;
long *vals[];
{
  int func=BROWSER;   

  long len;
  int ret;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &type, INTSIZE);
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(((char **) vals), &len);
  return ret;
}


/*******************************************************************
** makeclientsock()
*******************************************************************/

int makeclientsock(host, port, fd)
char *host;
int port;
int *fd;
{
  struct sockaddr_in server;
  struct hostent *hp;

  hp = gethostbyname(host);	/* get the inet number */
  if (hp == NULL)
    return -402;

  *fd = (int) socket(AF_INET, SOCK_STREAM, 0); /* make the socket */
  if (*fd < 0)
    return -403;

  (void) bzero(&server, sizeof(server));
  server.sin_family = AF_INET;

  (void) bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
  server.sin_port = htons(port); /* give the port number */
  if (connect(*fd, ((struct sockaddr*)&server), sizeof(server)) < 0)
  {
    (void) close (*fd);
    return -404;
  }
  return 0;
}


/*******************************************************************
** sendsok() 
*******************************************************************/

int sendsok(str, length)
char *str;
long length;
{
  int j;
  char *tmp = str;
  int put;
  
  write(writefd, &length, LONGSIZE); /* send the length */
  
  put = write(writefd, tmp, length);
  if (put != length)
    return 1;
    
  return 0;
}


/*******************************************************************
** receivesok()
*******************************************************************/

int receivesok(str, len)
char **str;
long *len;
{
  int length;
  char *tmp;
  
  read(readfd, &length, LONGSIZE);	/* read the size */
  *len = length;			/* return the length */
  
  *str = tmp = (char *)malloc(length);	/* allocate mem */
  
  while (length > 0)
  {
    int got = read(readfd, tmp, length); /* read all there is room for */
    length -= got;
    tmp += got;
  }
  return 0;
}




  
  
