#!/bin/bash

set -e 

FILE=$1
[ ! -w "$FILE" ] && echo first argument should be a writtable file && exit 1
jq -e . $FILE >/dev/null 2>&1 || (echo $FILE should be a json file && exit 1)

# looks for [string]-dev.[number]
# if not present returns [string]-dev.1
# else version = number +1 and returns [string]-dev.[version]
inc_version() {
  jq '. + {"version": (if .version | contains("-dev") then [.version | match("^(.*)-dev.([0-9]*)$").captures[].string] | .[0] + "-dev." + (.[1]|tonumber|.+1|tostring) else .version + "-dev.1" end)}'
}

# read file
# replace version
# save to buffer
# write the same file
cat <<< $(cat $FILE | inc_version) > $FILE
