#!/usr/bin/python
# Solfege - ear training for GNOME
# Copyright (C) 2007, 2008 Tom Cato Amundsen
# License is GPL, see file COPYING

from __future__ import division

import sys
# Need this to run under debuild, but not from the shell. Strange...
sys.path.insert(0, ".")
import src.i18n
src.i18n.setup(".")
import mpd

header = """
header {
  lesson_id = "generated-hear-tones-%s"
  title = %s
  module = singanswer
  version = "3.9.2"
}
"""

def write_file_copyright(f):
    print >> f, "# Solfege - ear training for GNOME"
    print >> f, "# Copyright (C) 2007, 2008 Tom Cato Amundsen"
    print >> f, "# License is GPL, see file COPYING"
    print >> f, "# Generated by tools/generate_lessonfiles.py"

def question(f, b, c):
    low = 60
    tone_a = mpd.MusicalPitch.new_from_int(low)
    tone_b = mpd.MusicalPitch.new_from_int(low + b)
    tone_c = mpd.MusicalPitch.new_from_int(low + c)
    print >> f, 'question {'
    print >> f, '  question_text = _("Sing the three tones")'
    print >> f, '  music = voice("< %s2 %s %s >")' % (
        (tone_a.get_octave_notename(),
         tone_b.get_octave_notename(),
         tone_c.get_octave_notename()))
    print >> f, '  answer = voice("%s8 %s %s")' % (
        (tone_a.get_octave_notename(),
         tone_b.get_octave_notename(),
         tone_c.get_octave_notename()))
    print >> f, '}'

def three_tones_less_than_octave(filename):
    """3 toner innenfor en oktav
    0 1 2-12
    0 2 3-12
    0 3 4-12
    0 10 11-12
    0 11 12
    a  b  c
    """
    f = open(filename, 'w')
    write_file_copyright(f)
    f.write("""header {
  lesson_id = "80cc940b-c47b-4264-a7b5-6cbd7a997bb0"
  title = _("Triads")
  module = singanswer
  version = "3.9.2"
}
""")
    for b in range(1, 12):
        for c in range(b + 1, 13):
            question(f, b, c)
    f.close()


def three_tones_larger_than_octave(filename):
    """3 toner innenfor en oktav
    0 1  13-24      13==cis  24=c
    0 2  13-24
    0 11 13-24
    0 12 13-24    c c cis-c

   #0 12 13-24
    0 13 14-24
    0 14 15-24
    0 22 23-24
    0 23    24
    a  b  c
    """
    f = open(filename, 'w')
    write_file_copyright(f)
    f.write("""header {
  lesson_id = "3f1c7305-9978-4fe3-9bb3-8c01ff776a08"
  title = _("Triads, difficult")
  module = singanswer
  version = "3.9.2"
}
""")
    for b in range(1, 13):
        for c in range(13, 25):
            question(f, b, c)
    for b in range(13, 24):
        for c in range(b+1, 25):
            question(f, b, c)
    f.close()

def csound_intonation(filename_fmt, mod, intervalname, lesson_id):
    filename = filename_fmt % mod
    f = open(filename, 'w')
    print >> f, "# Solfege - ear training for GNOME"
    print >> f, "# Copyright (C) 2004, 2005 Tom Cato Amundsen"
    print >> f, "# License is GPL, see file COPYING"
    print >> f
    print >> f, "header {"
    print >> f, '    lesson_id = "%s"' % lesson_id
    print >> f, '        module = idbyname'
    print >> f, '        help = "idbyname-intonation"'
    print >> f, '        title = _("Is the fifth flat, in tune or sharp? %%s") %% "(%s)"' % mod
    print >> f, '        filldir = vertic'
    print >> f, '        fillnum = 4'
    print >> f, '}'
    for s, d in enumerate((1, 9/8, 4/3, 3/2, 5/3, 15/8, 2)):
        for label, mult in (("intonation|flat", float(mod)), ("intonation|in tune", 1), ("intonation|sharp", 1/float(mod))):
            print >> f
            print >> f, 'question {'
            print >> f, ' name = _i("%s")' % label
            print >> f, ' set=%i' % s
            print >> f, ' cmdline("./bin/csound-play-harmonic-interval.sh %f %f")' % (220.0 * d, 220.0 * d * 3/2 * mult)
            print >> f, "}"
    f.close()

csound_intonation("lesson-files/csound-fifth-%s", "0.97", "5",
    "b465c807-d7bf-4e3a-a6da-54c78d5b59a1")
csound_intonation("lesson-files/csound-fifth-%s", "0.98", "5",
    "aa5c3b18-664b-4e3d-b42d-2f06582f4135")
csound_intonation("lesson-files/csound-fifth-%s", "0.99", "5",
    "5098fb96-c362-45b9-bbb3-703db149a079")
csound_intonation("lesson-files/csound-fifth-%s", "0.995", "5",
    "3b1f57e8-2983-4a74-96da-468aa5414e5e")
csound_intonation("lesson-files/csound-fifth-%s", "0.996", "5",
    "a06b5531-7422-4ea3-8711-ec57e2a4ce22")
csound_intonation("lesson-files/csound-fifth-%s", "0.997", "5",
    "e67c5bd2-a275-4d9a-96a8-52e43a1e8987")
csound_intonation("lesson-files/csound-fifth-%s", "0.998", "5",
    "1cadef8c-859e-4482-a6c4-31bd715b4787")
three_tones_less_than_octave("lesson-files/hear-tones-triads")
three_tones_larger_than_octave("lesson-files/hear-tones-triads-difficult")
