# awk script for soversions.i -> gnu/lib-names.h; see Makeconfig.

$1 != "DEFAULT" { multi = 1 }

#
{
  lib = $2;
  version = $3;
  if ($3 !~ /^[0-9]/) {
    soname = $3;
    extra = $3;
    sub(/\.so.*$/, "", extra);
  }
  else {
    soname = lib ".so." $3;
    extra = "";
  }
  soname = "\"" soname "\"";
  lib = toupper(lib);
  extra = toupper(extra);
  gsub(/-/, "_", lib);
  gsub(/-/, "_", extra);
  macros[$1 FS lib "_SO"] = soname;
  if (extra)
    macros[$1 FS extra "_SO"] = soname;
}

END {
  print "/* This file is automatically generated.";
  print "   It defines macros to allow user program to find the shared";
  print "   library files which come as part of GNU libc.  */";
  print "#ifndef __GNU_LIB_NAMES_H";
  print "#define __GNU_LIB_NAMES_H	1";
  print "";

  pfx = multi ? "# define " : "#define ";
  for (elt in macros) {
    split(elt, x);
    line = sprintf("%-40s%s", pfx x[2], macros[elt]);
    if (x[1] in lines)
      lines[x[1]] = lines[x[1]] "\n" line;
    else
      lines[x[1]] = line;
  }

  if (multi) {
    # Print these in a fixed order so the result is identical
    # on both sides of the coin.
    if (!("WORDSIZE32" in lines))
      lines["WORDSIZE32"] = lines["DEFAULT"];
    if (!("WORDSIZE64" in lines))
      lines["WORDSIZE64"] = lines["DEFAULT"];
    print "#include <bits/wordsize.h>\n";
    print "#if __WORDSIZE == 32";
    cmd = "LC_ALL=C sort"; print lines["WORDSIZE32"] | cmd; close(cmd);
    print "#else"
    cmd = "LC_ALL=C sort"; print lines["WORDSIZE64"] | cmd; close(cmd);
    print "#endif";
  }
  else {
    cmd = "LC_ALL=C sort"; print lines["DEFAULT"] | cmd; close(cmd);
  }

  print "";
  print "#endif	/* gnu/lib-names.h */"
}
