/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.testbed;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.gnunet.util.Configuration;

public class CompressedConfig {
    public final byte[] compressedData;
    private int uncompressedSize;

    public CompressedConfig(Configuration cfg) {
        byte[] serializedConfig = cfg.serialize().getBytes();
        Deflater compresser = new Deflater();
        compresser.setInput(serializedConfig);
        compresser.finish();
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!compresser.finished()) {
            int n = compresser.deflate(buf);
            s.write(buf, 0, n);
        }
        this.compressedData = s.toByteArray();
        this.uncompressedSize = serializedConfig.length;
    }

    public CompressedConfig(byte[] compressedData) {
        this.compressedData = compressedData;
        this.uncompressedSize = -1;
    }

    public Configuration decompress() {
        Inflater inflater = new Inflater();
        inflater.setInput(this.compressedData);
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            int n;
            try {
                n = inflater.inflate(buf);
            }
            catch (DataFormatException e) {
                return null;
            }
            s.write(buf, 0, n);
        }
        String str = new String(s.toByteArray(), Charsets.UTF_8);
        Configuration cfg = new Configuration();
        cfg.deserialize(str);
        return cfg;
    }

    public int getUncompressedSize() {
        if (this.uncompressedSize == -1) {
            this.uncompressedSize = this.decompress().serialize().getBytes().length;
        }
        return this.uncompressedSize;
    }
}

