/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { h, VNode } from "preact";
import { InputProps, useField } from "./useField.js";

interface Props<T> extends InputProps<T> {
  readonly?: boolean;
  expand?: boolean;
  values: any[];
  toStr?: (v?: any) => string;
  fromStr?: (s: string) => any;
}

const defaultToString = (f?: any): string => f || "";
const defaultFromString = (v: string): any => v as any;

export function InputTab<T>({
  name,
  readonly,
  expand,
  placeholder,
  tooltip,
  label,
  help,
  values,
  fromStr = defaultFromString,
  toStr = defaultToString,
}: Props<keyof T>): VNode {
  const { error, value, onChange, required } = useField<T>(name);
  return (
    <div class="field is-horizontal">
      <div class="field-label is-normal">
        <label class="label">
          {label}
          {tooltip && (
            <span class="icon has-tooltip-right" data-tooltip={tooltip}>
              <i class="mdi mdi-information" />
            </span>
          )}
        </label>
      </div>
      <div class="field-body is-flex-grow-3">
        <div class="field has-icons-right">
          <p class={expand ? "control is-expanded " : "control  "}>
            <div class="tabs is-toggle is-fullwidth is-small">
              <ul>
                {values.map((v, i) => {
                  return (
                    <li key={i} class={value === v ? "is-active" : ""}
                      onClick={(e) => { onChange(v) }}
                    >
                      <a style={{ cursor: "initial" }}>
                        <span>{toStr(v)}</span>
                      </a>
                    </li>
                  );
                })}
              </ul>
            </div>
            {help}
          </p>
          {required && (
            <span class="icon has-text-danger is-right" style={{ height: "2.5em" }}>
              <i class="mdi mdi-alert" />
            </span>
          )}
          {error && <p class="help is-danger">{error}</p>}
        </div>
      </div>
    </div>
  );
}
