/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// htmlgeneratorfactory.cc

#include "htmlgeneratorfactory.h"

#include "html_chartranslator.h"
#include "htmltags.h"
#include "htmldocgenerator.h"
#include "colormap.h"
#include "colors.h"
#include "htmltaggen.h"

HtmlGeneratorFactory::HtmlGeneratorFactory(const string &t,
    const string &i, const string &h, const string &f, const string &c) :
  GeneratorFactory (t),
  input_file_name (i), doc_header (h),
  doc_footer (f), css_url (c)
{
}

CharTranslator *
HtmlGeneratorFactory::createCharTranslator()
{
  return new HtmlCharTranslator ();
}

DocGenerator *
HtmlGeneratorFactory::createDocGenerator()
{
  return new HtmlDocGenerator (title, input_file_name, doc_header, doc_footer,
                               css_url);
}

ColorMap *
HtmlGeneratorFactory::createColorMap()
{
  ColorMap *cm = new ColorMap;

  (*cm)[ GREEN ] ="#33CC00";
  (*cm)[ RED ] ="#FF0000";
  (*cm)[ DARKRED ] ="#990000";
  (*cm)[ BLUE ] ="#0000FF";
  (*cm)[ BROWN ] ="#9A1900";
  (*cm)[ PINK ] ="#CC33CC";
  (*cm)[ YELLOW ] ="#FFCC00";
  (*cm)[ CYAN ] ="#66FFFF";
  (*cm)[ PURPLE ] ="#993399";
  (*cm)[ ORANGE ] ="#FF6600";
  (*cm)[ BRIGHTORANGE ] ="#FF9900";
  (*cm)[ BRIGHTGREEN ] ="#33FF33";
  (*cm)[ DARKGREEN ] ="#009900";
  (*cm)[ BLACK ] ="#000000";
  (*cm)[ TEAL ] ="#008080";
  (*cm)[ GRAY ] ="#808080";
  (*cm)[ DARKBLUE ] ="#000080";

  cm->setDefault ("#000000");

  return cm;
}

void
HtmlGeneratorFactory::addBold()
{
  addStartTag(startTAG(BOLD_TAG, "", ""));
  addCloseTag(endTAG(BOLD_TAG));
}

void
HtmlGeneratorFactory::addItalic()
{
  addStartTag(startTAG(ITALIC_TAG, "", ""));
  addCloseTag(endTAG(ITALIC_TAG));
}

void
HtmlGeneratorFactory::addUnderline()
{
  addStartTag(startTAG(UNDERLINE_TAG, "", ""));
  addCloseTag(endTAG(UNDERLINE_TAG));
}

void
HtmlGeneratorFactory::addColor(const string &color)
{
  addStartTag(startTAG(FONT_TAG, COLOR_TAG, color));
  addCloseTag(endTAG(FONT_TAG));  
}

