//
// C++ Implementation: srcuntabifier
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "srcuntabifier.h"
#include "tags.h"

void
Untabifier::generate (const string & s)
{
      Pretranslator::generate (s);
      n_ += s.size ();
}

void
Untabifier::generate (const string & s, int start, int end)
{
      Pretranslator::generate (s, start, end);
      n_ += 1 + end - start;
}

void
Untabifier::generateln (const string & s)
{
      Pretranslator::generateln (s);
      n_ = 0;
}

void
Untabifier::generate_preproc (const string & s)
{
      Pretranslator::generate_preproc (s);
      n_ += s.size ();
}

void
Untabifier::generate_normal (const string & s)
{
      Pretranslator::generate_normal (s);
      n_ += s.size ();
}

void
Untabifier::generateTab (void)
{
      int nSpaces = nSpacesPerTab_ - n_ % nSpacesPerTab_;
      for (int i = 0; i < nSpaces; i++)
	generate (SPACE_CHAR);
}

void
Untabifier::generateComment (const string & s)
{
      Pretranslator::generateComment (s);
      n_ += s.size ();
}

void
Untabifier::generateString (const string & s)
{
      Pretranslator::generateString (s);
      n_ += s.size ();
}

void
Untabifier::generateKeyWord (const string & s)
{
      Pretranslator::generateKeyWord (s);
      n_ += s.size ();
}

void
Untabifier::generateBaseType (const string & s)
{
      Pretranslator::generateBaseType (s);
      n_ += s.size ();
}

void
Untabifier::generatePreProc (const string & s)
{
      Pretranslator::generatePreProc (s);
      n_ += s.size ();
}

void
Untabifier::generateNumber (const string & s)
{
      Pretranslator::generateNumber (s);
      n_ += s.size ();
}

void
Untabifier::generateSymbol (const string & s)
{
      Pretranslator::generateSymbol (s);
      n_ += s.size ();
}

void
Untabifier::generateFunction (const string & s)
{
      Pretranslator::generateFunction (s);
      n_ += s.size ();
}

void
Untabifier::generateCBracket (const string & s)
{
      Pretranslator::generateCBracket (s);
      n_ += s.size ();
}

void
Untabifier::generate( const std::string &elem, const std::string &s )
{
  Pretranslator::generate(elem, s);
  n_ += s.size();
}

void
Untabifier::generate( const std::string &elem, const std::string &s, int start, int end )
{
  Pretranslator::generate(elem, s, start, end);
  n_ += 1 + end - start;
}

void
Untabifier::generate_preproc(const std::string &elem, const std::string &s)
{
  Pretranslator::generate_preproc(elem, s);
  n_ += s.size();
}

void
Untabifier::generateln( const std::string &elem, const std::string &s )
{
  Pretranslator::generateln(elem, s);
  n_ = 0;
}

void
Untabifier::generateEntire( const std::string &elem, const std::string &s )
{
  Pretranslator::generateEntire(elem, s);
  n_ += s.size();
}

void
Untabifier::beginText( const std::string &elem, const std::string &s )
{
  Pretranslator::beginText(elem, s);
  n_ += s.size();
}

void
Untabifier::endText( const std::string &elem, const std::string &s )
{
  Pretranslator::endText(elem, s);
  n_ += s.size();
}
