/* LocaleInformation_pt.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_pt extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Dinar jordaniano|Mvdol boliviano|Ouro|Coroa das Ilhas Fero\u00e9|Libra libanesa|Euro|Dong vietnamita|Xelim de Tanz\u00e2nia|Peso boliviano|Riel cambojano|Unidade Monet\u00e1ria Asi\u00e1tica|Boliviano (1863-1962)|Riel Antigo do Camboja|Libra zambiana|Libra australiana|Franco CFA BEAC|Libra maltesa|Cedi reajustado de Gana|Cuacha zambiano|Unidade de Conta asi\u00e1tica em dinares|Libra de Gana|Boliviano|Cedi Antigo de Gana|Lira maltesa|D\u00f3lar australiano|D\u00f3lar norte-americano (Mesmo dia)|Lira italiana|D\u00f3lar norte-americano (Dia seguinte)|Cedi de Gana|D\u00f3lar de Cingapura|Balboa panamenho|Kip de Laos|Som de Quirguist\u00e3o|Franco su\u00ed\u00e7o|Xelim austr\u00edaco|D\u00f3lar norte-americano|D\u00f3lar et\u00edope|D\u00f3lar do Brunei|Libra jamaicana|Birr et\u00edope|Franco Germinal argelino|Franco Novo argelino|Dinar argelino|Guarani paraguaio|Libra l\u00edbia|D\u00f3lar jamaicano|Coroa islandesa|Peseta espanhola|Libra das Bermudas|Dinar l\u00edbio|Lira l\u00edbia da Autoridade Militar Brit\u00e2nica|D\u00f3lar das Bermudas|Guilder holand\u00eas|Ouguiya da Maurit\u00e2nia|Rial iraniano|Coroa sueca|Nakfa da Eritr\u00e9ia|Xelim queniano|Franco da Rep\u00fablica Centro-Africana CFA|Peso argentino|Peso argentino (1983-1985)|Peso moneda nacional argentino|D\u00f3lar Novo de Taiwan|Libra sudanesa|Lari georgiano|Cupom Lari georgiano|Franco da Martinica|Libra das Malvinas|Austral argentino|Dinar sudan\u00eas|Dinar iraquiano|D\u00f3lar de Tuvalu|Rupia das Seychelles|Rublo let\u00e3o|Libra de Fiji|Lats let\u00e3o|Zaire congol\u00eas|Franco da Rep\u00fablica do Congo|Franco congol\u00eas|D\u00f3lar de Fiji|C\u00f3rdoba Ouro nicaraguano|Pataca macaense|C\u00f3rdoba Ouro nicaraguano|C\u00f3rdoba nicaraguano|Rublo transfer\u00edvel do COMECON|Marca finlandesa (1860-1962)|Marca finlandesa|D\u00f3lar das Ilhas Salom\u00e3o|Franco luxemburgu\u00eas|D\u00f3lar Antigo de Trinidad e Tobago|Escudo angolano|Cuanza angolano reajustado (1995-1999)|Tugrik mongol|Forinte h\u00fangaro|Franco do Burundi|Cuanza novo angolano (1990-2000)|Cuanza angolano (1977-1990)|D\u00f3lar de Trinidad e Tobago|Lilangeni da Suazil\u00e2ndia|Franco CFP das Novas H\u00e9bridas|Libra esterlina brit\u00e2nica|Rial Soberano saudita|Rial saudita|Talonas lituano|Rupia indiana|Escudo portugu\u00eas|Cuanza angolano|Conto portugu\u00eas|Lita lituano|Tenge do Cazaquist\u00e3o|Rublo do Cazaquist\u00e3o|D\u00f3lar das Ilhas Virgens Brit\u00e2nicas|Libra nigeriana|Certificados de c\u00e2mbio birmaneses em d\u00f3lares|Naira nigeriana|Gurde do Haiti|Libra s\u00edria|Libra palestina|Dinar bareinita|Kyat de Mianmar|Guilder das Antilhas Holandesas|Coroa da Rep\u00fablica Checa|Libra esterlina da Ilha de Man|Certificados de c\u00e2mbio b\u00falgaros em leva|Loti de Lesoto|Franco do Gab\u00e3o CFA|Lev b\u00falgaro (1879-1952)|Lev novo b\u00falgaro|Lev socialista b\u00falgaro|D\u00f3lar canadense|Lev forte b\u00falgaro|Lira turca|D\u00f3lar das Ilhas Caim\u00e3o|Libra de Chipre|Sheqel Novo israelita|D\u00f3lar da Guiana|Dram Arm\u00e9nio|Libra israelita|Franco de Mali|Sheqel israelita|Bol\u00edvar venezuelano|Certificados de c\u00e2mbio albaneses em d\u00f3lares|D\u00f3lar liberiano|Lek Valute Alban\u00eas|Kuna croata|Franco de Reuni\u00e3o|Dinar croata|Lek Alban\u00eas|Libra esterlina de Jersey|Dinar maced\u00f4nio (1992-1993)|Viet Minh Piastre Dong Viet do Vietn\u00e3 do Norte|Dong Novo do Vietn\u00e3 do Norte|Dinar maced\u00f4nio|Piastre Dong Viet do Vietn\u00e3 do Norte|Pataca timorense|Franco CFP|Franco belga (financeiro)|Peso da Guin\u00e9-Bissau|Dinar coveitiano|Mil-r\u00e9is da Guin\u00e9 Portuguesa|Franco belga|Escudo timorense|Franco belga (convers\u00edvel)|Escudo da Guin\u00e9 Portuguesa|Colom salvadorenho|Guilder de Cura\u00e7au|Taka de Bangladesh|Libra esterlina de Tonga|Pa\u02bbanga de Tonga|Franco CFA BCEAO|Rublo sovi\u00e9tico|Rublo Novo sovi\u00e9tico|Franco Germinal da Nova Caled\u00f4nia|Escudo cabo-verdiano|Franco CFA das Antilhas Francesas|Rand sul-africano|Peso dominicano|Certificados de c\u00e2mbio cubanos|Libra sul-africana|Rand sul-africano (financeiro)|Dinar tunisiano|Peso cubano|Franco da Guiana Francesa|Xelim ugandense|Rupia do Ceil\u00e3o|Franco de Affars e Issas|Lira da Cidade do Vaticano|Escudo de S\u00e3o Tom\u00e9 e Pr\u00edncipe|Xelim ugandense (1966-1987)|Dobra de S\u00e3o Tom\u00e9 e Pr\u00edncipe|D\u00f3lar das Ilhas Marshall|Libra da Nova Zel\u00e2ndia|Tala de Samoa Ocidental|Libra de Samoa Ocidental|Lempira de Honduras|Franco Novo Metropolitano franc\u00eas|Manat do Turcomenist\u00e3o|Quet\u00e7al da Guatemala|D\u00f3lar da Nova Zel\u00e2ndia|Libra escocesa|D\u00f3lar de Barbados|D\u00f3lar da Nam\u00edbia|Franco de Madagascar|Ariary de Madagascar|Libra eg\u00edpcia|D\u00f3lar de Honduras Brit\u00e2nica|Zloti polon\u00eas (1950-1995)|Dinar novo da B\u00f3snia-Herzeg\u00f3vina|Certificados de c\u00e2mbio poloneses em d\u00f3lares|Marco b\u00f3snio-herzeg\u00f3vino convers\u00edvel|D\u00f3lar do Belize|Dinar da B\u00f3snia-Herzeg\u00f3vina|Zloti polon\u00eas|Rial iemenita|Guilder do Suriname|Coroa Forte checoslovaca|Won sul-coreano|Rublo bielo-russo|Rial Imadi iemenita|Rublo bielo-russo (1992-1994)|Coroa checoslovaca|Won Antigo sul-coreano|Hwan sul-coreano|Rublo novo bielo-russo (1994-1999)|Xelim de Somalil\u00e2ndia|Dracma Novo grego|Rupia paquistanesa|Afegane|D\u00f3lar do Zimb\u00e1bwe|Rupia de Sri Lanka|Dracma grego|Libra irlandesa|Afegane (1927-2002)|Dinar iemenita|Franco ruand\u00eas|Colon da Costa Rica|Somoni tadjique|Rublo do Tadjiquist\u00e3o|Coroa estoniana|Peseta Guineana de Guin\u00e9 Equatorial|Cupom rublo mol\u00e1vio|D\u00f3lar de Hong Kong|Coroa dinamarquesa|Leu de Mold\u00e1via|Franco de Guin\u00e9 Equatorial|Ekwele de Guin\u00e9 Equatorial|Rupia indon\u00e9sia|Dir\u00e9m dos Emirados \u00c1rabes Unidos|Won norte-coreano|Rupia Nova indon\u00e9sia|Pula botsuanesa|Cupom leu mold\u00e1vio|Rupia Java indon\u00e9sia|Won da Rep\u00fablica Popular da Cor\u00e9ia do Norte|Guilder Nica indon\u00e9sio|Vatu de Vanuatu|Dinar isl\u00e2mico|Xelim somali|Peseta de Andorra|Rublo russo (1991-1998)|Franco de Guadalupe|Franco do Djibuti|Diner de Andorra|Franco Germinal de M\u00f4naco|Franco Novo de M\u00f4naco|Unidad de Valor Constante (UVC) do Equador|Sucre equatoriano|Franco de Liechtenstein|Rublo russo|Peso filipino|Sum do Usbequist\u00e3o|Peso colombiano|Baht tailand\u00eas|Libra da Irlanda do Norte|Rupia birmanesa|Franco do Congo CFA|Kyat birman\u00eas|Peso de Papel colombiano|Coupon Som do Usbequist\u00e3o|Karbovanetz ucraniano|Rial catariano|Hryvnia ucraniano|Syli de Guin\u00e9|Yuan Renminbi chin\u00eas|Metical de Mo\u00e7ambique|Certificados de c\u00e2mbio chineses em d\u00f3lares dos EUA|Peso uruguaio|Franco de Guin\u00e9 (1960-1972)|Lira de San Marino|Jen Min Piao Yuan chin\u00eas|Escudo de Mo\u00e7ambique|Franco de Guin\u00e9|Rial Saidi de Om\u00e3|Kina da Papua-Nova Guin\u00e9|Rial de Om\u00e3|Peso uruguaio (1975-1993)|Franco UIC franc\u00eas|Rupia do But\u00e3o|Zaire zairense|Franco marroquino|Dir\u00e9m marroquino|Ngultrum do But\u00e3o|Franco-ouro franc\u00eas|Peso Fuerte uruguaio|Ringgit malaio|Zaire Novo zairense|Manat azerbaijano|Libra de G\u00e2mbia|Franco de Comores|Leone de Serra Leoa|Dalasi de G\u00e2mbia|Unidade Monet\u00e1ria Europ\u00e9ia|Libra das Bahamas|Franco dos Camar\u00f5es CFA|Unidad de Inversion (UDI) mexicana|Franco CFA BCEAEC|D\u00f3lar das Bahamas|Peso Plata mexicano (1861-1992)|Peso mexicano|Sol peruano|Coroa de Groenl\u00e2ndia|Cruzeiro brasileiro (1942-1967)|Sol Novo peruano|Peso chileno|Coroa eslovaca|Inti peruano|Cruzeiro brasileiro|Direitos Especiais de Giro|Franco Germinal franc\u00eas/Franco Poincar\u00e9|Franco franc\u00eas|Cruzado novo brasileiro|Unidades de Fomento chilenas|Escudo chileno|Real brasileiro|Condor chileno|Cruzeiro brasileiro (1990-1993)|Sperrmark alem\u00e3o|Libra do Mal\u00e1ui|Cruzado brasileiro|Cruzeiro novo brasileiro(1967-1986)|Cuacha do Mal\u00e1ui|Rublo de Transdniestria|Marco alem\u00e3o|Franco CFA de Chade|Rublo Novo de Transdniestria|Cupom rublo de Transdniestria|Rupia nepalesa|D\u00f3lar das Ilhas Cook|Iene japon\u00eas|Rupias das Ilhas Maldivas|Franco Novo CFA|Rupia das Ilhas Maldivas|D\u00f3lar do Caribe Oriental|Tolar Bons esloveno|Dinar reformado iugoslavo|Guilder de Aruba|Dinar de outubro iugoslavo|Ostmark da Alemanha Oriental|Dinar convers\u00edvel iugoslavo|Super Dinar iugoslavo|Coroa de Turcas e Caicos|Dinar iugoslavo de 1994|Dinar da Federa\u00e7\u00e3o Iugoslava|Leu Novo romeno|Dinar forte iugoslavo|Leu romeno|Tolar Bons esloveno|Coroa norueguesa|Rupia de Maur\u00edcio|Unidade de Conta Europ\u00e9ia (XBD)|Libra de Gibraltar|Dong Nacional vietnamita|Unidade de Conta Europ\u00e9ia (XBC)|Dong da Rep\u00fablica do Vietn\u00e3|Unidade Monet\u00e1ria Europ\u00e9ia|Unidade Composta Europ\u00e9ia|D\u00f3lar do Quiribati|Libra de Santa Helena|Dong Novo vietnamita";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|BOV|XAU|FOK|LBP|\u0111|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|Esc.|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|MKN|VDP|VDN|MKD|VDD|TPP|CFPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YRl|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFA|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "fev",
    "mar",
    "abr",
    "mai",
    "jun",
    "jul",
    "ago",
    "set",
    "out",
    "nov",
    "dez",
    null,
  };

  private static final String[] months = {
    "janeiro",
    "fevereiro",
    "mar\u00e7o",
    "abril",
    "maio",
    "junho",
    "julho",
    "agosto",
    "setembro",
    "outubro",
    "novembro",
    "dezembro",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dom",
    "seg",
    "ter",
    "qua",
    "qui",
    "sex",
    "s\u00e1b",
  };

  private static final String[] weekdays = {
    null,
    "domingo",
    "segunda-feira",
    "ter\u00e7a-feira",
    "quarta-feira",
    "quinta-feira",
    "sexta-feira",
    "s\u00e1bado",
  };

  private static final String[] eras = {
    "a.C.",
    "d.C.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico", "PDT", "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico",  "America/Los_Angeles" },
    { "GMT", "Hor\u00e1rio do Meridiano de Greenwich", "GMT", "Hor\u00e1rio do Meridiano de Greenwich",  "Africa/Casablanca" },
    { "EST", "Hor\u00e1rio Padr\u00e3o Oriental", "EDT", "Hor\u00e1rio de Ver\u00e3o Oriental",  "America/New_York" },
    { "AST", "Hor\u00e1rio Padr\u00e3o do Alasca", "ADT", "Hor\u00e1rio de Ver\u00e3o do Alasca",  "America/Anchorage" },
    { "GMT", "Hor\u00e1rio do Meridiano de Greenwich", "GMT", "Hor\u00e1rio do Meridiano de Greenwich",  "Etc/GMT" },
    { "CTT", "Hor\u00e1rio Padr\u00e3o da China", "CDT", "Hor\u00e1rio Padr\u00e3o da China",  "Asia/Shanghai" },
    { "AST", "Hor\u00e1rio Padr\u00e3o Atl\u00e2ntico", "ADT", "Hor\u00e1rio de Ver\u00e3o Atl\u00e2ntico",  "America/Halifax" },
    { "CET", "Hor\u00e1rio Padr\u00e3o Europa Central", "CEST", "Hor\u00e1rio de Ver\u00e3o Europa Central",  "Europe/Paris" },
    { "MST", "Hor\u00e1rio Padr\u00e3o Montanha", "MDT", "Hor\u00e1rio de Ver\u00e3o Montanha",  "America/Denver" },
    { "IST", "Hor\u00e1rio Padr\u00e3o de Israel", "IDT", "Hor\u00e1rio de Ver\u00e3o de Israel",  "Asia/Jerusalem" },
    { "HST", "Hor\u00e1rio Padr\u00e3o do Hava\u00ed", "HST", "Hor\u00e1rio Padr\u00e3o do Hava\u00ed",  "Pacific/Honolulu" },
    { "CNT", "Hor\u00e1rio Padr\u00e3o de Terra Nova", "CDT", "Hor\u00e1rio de Ver\u00e3o de Terra Nova",  "America/St_Johns" },
    { "EST", "Hor\u00e1rio Padr\u00e3o Oriental", "EST", "Hor\u00e1rio Padr\u00e3o Oriental",  "America/Indianapolis" },
    { "CST", "Hor\u00e1rio Padr\u00e3o Central", "CDT", "Hor\u00e1rio de Ver\u00e3o Central",  "America/Chicago" },
    { "EET", "Hor\u00e1rio Padr\u00e3o da Europa Oriental", "EEST", "Hor\u00e1rio de Ver\u00e3o da Europa Oriental",  "Europe/Bucharest" },
    { "JST", "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o", "JST", "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o",  "Asia/Tokyo" },
    { "MST", "Hor\u00e1rio Padr\u00e3o Montanha", "MST", "Hor\u00e1rio Padr\u00e3o Montanha",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor Leste|Tokelau|Tadjiquist\u00e3o|Tail\u00e2ndia|Togo|Territ\u00f3rios Franceses do Sul|Guiana|Chade|Ilhas Turks e Caicos|Guin\u00e9 Bissau|Guam|Guatemala|Ge\u00f3rgia do Sul e Ilhas Sandwich do Sul|Gr\u00e9cia|Guin\u00e9 Equatorial|Guadalupe|Suazil\u00e2ndia|S\u00edria|Guin\u00e9|G\u00e2mbia|Gro\u00eanlandia|El Salvador|S\u00e3o Tom\u00e9 e Pr\u00edncipe|Gibraltar|Gana|Suriname|Guiana Francesa|S\u00e9rvia|Ge\u00f3rgia|Som\u00e1lia|Granada|Senegal|San Marino|Reino Unido|Serra Leoa|Gab\u00e3o|Eslov\u00e1quia|Svalbard e Jan Mayen|Eslov\u00eania|Santa Helena|Cingapura|Su\u00e9cia|Sud\u00e3o|Seychelles|Ilhas Salom\u00e3o|Ar\u00e1bia Saudita|Fran\u00e7a|Ilhas Faroe|Micron\u00e9sia, Estados Federados da|Ruanda|Ilhas Malvinas|R\u00fassia|Fiji|Finl\u00e2ndia|Rom\u00eania|Reuni\u00e3o|Eti\u00f3pia|Espanha|Eritr\u00e9ia|Saara Ocidental|Egito|Est\u00f4nia|Equador|Arg\u00e9lia|Catar|Rep\u00fablica Dominicana|Paraguai|Dominica|Palau|Dinamarca|Djibuti|Portugal|Territ\u00f3rio da Palestina|Porto Rico|Alemanha|Pitcairn|Saint Pierre e Miquelon|Pol\u00f4nia|Paquist\u00e3o|Filipinas|Papua-Nova Guin\u00e9|Polin\u00e9sia Francesa|Rep\u00fablica Tcheca|Peru|Chipre|Ilhas Natal|Cabo Verde|Panam\u00e1|Cuba|Costa Rica|Col\u00f4mbia|China|Rep\u00fablica dos Camar\u00f5es|Chile|Ilhas Cook|Costa do Marfim|Su\u00ed\u00e7a|Congo|Rep\u00fablica Centro-Africana|Congo, Rep\u00fablica Democr\u00e1tica do|Ilhas Cocos (Keeling)|Om\u00e3|Canad\u00e1|Belize|Belarus|Botsuana|Ilha Bouvet|But\u00e3o|Bahamas|Brasil|Nova Zel\u00e2ndia|Bol\u00edvia|Brunei|Bermudas|Niue|Benin|Burundi|Bareine|Nauru|Bulg\u00e1ria|Burquina Faso|Nepal|B\u00e9lgica|Noruega|Bangladesh|Barbados|Zimb\u00e1bwe|Pa\u00edses Baixos|B\u00f3snia-Herzeg\u00f3vina|Nicar\u00e1gua|Nig\u00e9ria|Ilha Norfolk|Azerbaij\u00e3o|N\u00edger|Nova Caled\u00f4nia|Aruba|Z\u00e2mbia|Nam\u00edbia|Austr\u00e1lia|\u00c1ustria|Samoa Americana|Argentina|Ant\u00e1rtida|Mo\u00e7ambique|Angola|Mal\u00e1sia|Antilhas Holandesas|M\u00e9xico|Arm\u00eania|Malawi|Alb\u00e2nia|Maldivas|\u00c1frica do Sul|Maur\u00edcio|Malta|Anguilla|Montserrat|Maurit\u00e2nia|Ant\u00edgua e Barbuda|Martinica|Afeganist\u00e3o|Ilhas Marianas do Norte|Emirados \u00c1rabes Unidos|Macau, Regi\u00e3o Admin. Especial da China|Andorra|Mong\u00f3lia|Mianm\u00e1|Mali|Maced\u00f4nia, Rep\u00fablica da|Iugosl\u00e1via|Mayotte|Ilhas Marshall|Madagascar|Moldova, Rep\u00fablica de|M\u00f4naco|Marrocos|I\u00eamen|L\u00edbia|Let\u00f4nia|Luxemburgo|Litu\u00e2nia|Lesoto|Lib\u00e9ria|Sri Lanka|Liechtenstein|Santa L\u00facia|L\u00edbano|Rep\u00fablica Democr\u00e1tica Popular de Lao|Casaquist\u00e3o|Ilhas Caiman|Kuwait|Cor\u00e9ia, Sul|Cor\u00e9ia, Norte|S\u00e3o Cristov\u00e3o e Nevis|Comores|Quiribati|Samoa|Camboja|Quirguist\u00e3o|Qu\u00eania|Wallis e Futuna|Jap\u00e3o|Jord\u00e2nia|Jamaica|Vanuatu|Vietn\u00e3|Ilhas Virgens dos EUA|Ilhas Virgens Brit\u00e2nicas|Venezuela|S\u00e3o Vicente e Granadinas|Vaticano|It\u00e1lia|Isl\u00e2ndia|Ir\u00e3|Iraque|Uzbequist\u00e3o|Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico|Uruguai|\u00cdndia|Israel|Estados Unidos|Irlanda|Indon\u00e9sia|Ilhas Menores Distantes dos Estados Unidos|Uganda|Ucr\u00e2nia|Hungria|Haiti|Cro\u00e1cia|Tanz\u00e2nia|Honduras|Ilha Heard e Ilhas McDonald|Taiwan|Tuvalu|Hong Kong, Regi\u00e3o Admin. Especial da China|Trinidad e Tobago|Turquia|Tonga|Tun\u00edsia|Turcomenist\u00e3o";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|bua|mas|os|map|or|man|mak|om|mai|oj|mag|mad|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwich\u02bbin|acadiano|ekajuk|xosa|sum\u00e9rio|sosso|idiomas diversos|lozi|togan\u00eas (Nyasa)|pohnpeian|minangkabau|sukuma|uolofe|mongo|kutenai|miquemaque|walloon|kumyk|zapoteca|cuxitas (outros)|lojban|dogri|volapuque|idiomas otomanos|vietnamita|rarotongano|venda|rapanui|rajastani|turco, otomano (1500-1928)|nzima|napolitano|usbeque|ugar\u00edtico|tamaxeque|ind\u00edgenas norte-americanos (outros)|n\u00e1uatle|urdu|fanti|ucraniano|eg\u00edpcio (arcaico)|uighur|fangue|nilo-saarianos (outros)|irland\u00eas, medieval (900-1200)|b\u00e1lticos (outros)|nyoro|basa|nyankole|nyamwezi|hmong|balin\u00eas|osage|bal\u00fachi|taitiano|bamileke Languages|twi|serere|tlinguite|tatar|tsonga|banda|turco|tonga (ilhas tonga)|tswana|turcomano|tigr\u00ednia|tailand\u00eas|kurukh|tadjique|Blin|telugu|kru|kashubian|t\u00e2mil|toquelauano|efique|sua\u00edli|sueco|sundan\u00eas|karachay-Balkar|soto, do sul|swati|s\u00e9rvio|alban\u00eas|mende|crioulos e p\u00eddgins (outros)|somali|Afrihili|eslov\u00eanio|grego, arcaico (at\u00e9 1453)|eslovaco|Gerbo|cingal\u00eas|servo-croata|crimean turkish; crimean tatar|afro-asi\u00e1tico (outros)|sango|northern sami|sindi|udmurt|sardo|s\u00e2nscrito|kinyarwanda|russo|mandar|romeno|rundi|rhaeto-romance|mocsa|adyghe|zunhi|kpelle|qu\u00edchua|tigr\u00e9|songai|crioulos e p\u00eddgin, portugu\u00eas (outros)|sogdien|adangme|kosraean|hitita|crioulos e p\u00eddgin, franc\u00eas (outros)|crioulos e p\u00eddgin, ingl\u00eas (outros)|himachali|concani|hiligaynon|g\u00f3tico|gorontalo|gondi|dinka|idiomas n\u00fabios|portugu\u00eas|pashto (pushto)|friulano|fen\u00edcio|alem\u00e3o, arcaico alto (aprox.750-1050)|copta|yapese|acoli|iao|filipinos (outros)|polon\u00eas|achinese|p\u00e1li|panjabi|Buginese|Iban|Buriat|massai|ossetic|austron\u00e9sio|oriya|mandinga|makasar|oromo|maithili|ojibwa|magahi|madur\u00eas|occit\u00e2nico (ap\u00f3s 1500); proven\u00e7al|soto, setentrional|bataque|erzya|dogrib|nianja; chicheua; cheua|maia|navajo|quimbundo|ndebele, south|alem\u00e3o, medieval alto (aprox.1050-1500)|noruegu\u00eas|nynorsk noruegu\u00eas|holand\u00eas|dongo|nepali|ndebele, north|chamic languages|t\u00e9tum|bokm\u00e5l noruegu\u00eas|nauruano|tereno|timne|birman\u00eas|lezghian|malt\u00eas|persa arcaico (aprox. 600-400 a.C.)|malaio|marata|franc\u00eas, arcaico (842-aprox.1400)|mold\u00e1vio|franc\u00eas, medieval (aprox.1400-1600)|mongol|judaico-ar\u00e1bico|malaiala|maced\u00f4nio|maori|marshall\u00eas|malgaxe|marwari|braj|slave|let\u00e3o|luba-catanga|delaware|lituano|laosiano|lingala|limburgish|ewondo|luganda|luxemburgu\u00eas|latim|judaico-persa|votic|sino-tibetanos (outros)|quirguiz|c\u00f3rnico|komi|curdo|idiomas sioux|kashmiri|can\u00fari|Awadhi|coreano|canar\u00eas|cmer|groenland\u00eas|cazaque|romani|Kuanyama|sidamo|quicuio|congol\u00eas|norse, old|georgiano|creek|romances (outros)|nogai|idiomas munda|idiomas m\u00faltiplos|gilbert\u00eas|zande|shan|fom|kalmyk|idiomas australianos|khotanese|japon\u00eas|khoisan (other)|palauano|cheiene|tai (outros)|inuktitut|papiamento|italiano|linguages de sinais|island\u00eas|khasi|cheroqui|pampanga|p\u00e1lavi|chipewyan|ido|choctaw|chinook jargon|mari|tuvinian|banto|pangasin\u00e3|Inupiaq|chuukese|sichuan yi|havaiano|lamba|ibo|chagatai|irland\u00eas, arcaico (at\u00e9 900)|papuanos (outros)|interlingue|indon\u00e9sio|lahnda|dayak|chibcha|interl\u00edngua|ladino|herero|haida|dargwa|arm\u00eanio|idiomas atabascanos|h\u00fangaro|haitiano|dacota|croata|hiri motu|hindi|di\u00fala|hebraico|asturiano|hau\u00e7\u00e1|sorbian languages|manx|guzerate|sem\u00edticos (outros)|selkup|idiomas iroqueses|guarani|galego|arauaqui|geez|artificiais (outros)|ga\u00e9lico escoc\u00eas|iraniano|irland\u00eas|arapaho|araucano|fris\u00e3o|siksika|germ\u00e2nicos (outros)|idiomas i\u00fapique|aramaico|franc\u00eas|fero\u00eas|c\u00e9lticos (outros)|fijiano|finland\u00eas|fula|tuvaluano|cebuano|persa|basco|escoc\u00eas|estoniano|espanhol|esperanto|ingl\u00eas|grego|altaicos (outros)|niueano|idiomas tupi|eve|tumbuka|mossi|dzonga|niger - kordofanian (other)|lushai|ugro-fin\u00eas (outros)|divehi|nias|mohawk|lunda|idiomas apache|luiseno|hupa|bini|alem\u00e3o|luba-Lulua|bikol|washo|indeterminado|waray|dinamarqu\u00eas|holand\u00eas, medieval (aprox. 1050-1350)|walamo|manobo languages|wakashan languages|santali|gal\u00eas|sasak|kabardian|chuvash|eslavo eclesi\u00e1stico|manipuri|tcheco|aramaico samaritano|cree|salishan languages|duala|c\u00f3rsico|ind\u00edgenas sul-americanos (outros)|manchu|iacuto|kawi|inguche|gbaia|sandawe|chamorro|indo-europeus (outros)|bhojpuri|ingl\u00eas, medieval (1100-1500)|karen|\u00edndicos (outros)|chechene|gayo|catal\u00e3o|umbundu|sir\u00edaco|kamba|tsimshian|ingl\u00eas, arcaico (aprox. 450-1100)|kachin|caucasianos (outros)|kabyle|kara-Kalpak|b\u00f3snio|caribe|bret\u00e3o|tibetano|bengali|bambara|ga|ind\u00edgenas centro-americanos (outros)|bislam\u00e1|biari|b\u00falgaro|bielo-russo|caddo|bashkir|zulu|zenaga|proven\u00e7al, arcaico (at\u00e9 1500)|upper sorbian|azerbaijano|aimara|avaric|assam\u00eas|Lower Sorbian|\u00e1rabe|ilocano|elamite|chin\u00eas|aragon\u00eas|idiomas pr\u00e1crito|am\u00e1rico|newari|Akan|zhuang|afric\u00e2ner|av\u00e9stico|abkhazian|afar|ioruba|idiomas algonquianos|ale\u00fate|mon-khmer (other)|i\u00eddiche|drav\u00eddicos (outros)|berbere|alto alem\u00e3o; baixo sax\u00e3o|bemba|beja|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Revisado";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd-MM-yyyy" },
    { "mediumDateFormat", "d/MMM/yyyy" },
    { "longDateFormat", "d' de 'MMMM' de 'yyyy" },
    { "fullDateFormat", "EEEE, d' de 'MMMM' de 'yyyy" },
    { "fullTimeFormat", "HH'H'mm'm'ss's' z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
