/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iostream>

#include "textgen.h"

using namespace std;

TextGenerator::TextGenerator() 
{
}

TextGenerator::TextGenerator(const std::string &pre, const std::string &post) :
  pre_tag(pre), post_tag(post)
{
}

void
TextGenerator::output(const string &s)
{
  outstream << s;
}

void
TextGenerator::output_ln(const string &s)
{
  outstream << s << endl;
}

void
TextGenerator::output(int i)
{
  outstream << i;
}

void
TextGenerator::reset()
{
  outstream.str("");
}

string
TextGenerator::generate(const char *s)
{
  reset();
  output(s);
  return outstream.str();
}

string
TextGenerator::generate(const string &s)
{
  return generate(s.c_str());
}

string
TextGenerator::generate( const string &s, int start, int end )
{
  reset();
  output(s.substr(start, end-start));
  return outstream.str();
}

string
TextGenerator::generateln( const char *s )
{
  reset();
  output_ln(s);
  return outstream.str();
}

string
TextGenerator::generateEntire( const char *s )
{
  reset();
  startTextGeneration() ;
  output(s);
  endTextGeneration() ;
  return outstream.str();
}

string
TextGenerator::generateEntire( const string &s )
{
  return generateEntire(s.c_str());
}

string
TextGenerator::beginText( const char *s )
{
  reset();
  startTextGeneration() ;
  output(s);
  return outstream.str();
}

string
TextGenerator::beginText( const string &s )
{
  return beginText(s.c_str());
}

string
TextGenerator::endText( const char *s )
{
  reset();
  output(s);
  endTextGeneration() ;
  return outstream.str();
}

string
TextGenerator::endText( const string &s )
{
  return endText(s.c_str());
}

string
TextGenerator::get_string()
{
  string ret = outstream.str();
  reset();
  return ret;
}

void
TextGenerator::startTextGeneration()
{
  output(pre_tag);
}

void
TextGenerator::endTextGeneration()
{
  output(post_tag);
}
