/* correlations.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../../src/correlations.q on Sat Aug 25 13:28:39 2007.
   Do not modify!
 */
#line 1 "../../src/correlations.q"
/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

#include <config.h>
#include <stdlib.h>
#include "alloc.h"
#include "dictionary.h"
#include "file-handle.h"
#include "command.h"
#include "lexer.h"
#include "var.h"
#line 35 "correlations.c"
#include <stdlib.h>
#include "alloc.h"
#include "error.h"
#include "lexer.h"
#include "settings.h"
#include "str.h"
#include "subclist.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 29 "../../src/correlations.q"

#include "debug-print.h"

struct cor_set
  {
    struct cor_set *next;
    struct variable **v1, **v2;
    int nv1, nv2;
  };

struct cor_set *cor_list, *cor_last;

struct file_handle *matrix_file;

static void free_correlations_state (void);
static int internal_cmd_correlations (void);

int
cmd_correlations (void)
{
  int result = internal_cmd_correlations ();
  free_correlations_state ();
  return result;
}

#line 74 "correlations.c"
#line 65 "../../src/correlations.q"
#line 76 "correlations.c"
/* Settings for subcommand specifiers. */
enum
  {
    COR_PAIRWISE = 1000,
    COR_LISTWISE,
    COR_INCLUDE,
    COR_EXCLUDE,
    COR_TWOTAIL,
    COR_ONETAIL,
    COR_SIG,
    COR_NOSIG,
    COR_MATRIX,
    COR_SERIAL
  };

#define MAXLISTS 10
/* Array indices for STATISTICS subcommand. */
enum
  {
    COR_ST_DESCRIPTIVES = 0,
    COR_ST_XPROD = 1,
    COR_ST_ALL = 2,
    COR_ST_count
  };

/* CORRELATIONS structure. */
struct cmd_correlations
  {
    /* VARIABLES subcommand. */
    int sbc_variables;
    
    /* MISSING subcommand. */
    int sbc_missing;
    long miss;
    long inc;
    
    /* PRINT subcommand. */
    int sbc_print;
    long tail;
    long sig;
    
    /* FORMAT subcommand. */
    int sbc_format;
    long fmt;
    
    /* MATRIX subcommand. */
    int sbc_matrix;
    
    /* STATISTICS subcommand. */
    int sbc_statistics;
    int a_statistics[COR_ST_count];
  };

/* Prototype for custom subcommands of CORRELATIONS. */
static int cor_custom_variables (struct cmd_correlations *);
static int cor_custom_matrix (struct cmd_correlations *);

/* Command parsing functions. */
static int parse_correlations (struct cmd_correlations *);
static void free_correlations (struct cmd_correlations *);

#line 66 "../../src/correlations.q"
#line 139 "correlations.c"
static int
parse_correlations (struct cmd_correlations *p)
{
  p->sbc_variables = 0;
  p->sbc_missing = 0;
  p->miss = COR_PAIRWISE;
  p->inc = -1;
  p->sbc_print = 0;
  p->tail = COR_TWOTAIL;
  p->sig = COR_SIG;
  p->sbc_format = 0;
  p->fmt = COR_MATRIX;
  p->sbc_matrix = 0;
  p->sbc_statistics = 0;
  memset (p->a_statistics, 0, sizeof p->a_statistics);
  for (;;)
    {
      switch (cor_custom_variables (p))
        {
        case 0:
          goto lossage;
        case 1:
          p->sbc_variables++;
          continue;
        case 2:
          break;
        default:
          assert (0);
        }
      if (lex_match_id ("VARIABLES"))
        {
          lex_match ('=');
          p->sbc_variables++;
          switch (cor_custom_variables (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("MISSING"))
        {
          lex_match ('=');
          p->sbc_missing++;
          if (p->sbc_missing > 1)
            {
              msg (SE, _("MISSING subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("PAIRWISE"))
                p->miss = COR_PAIRWISE;
              else if (lex_match_id ("LISTWISE"))
                p->miss = COR_LISTWISE;
              else if (lex_match_id ("INCLUDE"))
                p->inc = COR_INCLUDE;
              else if (lex_match_id ("EXCLUDE"))
                p->inc = COR_EXCLUDE;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("PRINT"))
        {
          lex_match ('=');
          p->sbc_print++;
          if (p->sbc_print > 1)
            {
              msg (SE, _("PRINT subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("TWOTAIL"))
                p->tail = COR_TWOTAIL;
              else if (lex_match_id ("ONETAIL"))
                p->tail = COR_ONETAIL;
              else if (lex_match_id ("SIG"))
                p->sig = COR_SIG;
              else if (lex_match_id ("NOSIG"))
                p->sig = COR_NOSIG;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("FORMAT"))
        {
          lex_match ('=');
          p->sbc_format++;
          if (p->sbc_format > 1)
            {
              msg (SE, _("FORMAT subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("MATRIX"))
                p->fmt = COR_MATRIX;
              else if (lex_match_id ("SERIAL"))
                p->fmt = COR_SERIAL;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("MATRIX"))
        {
          lex_match ('=');
          p->sbc_matrix++;
          if (p->sbc_matrix > 1)
            {
              msg (SE, _("MATRIX subcommand may be given only once."));
              goto lossage;
            }
          switch (cor_custom_matrix (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("STATISTICS"))
        {
          lex_match ('=');
          p->sbc_statistics++;
          if (p->sbc_statistics > 1)
            {
              msg (SE, _("STATISTICS subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("DESCRIPTIVES"))
                p->a_statistics[COR_ST_DESCRIPTIVES] = 1;
              else if (lex_match_id ("XPROD"))
                p->a_statistics[COR_ST_XPROD] = 1;
              else if (lex_match (T_ALL))
                p->a_statistics[COR_ST_ALL] = 1;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if ( get_syntax() != COMPATIBLE && lex_match_id("ALGORITHM"))
        {
          lex_match ('=');
          if (lex_match_id("COMPATIBLE"))
            set_cmd_algorithm(COMPATIBLE);
          else if (lex_match_id("ENHANCED"))
            set_cmd_algorithm(ENHANCED);
          }
        if (!lex_match ('/'))
          break;
      }
    
    if (token != '.')
      {
        lex_error (_("expecting end of command"));
        goto lossage;
      }
      
  return 1;
  
lossage:
  free_correlations (p);
  return 0;
}

static void
free_correlations (struct cmd_correlations *p UNUSED)
{
}
#line 67 "../../src/correlations.q"

int
internal_cmd_correlations (void)
{
  struct cmd_correlations cmd;

  cor_list = cor_last = NULL;
  matrix_file = NULL;

  if (!parse_correlations (&cmd))
    return CMD_FAILURE;
  free_correlations (&cmd);

  return CMD_SUCCESS;
}

static int
cor_custom_variables (struct cmd_correlations *cmd UNUSED)
{
  struct variable **v1, **v2;
  int nv1, nv2;
  struct cor_set *cor;

  /* Ensure that this is a VARIABLES subcommand. */
  if (!lex_match_id ("VARIABLES")
      && (token != T_ID || dict_lookup_var (default_dict, tokid) != NULL)
      && token != T_ALL)
    return 2;
  lex_match ('=');

  if (!parse_variables (default_dict, &v1, &nv1,
			PV_NO_DUPLICATE | PV_NUMERIC))
    return 0;
  
  if (lex_match (T_WITH))
    {
      if (!parse_variables (default_dict, &v2, &nv2,
			    PV_NO_DUPLICATE | PV_NUMERIC))
	{
	  free (v1);
	  return 0;
	}
    }
  else
    {
      nv2 = nv1;
      v2 = v1;
    }

  cor = xmalloc (sizeof *cor);
  cor->next = NULL;
  cor->v1 = v1;
  cor->v2 = v2;
  cor->nv1 = nv1;
  cor->nv2 = nv2;
  if (cor_list)
    cor_last = cor_last->next = cor;
  else
    cor_list = cor_last = cor;
  
  return 1;
}

static int
cor_custom_matrix (struct cmd_correlations *cmd UNUSED)
{
  if (!lex_force_match ('('))
    return 0;
  
  if (lex_match ('*'))
    matrix_file = NULL;
  else 
    {
      matrix_file = fh_parse ();
      if (matrix_file == NULL)
        return 0; 
    }

  if (!lex_force_match (')'))
    return 0;

  return 1;
}

static void
free_correlations_state (void)
{
  struct cor_set *cor, *next;

  for (cor = cor_list; cor != NULL; cor = next)
    {
      next = cor->next;
      if (cor->v1 != cor->v2)
	free (cor->v2);
      free (cor->v1);
      free (cor);
    }
}

/*
  Local Variables:
  mode: c
  End:
*/
