
;;; d-flock-private.el --- Fontifies private_* in private-face

;; Copyright (C) 2014-2016 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-flock-private.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Current function method C, C++, Java, Java Training Wheels, J.T.W.
;; Version: 1.2

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; m4_install_instructions(d-flock-private)

;;; Known Bugs:

;; None so far!

(make-face 'private-face)
(set-face-background 'private-face "#ffbbbb")
(set-face-foreground 'private-face "#000000")
(make-face-bold 'private-face)
(setq private-face 'private-face)
(setq bg:lightgreen 'bg:lightgreen)

(add-hook 'font-lock-mode-hook 'private-font-lock-mode-hook 'append)
;;(remove-hook 'font-lock-mode-hook 'private-font-lock-mode-hook)

(defun private-font-lock-mode-hook ()
  (when (or (eq major-mode 'c++-mode)
            (eq major-mode 'jtw-mode)
            (eq major-mode 'java-mode)
            )
    (d-font-lock-add-begin
     '(
       ("\\(^\\|[ ()\t\r\n:>,;*]\\)\\(_[a-zA-Z0-9_]*\\)"
        2 'private-face t)

       ("\\(^\\|[ ()\t\r\n:>,;*]\\)\\(private_[a-zA-Z0-9_]*\\)"
        2 'private-face t)

       )
     )
    ;;(message "John Dowland: Lute Songs")
    )
  )

(provide 'd-flock-private)
;;; d-flock-private.el ends here
