#!/bin/sh
#
#    spar - Show Process Accounting Records
#    Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford
#
#    Please see the file `COPYING' for the complete copyright notice.
#
# lastcomm.sh - 10/28/93
#

if [ $# = 0 ]; then
  SPARCMD=
elif [ $# = 1 ]; then
  SPARCMD="cmd=\"$1\" || user=\"$1\" || tty=\"$2\""
elif [ $# = 2 ]; then
  SPARCMD="
    (cmd=\"$1\" && (user=\"$2\" || tty=\"$2\")) ||
    (cmd=\"$2\" && (user=\"$1\" || tty=\"$1\"))
  "
else
  SPARCMD="
    (cmd=\"$1\" && user=\"$2\" && tty=\"$3\") ||
    (cmd=\"$1\" && user=\"$3\" && tty=\"$2\") ||
    (cmd=\"$2\" && user=\"$1\" && tty=\"$3\") ||
    (cmd=\"$2\" && user=\"$3\" && tty=\"$1\") ||
    (cmd=\"$3\" && user=\"$1\" && tty=\"$2\") ||
    (cmd=\"$3\" && user=\"$2\" && tty=\"$1\")"
fi

spar -qre "$SPARCMD {print}"
