/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

config/sunos4.h - 10/31/93

*/
#ifndef __SUNOS5_SPAR__
#define __SUNOS5_SPAR__

#define DEFAULT_PACCT "/var/adm/pacct"
#define AC_COMMLEN 8
#define fromticks(t) ((((t)&0x1fff)<<(3*(((t)&0xe000)>>13)))/clockrate)

#define SYSVPTY "/dev/pts"
#define SYSVMPTYC "/dev/ptmajor"
#define SYSVMPTY "/dev/ptmx"
#define SYSVTTY "/dev/term"

#define BSDPTY "/dev"
#define BSDTTY "/dev"

#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/sysmacros.h>

#define MAJORDEV(x) getemajor((x))
#define MINORDEV(x) geteminor((x))

#define MISCTTY "/dev/wscons", (char *)0

#define CLKRATE (unsigned long)sysconf(_SC_CLK_TCK)

#define ACSIGEXIT(n) ((n)&127)

#endif
