/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

config/aix3.h - 10/31/93

*/
#ifndef __AIX3_SPAR__
#define __AIX3_SPAR__

#define DEFAULT_PACCT "/var/adm/pacct"
#define AC_COMMLEN 8
#define fromticks(t) ((((t)&0x1fff)<<(3*(((t)&0xe000)>>13)))/clockrate)

#define SYSVPTY "/dev/pts"
#define SYSVMPTYC "/dev/ptc"
#define SYSVMPTY "/dev/ptc"

#define BSDTTY "/dev"

#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/sysmacros.h>

#define MAJORDEV(x) major((x))
#define MINORDEV(x) minor((x))

#define MISCTTY (char *)0

#define CLKRATE AHZ

#define ACSIGEXIT(n) ((n)&127)

#endif
