.TH SOCKS_CLIENTS 1 "August 6, 1993"
.SH NAME
.nf
rfinger \- SOCKS client version of finger
rftp \- SOCKS client version of ftp
rtelnet \- SOCKS client version of telnet
rwhois \- SOCKS client version of whois
rxgopher \- SOCKS client version of xgopher
rxmosaic \- SOCKS client version of xmosaic
.fi
.SH SYNOPSIS
See the man pages on \fIfinger\fP(1), \fIftp\fP(1), \fItelnet\fP(1),
\fIwhois\fP(1), and \fIxgopher\fP(n).
.SH DESCRIPTION
These programs provide the well-known functionalities to hosts within
a firewall. Normally, when a firewall is constructed, IP-accessibility
across the firewall is cut off to reduce security risk to hosts within
the firewall. As a result, inside hosts can no longer use many of the
well-known tools directly to access the resources outside the firewall.

These programs restore the convenience of the well-known tools while
maintaining the security requirement. Though the programs differ very
much from their counterparts in the use of the communication scheme,
they should behave almost indistinguishably to the users. Note though
that rftp does echo the password as you type it in if you are using
\fIanonymous\fP as log-in name.

These programs
must work thorough a proxy server called \fIsockd\fP, which should be
running on a host separate from the clients. The name or IP address of
the default server host is compiled into the client program. It is
overridden at run time by the contents of the environment variable
\fBSOCKS_SERVER\fR if it exists. The client program prints to \fBstderr\fP
the name or IP address of the SOCKS proxy server it actually uses.
It also prints out the version of SOCKS protocol it uses. Both server
and client must use the same version of SOCKS protocol.

You can use environment variable \fBSOCKS_NS\fR to set the nameserver for
domainname resolutions. Be sure you use the IP address of the
nameserver you want to use, not its domainname. If \fBSOCKS_NS\fR doesn't
exist, the IP address defined by the symbol \fBSOCKS_DEFAULT_NS\fR
at compile time is used if the programs were compiled with that symbol
defined. Otherwise the nameservers specified in /etc/resolv.conf are used.

All the client programs uses \fIsyslog\fR with facility \fBdaemon\fP
and level \fBnotice\fP to log their activities. Typical lines look like

.nf
.in +1
Apr 11 10:02:23 eon rfinger[631]: connect() from don to abc.com (finger)
May 10 08:39:07 eon rftp[603]: connect() from blue to xyz.edu (ftp)
May 10 08:39:09 eon rftp[603]: bind() from blue for xyz.edu
May 18 13:31:19 eon rtelnet[830]: From jon to xyz.edu (telnet)
Jun 12 19:03:45 eon rxmosaic[688]: From sam to cso.uiuc.edu (WWW)
.in -1
.fi

These log lines usually appear in file \fBvar/adm/messages\fP though
that can be changed by modifying \fI/etc/syslog.conf\fP. (See
\fIsyslogd\fR(8) and \fIsyslog.conf\fR(5).)
.SH SEE ALSO
\fIsockd\fP(8), \fIfinger\fP(1),  \fIftp\fP(1), \fItelnet\fP(1),
\fIwhois\fP(1), \fIxgopher\fP(n)
.SH ENVIRONMENT
\fBSOCKS_SERVER\fR, if defined, specifies the name or IP address of the
SOCKS proxy server host to use, overriding the default server
compiled into the programs.

\fBSOCKS_NS\fR, if defined, specify the IP address of the domain nameserver
that should be used to name resolution, overriding both the definition
of symbol \fBSOCKS_DEFAULT_NS\fR and the file /etc/resolv.conf.
.SH AUTHOR
David Koblas, koblas@sgi.com (\fIrfinger\fP, \fIrwhois\fP, \fIrftp\fP)
.PP
Ying-Da Lee, ylee@syl.dl.nec.com (\fIrtelnet\fP, \fIrxgopher\fP, \fIrxmosaic\fP)
