/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: dirstruct.h
 *
 *    Prime is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Prime is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Prime.  If not, see <http://www.gnu.org/licenses/>.
 */    
#ifndef __DIRSTRUCT_H
#define __DIRSTRUCT_H

#include "defs.h"

struct dirstruct
{
    char *name;
    int  namelen;
    char star;
    char type;
};


#ifdef DIRSTRUCT
#   define DIRSTRUCT_EXTERN
#else
#   define DIRSTRUCT_EXTERN   extern
#endif

DIRSTRUCT_EXTERN struct dirstruct *dirs[MAXENTRIES];
DIRSTRUCT_EXTERN struct dirstruct *files[MAXENTRIES];

void freeDirStruct(struct dirstruct *dir);
void freeDirStructs(int start, int end);
void freeFileStructs(int start, int end);
struct dirstruct *allocDirStruct();
struct dirstruct *allocFileStruct();
struct dirstruct *allocDirStructB(int bytes);
struct dirstruct *allocFileStructB(int bytes);

#endif
