#ifdef exit
#error Huch
#endif
  

#include "pgpdll.h"

#include <stdarg.h>
#include "XString.h"


#define JvP_PRINTBUFFER 4096


extern outputFunction JvP_outFct;
extern inputFunction JvP_inFct;
extern rndaccFunction JvP_rndaccFct;
extern pagerFunction JvP_pagerFct;
extern phreadFunction JvP_phreadFct;
extern phwriteFunction JvP_phwriteFct;

extern "C" int JvP_fprintf( FILE *stream, const char *format ,...);
extern "C" int JvP_fputs( const char *string, FILE *stream );
extern "C" int JvP_fputc( int c, FILE *stream );

extern "C" int JvP_in(char *strbuf, unsigned maxlen, int echo);

extern "C" void JvP_Exit(int returnval);

extern "C" void JvP_RandAcc( unsigned int count);
extern "C" int JvP_Pager( char* fileName);

extern "C" char** mcguffins;


extern "C" int JvP_PhantomRead (  void *buffer, size_t size, size_t count, FILE *stream );
extern "C" int JvP_PhantomWrite(  const void *buffer, size_t size, size_t count, FILE *stream );

void JvP_Exit(int returnval)
{
	if (mcguffins)
		free(mcguffins);
	mcguffins = NULL;
	throw returnval;
	// ExitThread(returnval);
}



void JvP_out( FILE *stream, const char *inOut);

int JvP_fprintf( FILE *stream, const char *format ,...)
{
	va_list args;
	va_start(args, format);

	if ((stream!=stdout) && (stream != stderr))
	{
		return vfprintf( stream, format, args);
	}
		

	XString out;
	int ret = vsprintf(out.GetBuffer(JvP_PRINTBUFFER), format, args);
	out.ReleaseBuffer();
	JvP_out(stream, out());
	return ret;
}


int JvP_fputs( const char *string, FILE *stream )
{
	if ((stream!=stdout) && (stream != stderr))
	{
		return  fputs( string, stream);
	}



	JvP_out(stream, string);
	return 1;
}

int JvP_fputc( int c, FILE *stream )
{
	if ((stream!=stdout) && (stream != stderr))
	{
		return fputc( c, stream);
	}


	char cc[2];
	cc[0] = (char)c;
	cc[1] = 0;
	JvP_out( stream, cc);
	return 1;
}


XString JvP_Lastout;
extern "C" int contains_yesNo, contains_enough, contains_badpass;
static int sik_yesNo, sik_enough, sik_badpass;

void PushContains()
{ 
	sik_yesNo = contains_yesNo;
	sik_enough = contains_enough;
	sik_badpass = contains_badpass; 
}

void PopContains()
{ 
	contains_yesNo = sik_yesNo;
	contains_enough = sik_enough;
	contains_badpass = sik_badpass; 
}

// outFct: Pointer to Function 
// void fct ( FILE *stream, const char * );

void JvP_out( FILE *stream, const char *inOut)
{
		XString tout(inOut);
		
		if (!tout.IsEmpty()) 
		{	
			JvP_Lastout += "\n";
			PushContains();
			if (tout!=GETLANG("Remove this signature (y/N)? "))
				JvP_Lastout.MakeEmpty();
			PopContains();
			tout.StripWhitespaces();
			JvP_Lastout += tout;
		}
		if (*JvP_outFct!= NULL) 
			(*JvP_outFct)(stream, inOut);
		else 
			fputs( inOut, stream);
}



int JvP_in(char *strbuf, unsigned maxlen, int echo)
{
	return (*JvP_inFct) ( JvP_Lastout(), strbuf, maxlen, echo);
	
}


void JvP_RandAcc( unsigned int count)
{
	(*JvP_rndaccFct) (count);
}
  

int JvP_Pager( char* fileName)
{
	return (*JvP_pagerFct) (fileName);
}


int JvP_PhantomRead (  void *buffer, size_t size, size_t count, FILE *stream )
{
	if (JvP_phreadFct == NULL) return fread ( buffer, size, count, stream );
	else
		return (*JvP_phreadFct) ( buffer, size, count, stream);
}

int JvP_PhantomWrite (const void *buffer, size_t size, size_t count, FILE *stream )
{
	if (JvP_phwriteFct == NULL) return fwrite ( buffer, size, count, stream);
	else
		return (*JvP_phwriteFct) ( buffer, size, count, stream);
}
