/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1993.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XFTP shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XFTP for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include "xftp.h"
#include "xfer.h"

struct del_ctrl_block del_ctrl;

extern struct st_host_info hinfo[];
extern int beep_when_ops_done;
extern Widget w_toplev;
extern int diagnostics;


/*
 * clean_up_del_ctrl - Cleans up the deletion control block data structure.
 *                     This routine should be called after servicing a
 *                     deletion request. 
 */
clean_up_del_ctrl()
{
	int i;
	struct entry_link *ptr;
	int level = del_ctrl.level;

	if (del_ctrl.rel_path != NULL) {
		XtFree(del_ctrl.rel_path);
		del_ctrl.rel_path = NULL;
	}

	if (del_ctrl.full_path != NULL) {
		XtFree(del_ctrl.full_path);
		del_ctrl.full_path = NULL;
	}

	for(i=0; i<=del_ctrl.level; i++)
		while ((ptr = del_ctrl.head[i]) != NULL) {
			del_ctrl.head[i] = del_ctrl.head[i]->next;
			XtFree(ptr->entry);
			XtFree((char *)ptr);
		}
}


/*
 * cb_delete_entries - Work procedure for executing deletion request.
 *                     State information is kept in "del_ctrl", the
 *                     deletion control block data structure.
 */
cb_delete_entries()
{
	struct entry_link *ptr;
	int host = del_ctrl.host;
	int host_type = hinfo[del_ctrl.host].type;
	struct sl_struct *list;
	int retval;
	int len;
	int i;
	int is_a_directory;
	char msg[MAXPATHLEN+40];
	int already_handled_dir = False;

	del_ctrl.full_path = NULL;
	del_ctrl.rel_path = NULL;
		
	/* Did user push abort button? */
	if (mp_abort_requested())
		goto abort;

	if (del_ctrl.head[del_ctrl.level] == NULL) {
		if (del_ctrl.level == 0)
			goto done;
		else {
			del_ctrl.level--;
			already_handled_dir = True;
		}
	}

	/* Build relative path name */
	len = 1;
	for (i=0; i<=del_ctrl.level; i++)
		len += strlen(del_ctrl.head[i]->entry)+1;
	del_ctrl.rel_path = XtMalloc(len);
	strcpy(del_ctrl.rel_path, del_ctrl.head[0]->entry);
	for (i=1; i<=del_ctrl.level; i++) {
		strcat(del_ctrl.rel_path, "/");
		strcat(del_ctrl.rel_path, del_ctrl.head[i]->entry);
	}

	/* Build full path name */
	len = strlen(hinfo[host].wd)+strlen(del_ctrl.rel_path)+2;
	del_ctrl.full_path = XtMalloc(len);
	strcpy(del_ctrl.full_path, hinfo[host].wd);
	strcat(del_ctrl.full_path, "/");
	strcat(del_ctrl.full_path, del_ctrl.rel_path);

	if (del_ctrl.recursive && !already_handled_dir) {
		/* Test for directory by trying to cd to it */
		is_a_directory = False;
		if (host_type == LOCAL) {
			if (local_cd(host, del_ctrl.full_path, False) == 0)
				is_a_directory = True;
		} else
			switch (remote_cd(host, del_ctrl.full_path, True, False)) {
			case -3:
				goto lost;
			case 0:
				is_a_directory = True;
			}
		if (is_a_directory) {
			/* Get directory list */
			if (host_type == LOCAL) {
				if (local_ls(del_ctrl.full_path, &list, False) != 0) {
					warning_error("Unable to get directory list");
					goto done;
				}
			} else {
				switch (remote_ls(host, del_ctrl.full_path, &list, False)) {
				case -3:
					goto lost;
				case -1:
					warning_error("Unable to get directory list");
					goto done;
				}
			}
			/* Add directory list to new level */
			del_ctrl.level++;
			if (del_ctrl.level == MAXLEVELS) {
				warning_error("Deletion recurses too deeply - aborted.");
				goto done;
			}
			del_ctrl.head[del_ctrl.level] = NULL;
			for (i=list->nentries-1; i>=0; i--) {
				ptr = XtNew(struct entry_link);
				ptr->entry = XtNewString(list->entries[i]);
				strip_off_symbol(ptr->entry);
				ptr->next = del_ctrl.head[del_ctrl.level];
				del_ctrl.head[del_ctrl.level] = ptr;
			}
			release_string_list(list);
			return False;
		}
	}

	/* Delete next directory entry */
	update_mp_monitor(del_ctrl.rel_path);
	if (hinfo[host].type == LOCAL)
		retval = local_delete(host, del_ctrl.full_path);
	else
		retval = remote_delete(host, del_ctrl.full_path, True);
    switch (retval) {
    case -3:
		goto lost;
    case -1:
        sprintf(msg, "Unable to delete %s", del_ctrl.rel_path);
        warning_error(msg);
		break;
	case 0:
		if (diagnostics >= NORMAL) {
        	sprintf(msg, "*** Successfully deleted:  %s\n", del_ctrl.rel_path);
        	write_log(msg);
		}
    }
    XtFree(del_ctrl.full_path);
    XtFree(del_ctrl.rel_path);
    ptr = del_ctrl.head[del_ctrl.level];
    del_ctrl.head[del_ctrl.level] = ptr->next;
    XtFree(ptr->entry);
    XtFree((char *)ptr);
    return False;

done:
	
	clean_up_del_ctrl();
	hide_mp_monitor();
	if (mp_abort_requested())
		hide_abort_dialog();
	enable_controls(True);
	if (update_dir_displays(host, False) < 0)
		goto lost;
	update_xfer_controls();
	update_host_controls(host);
	if (beep_when_ops_done)
		beep();
	restore_prev_cursor();
	return True;

abort:

	hide_abort_dialog();
	warning_error("Deletion(s) aborted");
	clean_up_del_ctrl();
	hide_mp_monitor();
	if (mp_abort_requested())
		hide_abort_dialog();
	enable_controls(True);
	if (update_dir_displays(host, False) < 0)
		goto lost;
	update_xfer_controls();
	update_host_controls(host);
	if (beep_when_ops_done)
		beep();
	restore_prev_cursor();
	return True;

lost:

	clean_up_del_ctrl();
	hide_mp_monitor();
	if (mp_abort_requested())
		hide_abort_dialog();
	enable_controls(True);
	clear_selected_entries(host);
	restore_prev_cursor();
	lost_connection(host);
	use_busy_cursor();
	update_xfer_controls();
	update_host_controls(host);
	if (beep_when_ops_done)
		beep();
	restore_prev_cursor();
	return True;
}

