/* $Id: common.h,v 3.0 1992/02/23 21:25:39 davison $
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "config.h"	/* generated by installation script */

#include <errno.h>
#include <signal.h>
#ifdef I_SYS_IOCTL
#include <sys/ioctl.h>
#endif
#ifdef I_VFORK
#  include <vfork.h>
#endif

#include <time.h>

#define BITSPERBYTE 8
#define LBUFLEN 1024	/* line buffer length */
#define MAXFILENAME 512

/* some handy defs */

#define bool char
#define bool_int int
#define char_int int
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#define Null(t) ((t)0)
#define Nullch Null(char *)
#define Nullfp Null(FILE *)

#define Ctl(ch) (ch & 037)

#define strNE(s1,s2) (strcmp(s1,s2))
#define strEQ(s1,s2) (!strcmp(s1,s2))
#define strnNE(s1,s2,l) (strncmp(s1,s2,l))
#define strnEQ(s1,s2,l) (!strncmp(s1,s2,l))

/* Things we can figure out ourselves */

#ifdef EUNICE
#   define LINKART		/* add 1 level of possible indirection */
#   define UNLINK(victim) while (!unlink(victim))
#else
#   define UNLINK(victim) unlink(victim)
#endif

/* *** System Dependent Stuff *** */

#define MAKEDIR		/* use our makedir() instead of shell script */

/* NOTE: many of these are defined in the config.h file */

#ifdef NORMSIG
#   define sigset signal
#endif

/* news library */
#ifndef NEWSLIB		/* ~ and %l only ("~%l" is permissable) */
#   define NEWSLIB "/usr/lib/news"
#endif

/* path to private executables */
#ifndef PRIVLIB		/* ~, %x and %l only */
#   define PRIVLIB "%x/trn"
#endif

/* where to find news files */
#ifndef NEWSSPOOL		/* % and ~ */
#   define NEWSSPOOL "/usr/spool/news"
#endif

# ifndef NEW_THREAD
#   define NEW_THREAD ".new"
# endif

/* file containing list of active newsgroups and max article numbers */
#ifndef ACTIVE			/* % and ~ */
#   define ACTIVE "%x/active"
#endif
#ifdef USE_NNTP
#   ifndef ACTIVE1
#	define ACTIVE1 "%X/active1"
#   endif
#endif
#ifndef ACTIVE2
#   define ACTIVE2 "%X/active2"
#endif
#ifndef DBINIT
#   define DBINIT "%W/db.init"
#endif
#ifndef MTPRELOCK
#   define MTPRELOCK "%X/LOCK"
#endif
#ifndef MTLOCK
#   define MTLOCK "%X/LOCKmthreads"
#endif
#ifndef MTDLOCK
#   define MTDLOCK "%X/LOCKmtdaemon"
#endif
#ifndef MTLOG
#   define MTLOG "%X/mt.log"
#endif

/* path to fastest starting shell */
#ifndef SH
#   define SH "/bin/sh"
#endif

#ifndef MAKEDIR
/* shell script to make n-deep subdirectories */
#   ifndef DIRMAKER		/* % and ~ */
#	define DIRMAKER "%X/makedir"
#   endif
#endif

/* how to open binary format files */
#ifndef FOPEN_RB
#   define FOPEN_RB "r"
#endif
#ifndef FOPEN_WB
#   define FOPEN_WB "w"
#endif

/* what to do with ansi prototypes -- '()' == ignore, 'x' == use */
#ifndef _
#   ifdef __STDC__
#	define _(x) x
#   else
#	define _(x) ()
#   endif
#endif

/* some important types */

typedef long		ART_NUM;	/* article number */
typedef unsigned int	MEM_SIZE;	/* for passing to malloc */

/* *** end of the machine dependent stuff *** */

/* GLOBAL THINGS */

/* file statistics area */

EXT struct stat filestat;

/* various things of type char */

char	*index();
char	*rindex();
char	*getenv();
char	*strcat();
char	*strcpy();

EXT char buf[LBUFLEN+1];	/* general purpose line buffer */

/* miscellania */

int fseek();
long atol(), ftell();

EXT char nullstr[1] INIT("");

extern errno;

/* if subscripting is faster than shifting on your machine, define this */
#undef USESUBSCRIPT
#ifdef USESUBSCRIPT
EXT char powerof2[] INIT({1,2,4,8,16,32,64,128});
#define pow2(x) powerof2[x]
#else
#define pow2(x) (1 << (x))
#endif
#define OFFSET(a) ((a)-absfirst)

#define ctl_set(a) (ctlarea[(OFFSET(a)) / BITSPERBYTE] |= pow2((OFFSET(a)) % BITSPERBYTE))
#define ctl_check(a) ((ctlarea[(OFFSET(a)) / BITSPERBYTE] & pow2((OFFSET(a)) % BITSPERBYTE)) != 0)

#define advise(str)
#define fatal_error(str)  log_entry(str), wrap_it_up(1);
