/*
#ident	"@(#)smail/src:RELEASE-3_2_0_118:list.h,v 1.3 2004/02/02 03:24:44 woods Exp"
 */

/*
 *    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
 *    Copyright (C) 1992  Ronald S. Karr
 * 
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

/*
 * list.h:
 *	list storage management
 */

/*
 * list structure types for general use
 */
typedef struct charp_list {		/* general purpose list of strings entry */
    struct charp_list *succ;		/* single forward link */
    char *text;				/* data associated with entry */
} charplist_t;

typedef struct int_list {		/* general purpose list of ints entry */
    struct int_list *succ;		/* single forward link */
    int i_used;				/* flag to indicate if node is valid */
    int i_val;				/* data associated with entry */
} intlist_t;

/*
 * functions exported by list.c
 */
extern intlist_t *add_intlist __P((intlist_t *, int));
extern int remove_intlist_matching __P((intlist_t *, int));
extern int remove_intlist_at __P((intlist_t *, size_t));

extern charplist_t *add_charplist __P((charplist_t *, char *));

#ifndef NDEBUG
extern int count_charplist __P((charplist_t *));
extern void print_charplist __P((charplist_t *));
extern int count_intlist __P((intlist_t *));
extern void print_intlist __P((intlist_t *));
#endif

/* 
 * Local Variables:
 * c-file-style: "smail"
 * End:
 */
