#! /bin/sh
#
#	myPreview.sh -- generate a preview release archive
#
#ident "@(#)smail:RELEASE-3_2_0_118:myPreview.sh,v 1.4 2004/05/30 05:34:31 woods Exp"

if [ -f conf/EDITME ]; then
	echo "$0: you can't do this while conf/EDITME is present!" 1>&2
	exit 1
fi
if [ -f defs.sh ]; then
	echo "$0: you must run 'make clobber' first!" 1>&2
	exit 1
fi

VERSION=$(awk '$1 ~ /^3.*-Pre/ {print $1}' level)
if [ -z "$VERSION" ]; then
	echo "$0: the current version doesn't seem to be a preview!" 1>&2
	exit 1
fi

DATE=$(date '+%Y%m%d')

ARCHIVE=/most/distfiles/smail-${VERSION}-${DATE}.tar.gz

echo "Creating ChangeLog-${VERSION} ..."

rm -f ChangeLog-${VERSION}.OLD
sh ./mkChangeLog.sh

echo -n "Creating preview release in ${ARCHIVE} ... "

find -L . \( -type f -a ! -name '.?*' -a ! -name '*~' -print \) -o -name CVS -prune | \
	pax -wz -s ,./,smail-${VERSION}-${DATE}/, -f ${ARCHIVE}

echo "Done."

exit 0
