/*
#ident	"@(#)smail/src/util:RELEASE-3_2_0_109:dbm_compat.h,v 1.9 1997/12/04 06:22:22 woods Exp"
 */

/*
 * dbm_compat.h:
 *	Low-functionality compatibility header for dbm and ndbm.
 */

#if !defined(sgi) && !defined(__STDC__)
/* damned SGI compiler complains if you undef an ANSI thing!!! */
# ifdef NULL
#  undef NULL			/* dbm.h often defines NULL -- prevent redfine */
# endif
#endif

#ifdef HAVE_DBM

# ifdef DBM_INCLUDE_FILE
#  include DBM_INCLUDE_FILE	/* some cpp's warn about this */
# else
#  include <dbm.h>
# endif

#else	/* !HAVE_DBM */

# ifdef HAVE_NDBM
#  ifdef NDBM_INCLUDE_FILE
#   include NDBM_INCLUDE_FILE	/* some cpp's warn about this */
#  else
#   include <ndbm.h>
#  endif
# else	/* not HAVE_NDBM */
#  include "sdbm.h"
# endif	/* HAVE_NDBM */

/* Imitate dbm using  */

static DBM *db;

# define dbminit(f) \
	((db = dbm_open((f),O_RDWR|O_CREAT,0666)) ? 0 : (db = dbm_open((f),O_RDONLY,0666)) ? 0 : -1)
# define dbmclose()	((db ? (dbm_close(db),0) : 0), db = (DBM *)0, 0)
# define store(k,v)	dbm_store(db,k,v,DBM_INSERT)
# define fetch(k)	dbm_fetch(db,(k))

#endif	/* !HAVE_DBM */

#if !defined(sgi) && !defined(__STDC__)
/* damned SGI compiler complains if you undef an ANSI thing!!! */
# ifdef NULL
#  undef NULL
# endif
# define NULL 0		/* in case dbm.h does not define NULL */
#endif
