package Graphics::Framebuffer::Splash;

use strict;
no strict 'vars';    # We have to map a variable as the screen.  So strict is going to whine about what we do with it.
no warnings;         # We have to be as quiet as possible

use constant {
    TRUE  => 1,
    FALSE => 0
};

use List::Util qw(min max);

BEGIN {
    our $VERSION = 1.00;
}

sub _perl_logo {
    my $self = shift;
    return unless (exists($self->{'FONTS'}->{'DejaVuSerif'}));
    my $hf = $self->{'H_SCALE'};
    my $vf = $self->{'V_SCALE'};

    $self->normal_mode();
    $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 0, 'alpha' => 128 });
    $self->ellipse(
        {
            'x'       => 965 * $hf,
            'y'       => 70  * $vf,
            'xradius' => 140 * $hf,
            'yradius' => 65  * $vf,
            'filled'  => TRUE
        }
    );
    $self->set_color({ 'red' => 0, 'green' => 64, 'blue' => 255, 'alpha' => 255 });
    $self->ellipse(
        {
            'x'       => 960 * $hf,
            'y'       => 65  * $vf,
            'xradius' => 140 * $hf,
            'yradius' => 65  * $vf,
            'filled'  => TRUE
        }
    );

    $self->xor_mode();
    $self->ttf_print(
        $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'y'            => 126 * $vf, # 85 * $vf,
                'height'       => 80 * $vf,
                'wscale'       => 1,
                'color'        => '0040FFFF',
                'text'         => 'Perl',
                'face'         => $self->{'FONTS'}->{'DejaVuSerif'}->{'font'},
                'font_path'    => $self->{'FONTS'}->{'DejaVuSerif'}->{'path'},
                'bounding_box' => TRUE,
                'center'       => $self->{'CENTER_X'},
                'antialias'    => FALSE
            }
        )
    );
} ## end sub _perl_logo

sub splash {
    my $self    = shift;
    my $version = shift;

    my $X = $self->{'X_CLIP'};
    my $Y = $self->{'Y_CLIP'};
    my $W = $self->{'XX_CLIP'} - $X;
    my $H = $self->{'YY_CLIP'} - $Y;

    my $hf = $W / 1920;    # Scales the logo
    my $vf = $H / 1080;
    $self->{'H_SCALE'} = $hf;
    $self->{'V_SCALE'} = $vf;

    my $bold = $self->{'FONT_FACE'};
    $bold =~ s/\.ttf$/Bold.ttf/;

    $self->cls();
    $self->clip_reset();

    if (($W <= 320) || ($H <= 240)) {
        $hf = $W / 320;
        $vf = $H / 240;
        $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 64 });
        $self->polygon(
            {
                'coordinates' => [
                    (67.5  * $hf) + $X, (16.875  * $vf) + $Y,
                    (3.325 * $hf) + $X, (178.125 * $vf) + $Y,
                    (267.5 * $hf) + $X, (238.125 * $vf) + $Y,
                    (315   * $hf) + $X, (2.5     * $vf) + $Y
                ],
                'filled'      => TRUE,
                'gradient'    => {
                    'start' => {
                        'red'   => 0,
                        'green' => 0,
                        'blue'  => 16
                    },
                    'end' => {
                        'red'   => 0,
                        'green' => 0,
                        'blue'  => 200
                    }
                }
            }
        );
        $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 1 });
        $self->rbox(
            {
                'x'      => (25     * $hf) + $X,
                'y'      => (28.125 * $vf) + $Y,
                'width'  => 277.5   * $hf,
                'height' => 185.625 * $vf,
                'radius' => 4,
                'filled' => TRUE
            }
        );

        $self->set_color({ 'red' => 128, 'green' => 0, 'blue' => 0 });
        $self->rbox(
            {
                'x'      => (20     * $hf) + $X,
                'y'      => (24.375 * $vf) + $Y,
                'width'  => 277.5   * $hf,
                'height' => 185.625 * $vf,
                'radius' => 4,
                'filled' => TRUE
            }
        );
        $self->set_color({ 'red' => 64, 'green' => 0, 'blue' => 0 });
        $self->circle(
            {
                'x'      => (37.5 * max($vf, $hf)) + $X,
                'y'      => (36   * max($vf, $hf)) + $Y,
                'radius' => 35    * max($vf, $hf),
                'filled' => TRUE
            }
        );

        $self->set_color({ 'red' => 255, 'green' => 255, 'blue' => 0 });
        $self->circle(
            {
                'x'        => (35 * max($hf, $vf)) + $X,
                'y'        => (36 * max($vf, $hf)) + $Y,
                'radius'   => 35  * max($hf, $vf),
                'filled'   => TRUE,
                'gradient' => {
                    'direction' => 'horizontal',
                    'start'     => {
                        'red'   => 255,
                        'green' => 0,
                        'blue'  => 0
                    },
                    'end' => {
                        'red'   => 255,
                        'green' => 255,
                        'blue'  => 0
                    }
                }
            }
        );
        my $color;
        $self->or_mode();

        # G
        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $color = '0000FFFF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $color = '0000FFFF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $color = 'FF0000FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $color = 'FF0000FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $color = '00FF00FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $color = '00FF00FF';
        }
        $self->ttf_print(
            $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => (75  * $hf) + $X,
                    'y'            => (70  * $vf) + $Y,
                    'height'       => 37.5 * $vf,
                    'wscale'       => 2,
                    'color'        => $color,
                    'text'         => 'G',
                    'face'         => $bold,
                    'bounding_box' => TRUE,
                    'center'       => 0,
                    'antialias'    => FALSE
                }
            )
        );

        # F
        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $color = '00FF00FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $color = 'FF0000FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $color = '00FF00FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $color = '0000FFFF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $color = 'FF0000FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $color = '0000FFFF';
        }
        $self->ttf_print(
            $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => 0,
                    'y'            => (70  * $vf) + $Y,
                    'height'       => 37.5 * $vf,
                    'wscale'       => 2,
                    'color'        => $color,
                    'text'         => 'F',
                    'face'         => $bold,
                    'bounding_box' => TRUE,
                    'center'       => $self->{'CENTER_X'},
                    'antialias'    => FALSE
                }
            )
        );

        # B
        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $color = 'FF0000FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $color = '00FF00FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $color = '0000FFFF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $color = '00FF00FF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $color = '0000FFFF';
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $color = 'FF0000FF';
        }
        $self->ttf_print(
            $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => (190 * $hf) + $X,
                    'y'            => (70  * $vf) + $Y,
                    'height'       => 37.5 * $vf,
                    'wscale'       => 2,
                    'color'        => $color,
                    'face'         => $bold,
                    'text'         => 'B',
                    'bounding_box' => TRUE,
                    'center'       => 0,
                    'antialias'    => FALSE
                }
            )
        );
        my $gfb = $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'x'            => 0,
                'y'            => (130 * $vf) + $Y,
                'height'       => 42   * $vf,
                'wscale'       => 1,
                'color'        => 'FFFF00FF',
                'text'         => 'Graphics-Framebuffer',
                'bounding_box' => TRUE,
                'center'       => $self->{'CENTER_X'},
                'antialias'    => FALSE
            }
        );
        if ($gfb->{'pwidth'} > int(270 * $hf)) {
            $gfb->{'bounding_box'} = TRUE;
            $gfb->{'wscale'}       = int(270 * $hf) / $gfb->{'pwidth'};
            $gfb                   = $self->ttf_print($gfb);
        }
        $self->ttf_print($gfb);
        $self->ttf_print(
            $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => 0,
                    'y'            => (170 * $vf) + $Y,
                    'height'       => 38   * $vf,
                    'wscale'       => 1,
                    'color'        => 'FFFFFFFF',
                    'text'         => sprintf('VERSION %.02f', $version),
                    'bounding_box' => TRUE,
                    'center'       => $self->{'CENTER_X'},
                    'antialias'    => FALSE
                }
            )
        );
        my @fonts   = grep(!/atari|mono|light|italic|bold|black/i, grep(/condensed/i, (keys %{ $self->{'FONTS'} })));
        my $font    = $fonts[int(rand(scalar(@fonts)))];
        my $scaleit = $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'x'            => 0,
                'y'            => (220 * $vf) + $Y,
                'height'       => 48   * $vf,
                'wscale'       => 1,
                'color'        => 'FFFFFFFF',
                'text'         => sprintf('%dx%d-%02d ON %s', $self->{'XRES'}, $self->{'YRES'}, $self->{'BITS'}, uc($self->{'fscreeninfo'}->{'id'} || 'Unknown GPU')),
                'bounding_box' => TRUE,
                'center'       => $self->{'CENTER_X'},
                'antialias'    => FALSE,
                'font_path'    => $self->{'FONTS'}->{$font}->{'path'},
                'face'         => $self->{'FONTS'}->{$font}->{'font'}
            }
        );
        if ($scaleit->{'pwidth'} > int(270 * $hf)) {
            $scaleit->{'bounding_box'} = TRUE;
            $scaleit->{'wscale'}       = int(270 * $hf) / $scaleit->{'pwidth'};
            $scaleit                   = $self->ttf_print($scaleit);
        }
        $self->ttf_print($scaleit);
    } else {

        # Draws the main boxes
        $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 64 });
        $self->polygon(
            {
                'coordinates' => [
                    (400  * $hf) + $X, (80   * $vf) + $Y,
                    (20   * $hf) + $X, (800  * $vf) + $Y,
                    (1600 * $hf) + $X, (1078 * $vf) + $Y,
                    (1900 * $hf) + $X, (5    * $vf) + $Y
                ],
                'filled'      => TRUE,
                'gradient'    => {
                    'start' => {
                        'red'   => 0,
                        'green' => 0,
                        'blue'  => 16
                    },
                    'end' => {
                        'red'   => 0,
                        'green' => 0,
                        'blue'  => 200
                    }
                }
            }
        );

        $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 1 });
        $self->rbox(
            {
                'x'      => (160 * $hf) + $X,
                'y'      => (160 * $vf) + $Y,
                'width'  => 1620 * $hf,
                'height' => 780  * $vf,
                'radius' => 15   * min($hf, $vf),
                'filled' => TRUE
            }
        );

        $self->set_color({ 'red' => 128, 'green' => 0, 'blue' => 0 });
        $self->rbox(
            {
                'x'      => (150 * $hf) + $X,
                'y'      => (150 * $vf) + $Y,
                'width'  => 1620 * $hf,
                'height' => 780  * $vf,
                'radius' => 15   * min($hf, $vf),
                'filled' => TRUE
            }
        );

        # Draws the Circle with GFB in it
        $self->set_color({ 'red' => 64, 'green' => 0, 'blue' => 0 });
        $self->circle(
            {
                'x'      => (207 * $hf) + $X,
                'y'      => (207 * $vf) + $Y,
                'radius' => 199  * min($vf, $hf),
                'filled' => TRUE
            }
        );

        $self->set_color({ 'red' => 255, 'green' => 255, 'blue' => 0 });
        $self->circle(
            {
                'x'        => (200 * $hf) + $X,
                'y'        => (200 * $vf) + $Y,
                'radius'   => 199  * min($hf, $vf),
                'filled'   => TRUE,
                'gradient' => {
                    'direction' => 'horizontal',
                    'start'     => {
                        'red'   => 255,
                        'green' => 0,
                        'blue'  => 0
                    },
                    'end' => {
                        'red'   => 255,
                        'green' => 255,
                        'blue'  => 0
                    }
                }
            }
        );

        # G
        $self->set_color({ 'red' => 32, 'green' => 32, 'blue' => 0 });
        $self->filled_pie(
            {
                'x'             => (102 * $hf) + $X,
                'y'             => (202 * $vf) + $Y,
                'radius'        => 52   * $vf,
                'start_degrees' => 340,
                'end_degrees'   => 270,
                'granularity'   => 0.05
            }
        );

        # F
        $self->polygon(
            {
                'coordinates' => [
                    (162 * $hf) + $X, (252 * $vf) + $Y,
                    (162 * $hf) + $X, (152 * $vf) + $Y,
                    (262 * $hf) + $X, (152 * $vf) + $Y,
                    (242 * $hf) + $X, (172 * $vf) + $Y,
                    (182 * $hf) + $X, (172 * $vf) + $Y,
                    (182 * $hf) + $X, (192 * $vf) + $Y,
                    (222 * $hf) + $X, (192 * $vf) + $Y,
                    (202 * $hf) + $X, (212 * $vf) + $Y,
                    (182 * $hf) + $X, (212 * $vf) + $Y,
                    (182 * $hf) + $X, (232 * $vf) + $Y
                ],
                'filled'      => TRUE,
                'pixel_size'  => 1
            }
        );

        # B
        $self->polygon(
            {
                'coordinates' => [
                    (272 * $hf) + $X, (252 * $vf) + $Y,
                    (272 * $hf) + $X, (152 * $vf) + $Y,
                    (322 * $hf) + $X, (152 * $vf) + $Y,
                    (322 * $hf) + $X, (252 * $vf) + $Y
                ],
                'filled'      => TRUE,
                'pixel_size'  => 1
            }
        );
        $self->circle(
            {
                'x'      => (322 * $hf) + $X,
                'y'      => (177 * $vf) + $Y,
                'radius' => 25   * $vf,
                'filled' => TRUE
            }
        );
        $self->circle(
            {
                'x'      => (322 * $hf) + $X,
                'y'      => (227 * $vf) + $Y,
                'radius' => 25   * $vf,
                'filled' => TRUE
            }
        );

        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        }

        # G
        $self->filled_pie(
            {
                'x'             => (100 * $hf) + $X,
                'y'             => (200 * $vf) + $Y,
                'radius'        => 52   * $vf,
                'start_degrees' => 340,
                'end_degrees'   => 270,
                'granularity'   => 0.05
            }
        );

        # F
        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        }
        $self->polygon(
            {
                'coordinates' => [(160 * $hf) + $X, (250 * $vf) + $Y, (160 * $hf) + $X, (150 * $vf) + $Y, (260 * $hf) + $X, (150 * $vf) + $Y, (240 * $hf) + $X, (170 * $vf) + $Y, (180 * $hf) + $X, (170 * $vf) + $Y, (180 * $hf) + $X, (190 * $vf) + $Y, (220 * $hf) + $X, (190 * $vf) + $Y, (200 * $hf) + $X, (210 * $vf) + $Y, (180 * $hf) + $X, (210 * $vf) + $Y, (180 * $hf) + $X, (230 * $vf) + $Y],
                'filled'      => TRUE,
                'pixel_size'  => 1
            }
        );

        # B
        if ($self->{'COLOR_ORDER'} == $self->{'BGR'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'BRG'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RGB'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'RBG'}) {
            $self->set_color({ 'red' => 0, 'green' => 255, 'blue' => 0 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GRB'}) {
            $self->set_color({ 'red' => 0, 'green' => 0, 'blue' => 255 });
        } elsif ($self->{'COLOR_ORDER'} == $self->{'GBR'}) {
            $self->set_color({ 'red' => 255, 'green' => 0, 'blue' => 0 });
        }
        $self->polygon(
            {
                'coordinates' => [
                    (270 * $hf) + $X, (250 * $vf) + $Y,
                    (270 * $hf) + $X, (150 * $vf) + $Y,
                    (320 * $hf) + $X, (150 * $vf) + $Y,
                    (320 * $hf) + $X, (250 * $vf) + $Y
                ],
                'filled'      => TRUE,
                'pixel_size'  => 1
            }
        );
        $self->circle(
            {
                'x'      => (320 * $hf) + $X,
                'y'      => (175 * $vf) + $Y,
                'radius' => 25   * $vf,
                'filled' => TRUE
            }
        );
        $self->circle(
            {
                'x'      => (320 * $hf) + $X,
                'y'      => (225 * $vf) + $Y,
                'radius' => 25   * $vf,
                'filled' => TRUE
            }
        );
        $self->set_color({ 'red' => 32, 'green' => 0, 'blue' => 0 });
        $self->rbox(
            {
                'x'      => (478  * $hf) + $X,
                'y'      => (208  * $vf) + $Y,
                'width'  => (1230 * $hf),
                'height' => (150  * $vf),
                'radius' => 20    * $vf,
                'filled' => TRUE,
            }
        );
        $self->rbox(
            {
                'x'        => (470  * $hf) + $X,
                'y'        => (200  * $vf) + $Y,
                'width'    => (1230 * $hf),
                'height'   => (150  * $vf),
                'radius'   => 20    * $vf,
                'filled'   => TRUE,
                'gradient' => {
                    'start' => {
                        'red'   => 64,
                        'green' => 0,
                        'blue'  => 255
                    },
                    'end' => {
                        'red'   => 255,
                        'green' => 0,
                        'blue'  => 64
                    }
                }
            }
        );
        $self->or_mode() if ($self->{'BITS'} == 16);

        if ($self->{'ACCELERATED'}) {
            $self->ttf_print(
                $self->ttf_print(
                    {
                        'bounding_box' => TRUE,
                        'x'            => (510 * $hf) + $X,
                        'y'            => (351 * $vf) + $Y,
                        'height'       => 110  * $vf,
                        'wscale'       => 1.5,
                        'color'        => '00FFFFFF',
                        'text'         => 'Accelerated',
                        'bounding_box' => TRUE,
                        'center'       => 0,
                        'antialias'    => ($self->{'BITS'} >= 24) ? TRUE : FALSE
                    }
                )
            );
        } ## end if ($self->{'ACCELERATED'...})
        if ($self->{'BITS'} >= 24) {
            my $shadow = $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => 0,
                    'y'            => (641 * $vf) + $Y,
                    'height'       => 200  * $vf,
                    'wscale'       => 1,
                    'color'        => '221100FF',
                    'text'         => 'Graphics-Framebuffer',
                    'bounding_box' => TRUE,
                    'center'       => $self->{'CENTER_X'},
                    'antialias'    => TRUE
                }
            );
            if ($shadow->{'pwidth'} > (1500 * $hf)) {
                $shadow->{'bounding_box'} = TRUE;
                $shadow->{'wscale'}       = int(1500 * $hf) / $shadow->{'pwidth'};
                $shadow                   = $self->ttf_print($shadow);
            }
            $shadow->{'x'} += max(1, 6 * $hf);
            $shadow->{'y'} += max(1, 6 * $vf);
            delete($shadow->{'center'});
            $self->ttf_print($shadow);
        } ## end if ($self->{'BITS'} >=...)
        my $gfb = $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'x'            => 0,
                'y'            => (641 * $vf) + $Y,
                'height'       => 200  * $vf,
                'wscale'       => 1,
                'color'        => 'FFFF00FF',
                'text'         => 'Graphics-Framebuffer',
                'bounding_box' => TRUE,
                'center'       => $self->{'CENTER_X'},
                'antialias'    => ($self->{'BITS'} >= 24) ? TRUE : FALSE
            }
        );
        if ($gfb->{'pwidth'} > (1500 * $hf)) {
            $gfb->{'bounding_box'} = TRUE;
            $gfb->{'wscale'}       = int(1500 * $hf) / $gfb->{'pwidth'};
            $gfb                   = $self->ttf_print($gfb);
        }
        $self->ttf_print($gfb);

        my $rk = $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'x'            => 0,
                'y'            => (651 * $vf) + $Y,
                'height'       => 50   * $vf,
                'wscale'       => 1,
                'color'        => '00EE00FF',
                'text'         => 'by Richard Kelsch',
                'bounding_box' => TRUE,
                'center'       => FALSE,
                'antialias'    => ($self->{'BITS'} >= 24) ? TRUE : FALSE
            }
        );
        $rk->{'x'} = (1710 * $hf) - $rk->{'pwidth'};
        $self->ttf_print($rk);

        $self->ttf_print(
            $self->ttf_print(
                {
                    'bounding_box' => TRUE,
                    'x'            => 0,
                    'y'            => (771 * $vf) + $Y,
                    'height'       => 120  * $vf,
                    'wscale'       => 1,
                    'color'        => 'FFFFFFFF',
                    'text'         => sprintf('Version %.02f', $version),
                    'bounding_box' => TRUE,
                    'center'       => $self->{'CENTER_X'},
                    'antialias'    => ($self->{'BITS'} >= 24) ? TRUE : FALSE
                }
            )
        );
        my $scaleit = $self->ttf_print(
            {
                'bounding_box' => TRUE,
                'x'            => 0,
                'y'            => (901 * $vf) + $Y,
                'height'       => 120  * $vf,
                'wscale'       => 1,
                'color'        => 'FFFFFFFF',
                'text'         => sprintf('%dx%d-%02d on %s', $self->{'XRES'}, $self->{'YRES'}, $self->{'BITS'}, $self->{'fscreeninfo'}->{'id'} || 'Unknown GPU'),
                'bounding_box' => TRUE,
                'center'       => $self->{'CENTER_X'},
                'antialias' => ($self->{'BITS'} >= 24) ? TRUE : FALSE
            }
        );
        if ($scaleit->{'pwidth'} > int(1500 * $hf)) {
            $scaleit->{'bounding_box'} = TRUE;
            $scaleit->{'wscale'}       = int(1500 * $hf) / $scaleit->{'pwidth'};
            $scaleit                   = $self->ttf_print($scaleit);
        }
        $self->ttf_print($scaleit);
        $self->_perl_logo();
    } ## end else [ if (($W <= 320) || ($H...))]
    $self->normal_mode();
} ## end sub splash

1;

=head1 NAME

Graphics::Framebuffer::Splash

=head1 DESCRIPTION

See the "Graphics::Frambuffer" documentation, as methods within here are pulled into the main module

=cut

