use strict;
use warnings;
use ExtUtils::MakeMaker 7.1101;

my %WriteMakeArgs =(
NAME              => 'Dancer2::Plugin::WebService',
VERSION_FROM      => 'lib/Dancer2/Plugin/WebService.pm',
ABSTRACT          => 'easy create restfull web services',
AUTHOR            => 'George Mpouras, george.mpouras@yandex.com',
LICENSE           => 'perl',
PL_FILES          => {},
MIN_PERL_VERSION  => 5.022000,
CONFIGURE_REQUIRES=> { 'ExtUtils::MakeMaker' =>' 7.1101' },
dist              => { COMPRESS     => 'gzip -9f', SUFFIX => 'gz', },
clean             => { FILES        => 'Dancer2-Plugin-WebService-*' },
BUILD_REQUIRES    => { 'Test::More' => '0.92' },
TEST_REQUIRES     => { 'Test::More' => '0.92' },
test              => { TESTS        => "t/*.t" },
NO_MYMETA         => 1,
NO_META           => 0,
EXE_FILES         => [

	'lib/Dancer2/Plugin/scripts/LinuxOS/AuthUser.pl',
	'lib/Dancer2/Plugin/scripts/HttpBasic/admins.pl',
	'lib/Dancer2/Plugin/scripts/HttpBasic/users.pl',
	'lib/Dancer2/Plugin/scripts/AlwaysOk/AlwaysOk.sh',
	'lib/Dancer2/Plugin/scripts/LDAP/LDAP.pl',
	'lib/Dancer2/Plugin/scripts/ActiveDirectory/ActiveDirectory.pl'
	],

PREREQ_PM => {

	'Data::Dumper' => 0,
	'XML::Hash::XS' => 0,
	'JSON::XS' => 0,
	'YAML::XS' => 0,
	'Moo' => 0,
	'Plack' => 0,
	'Plack::Middleware::Deflater' => 0,
	'Starman' => 0,
	'Dancer2' => 0,
        'Dancer2::Plugin' => 0
	}
);

WriteMakefile(%WriteMakeArgs)