package Foo::Testmysqlorm;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';
use Module::Load;

extends 'MySQL::ORM';

has League => (
    is       => 'rw',
    isa      => 'Foo::Testmysqlorm::League',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_table',
);

has Sport => (
    is       => 'rw',
    isa      => 'Foo::Testmysqlorm::Sport',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_table',
);

has Team => (
    is       => 'rw',
    isa      => 'Foo::Testmysqlorm::Team',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_table',
);

has db_name => (
    is       => 'rw',
    isa      => 'Str',
    init_arg => undef,
    default  => 'testmysqlorm',
);

method _build_table (
) {
    my $want_class = ( caller(1) )[3];

    if ( $want_class =~ /__ANON__/ ) {
        my @a = split( /\s+/, $want_class );
        $want_class = $a[1];
    }

    load $want_class;
    return $want_class->new( dbh => $self->dbh );
}

1;
