# This file is auto-generated by the Perl DateTime Suite time zone
# code generator (0.01) This code generator comes with the
# DateTime::TimeZone module distribution in the tools/ directory
#
# Generated from Honolulu.
#
# Do not edit this file directly.
#
package DateTime::TimeZone::Pacific::Honolulu;

use strict;

use Class::Singleton;
use DateTime::TimeZone;
use DateTime::TimeZone::OlsonDB;

@DateTime::TimeZone::Pacific::Honolulu::ISA = ( 'Class::Singleton', 'DateTime::TimeZone' );

my $spans =
[
  {
    'short_name' => 'LMT',
    'utc_end' => '59926775486',
    'utc_start' => DateTime::TimeZone::NEG_INFINITY,
    'local_end' => '59926737600',
    'is_dst' => 0,
    'offset' => -37886,
    'local_start' => '-inf'
  },
  {
    'short_name' => 'HST',
    'utc_end' => '60978400200',
    'utc_start' => '59926775486',
    'local_end' => '60978362400',
    'is_dst' => 0,
    'offset' => -37800,
    'local_start' => '59926737686'
  },
  {
    'short_name' => 'HDT',
    'utc_end' => '60980211000',
    'utc_start' => '60978400200',
    'local_end' => '60980176800',
    'is_dst' => 0,
    'offset' => -34200,
    'local_start' => '60978366000'
  },
  {
    'short_name' => 'HT',
    'utc_end' => '61255485000',
    'utc_start' => '60980211000',
    'local_end' => '61255447200',
    'is_dst' => 0,
    'offset' => -37800,
    'local_start' => '60980173200'
  },
  {
    'short_name' => 'HWT',
    'utc_end' => '61366321800',
    'utc_start' => '61255485000',
    'local_end' => '61366287600',
    'is_dst' => 1,
    'offset' => -34200,
    'local_start' => '61255450800'
  },
  {
    'short_name' => 'HPT',
    'utc_end' => '61370307000',
    'utc_start' => '61366321800',
    'local_end' => '61370272800',
    'is_dst' => 1,
    'offset' => -34200,
    'local_start' => '61366287600'
  },
  {
    'short_name' => 'HST',
    'utc_end' => '61423533000',
    'utc_start' => '61370307000',
    'local_end' => '61423495200',
    'is_dst' => 0,
    'offset' => -37800,
    'local_start' => '61370269200'
  }
]
;

my $max_year = 2013;

sub _new_instance
{
    return shift->_init( @_, spans => $spans );
}

my $rules = [
  bless( {
    'letter' => 'S',
    'on' => 'lastSun',
    'save' => '0',
    'to' => 'max',
    'from' => '1967',
    'in' => 'Oct',
    'at' => '2:00',
    'type' => undef,
    'offset' => 0
  }, 'DateTime::TimeZone::OlsonDB::Rule' ),
  bless( {
    'letter' => 'D',
    'on' => 'Sun>=1',
    'save' => '1:00',
    'to' => 'max',
    'from' => '1987',
    'in' => 'Apr',
    'at' => '2:00',
    'type' => undef,
    'offset' => 3600
  }, 'DateTime::TimeZone::OlsonDB::Rule' )
]
;
my $last_observance = bless( {
  'until' => undef,
  'format' => 'HST',
  'gmtoff' => '-10:00',
  'rules' => undef,
  'offset' => -36000,
  'start' => bless( {
    'local_rd_secs' => 7200,
    'local_rd_days' => 710920,
    'language' => bless( {
      'month_numbers' => {},
      'am_pm' => [
        'AM',
        'PM'
      ],
      'ordinal_suffixes' => [],
      'month_abbreviations' => [
        'Jan',
        'Feb',
        'Mar',
        'Apr',
        'May',
        'Jun',
        'Jul',
        'Aug',
        'Sep',
        'Oct',
        'Nov',
        'Dec'
      ],
      'day_abbreviations' => [
        'Mon',
        'Tue',
        'Wed',
        'Thu',
        'Fri',
        'Sat',
        'Sun'
      ],
      'month_names' => [
        'January',
        'February',
        'March',
        'April',
        'May',
        'June',
        'July',
        'August',
        'September',
        'October',
        'November',
        'December'
      ],
      'day_numbers' => {},
      'day_names' => [
        'Monday',
        'Tuesday',
        'Wednesday',
        'Thursday',
        'Friday',
        'Saturday',
        'Sunday'
      ]
    }, 'DateTime::Language::English' ),
    'tz' => bless( {}, 'DateTime::TimeZone::UTC' ),
    'utc_rd_secs' => 7200,
    'utc_rd_days' => 710920,
    'local_c' => {
      'hour' => 2,
      'minute' => 0,
      'second' => 0,
      'month' => 6,
      'day_of_year' => 159,
      'day_of_week' => 7,
      'day' => 8,
      'year' => 1947
    }
  }, 'DateTime' )
}, 'DateTime::TimeZone::OlsonDB::Observance' )
;

sub _generate_spans_until_match
{
    my $self = shift;
    my $dt = shift;

    my $generate_until_year = $dt->utc_year + 1;

    my @changes;
    foreach my $rule (@$rules)
    {
        foreach my $year ( $max_year .. $generate_until_year )
        {
            my $next = $rule->date_for_year( $year, -36000 );

            # don't bother with changes we've seen already
            next if $next->{utc}->utc_rd_as_seconds < $self->{max_span}{utc_end};

            push @changes,
                DateTime::TimeZone::OlsonDB::Change->new
                    ( start_date => $next->{local},
                      short_name =>
                      sprintf( $last_observance->format, $rule->letter ),
                      observance => $last_observance,
                      rule       => $rule,
                    );
        }
    }

    $max_year = $generate_until_year;
    my @sorted = sort { $a->start_date <=> $b->start_date } @changes;

    my $seconds = $dt->utc_rd_as_seconds;
    my $match;

    for ( my $x = 1; $x < @sorted; $x++ )
    {
        my $last_offset =
            $x == 1 ? $self->{max_span}{offset} : $changes[ $x - 2 ]->offset;

        my $span =
            DateTime::TimeZone::OlsonDB::Change::two_changes_as_span
                ( @sorted[ $x - 1, $x ], $last_offset );

        push @{ $self->{spans} }, $span;

        $match = $span
            if $seconds >= $span->{utc_start} && $seconds < $span->{utc_end};
    }

    return $match;
}


1;

