package XUL::Node::Application::PeriodicTable::Scrolling;

use strict;
use warnings;
use Carp;
use XUL::Node;

use base 'XUL::Node::Application::PeriodicTable::Base';

sub get_demo_box {
	my $self = shift;
	VBox(FLEX,
		HBox(
			GroupBox(FLEX,
				Caption(label => 'The full list'),
				VBox(
					Button(label => 'Button #1'),
					Button(label => 'Button #2'),
					Button(label => 'Button #3'),
					Button(label => 'Button #4'),
					Button(label => 'Button #5'),
					Button(label => 'Button #6'),
					Button(label => 'Button #7'),
					Button(label => 'Button #8'),
					Button(label => 'Button #9'),
				),
			),
			VBox(FLEX,
				GroupBox(style => 'max-height:8em',
					Caption(label => 'The list limited in height, no overflow'),
					VBox(FLEX,
						Button(label => 'Button #1'),
						Button(label => 'Button #2'),
						Button(label => 'Button #3'),
						Button(label => 'Button #4'),
						Button(label => 'Button #5'),
						Button(label => 'Button #6'),
						Button(label => 'Button #7'),
						Button(label => 'Button #8'),
						Button(label => 'Button #9'),
					),
				),
				GroupBox(style => 'max-height:8em',
					Caption(label => 'The list limited in height, auto overflow'),
					VBox(FLEX, style => 'overflow: auto',
						Button(label => 'Button #1'),
						Button(label => 'Button #2'),
						Button(label => 'Button #3'),
						Button(label => 'Button #4'),
						Button(label => 'Button #5'),
						Button(label => 'Button #6'),
						Button(label => 'Button #7'),
						Button(label => 'Button #8'),
						Button(label => 'Button #9'),
					),
				),
				GroupBox(style => 'max-height:8em',
					Caption(label => 'The list limited in height, scroll overflow'),
					VBox(FLEX, style => 'overflow: scroll',
						Button(label => 'Button #1'),
						Button(label => 'Button #2'),
						Button(label => 'Button #3'),
						Button(label => 'Button #4'),
						Button(label => 'Button #5'),
						Button(label => 'Button #6'),
						Button(label => 'Button #7'),
						Button(label => 'Button #8'),
						Button(label => 'Button #9'),
					),
				),
			),
		),
		Description(value => 'arrowscrollbox - hover over the arrow to scroll'),
		ArrowScrollBox(FLEX, orient => 'vertical',
			Button(label => " 1 Astrix le Gaulois"),
			Button(label => " 2 La serpe d'or"),
			Button(label => " 3 Astrix et les Goths"),
			Button(label => " 4 Astrix gladiateur"),
			Button(label => " 5 Le tour de Gaule d'Astrix"),
			Button(label => " 6 Astrix et Cloptre"),
			Button(label => " 7 Le combat des chefs"),
			Button(label => " 8 Astrix chez les Bretons"),
			Button(label => " 9 Astrix et les Normands"),
			Button(label => "10 Astrix lgionnaire"),
			Button(label => "11 Le bouclier Arverne"),
			Button(label => "12 Astrix aux jeux olympiques"),
			Button(label => "13 Astrix et le chaudron"),
			Button(label => "14 Astrix en Hispanie"),
			Button(label => "15 La zizanie"),
			Button(label => "16 Astrix chez les Helvtes"),
			Button(label => "17 Le domaine des Dieux"),
			Button(label => "18 Les lauriers de Csar"),
			Button(label => "19 Le devin"),
			Button(label => "20 Astrix en Corse"),
			Button(label => "21 Le cadeau de Csar"),
			Button(label => "22 La grande traverse"),
			Button(label => "23 Oblix et compagnie"),
			Button(label => "24 Astrix chez les Belges"),
			Button(label => "25 Le grand Foss"),
			Button(label => "26 L'Odysse d'Astrix"),
			Button(label => "27 Le fils d'Astrix"),
			Button(label => "28 Astrix chez Rahzade"),
			Button(label => "29 La rose et le glaive"),
			Button(label => "30 La galre d'Oblix"),
			Button(label => "31 Astrix et Latraviata"),
		),
	);
}

1;
