/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

final class CharacteristicTypeMap
extends AbstractMap<String, DefaultAttributeType<?>> {
    private static final WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> SHARED = new WeakValueHashMap(DefaultAttributeType[].class);
    final DefaultAttributeType<?>[] characterizedBy;
    final Map<String, Integer> indices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacteristicTypeMap create(DefaultAttributeType<?> defaultAttributeType, DefaultAttributeType<?>[] defaultAttributeTypeArray) {
        CharacteristicTypeMap characteristicTypeMap;
        WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> weakValueHashMap = SHARED;
        synchronized (weakValueHashMap) {
            characteristicTypeMap = SHARED.get(defaultAttributeTypeArray);
            if (characteristicTypeMap == null) {
                characteristicTypeMap = new CharacteristicTypeMap(defaultAttributeType, defaultAttributeTypeArray);
                SHARED.put(defaultAttributeTypeArray, characteristicTypeMap);
            }
        }
        return characteristicTypeMap;
    }

    private CharacteristicTypeMap(DefaultAttributeType<?> defaultAttributeType, DefaultAttributeType<?>[] defaultAttributeTypeArray) {
        Comparable<GenericName> comparable;
        this.characterizedBy = defaultAttributeTypeArray;
        int n = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(Containers.hashMapCapacity(defaultAttributeTypeArray.length));
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (int i = 0; i < defaultAttributeTypeArray.length; ++i) {
            Map.Entry entry = defaultAttributeTypeArray[i];
            ArgumentChecks.ensureNonNullElement("characterizedBy", i, entry);
            comparable = ((AbstractIdentifiedType)((Object)entry)).getName();
            String string = AbstractIdentifiedType.toString((GenericName)comparable, defaultAttributeType, "characterizedBy", i);
            Integer n2 = n++;
            if (hashMap.put(string, n2) != null) {
                throw new IllegalArgumentException(Errors.format((short)25, string));
            }
            while (comparable instanceof ScopedName && comparable != (comparable = ((ScopedName)comparable).tail()) && (string = comparable.toString()) != null && !(string = string.trim()).isEmpty()) {
                if (hashMap2.put(string, n2) == null) continue;
                hashMap2.put(string, -1);
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            comparable = (Integer)entry.getValue();
            if ((Integer)comparable < 0) continue;
            JDK8.putIfAbsent(hashMap, entry.getKey(), comparable);
        }
        this.indices = CollectionsExt.compact(hashMap);
    }

    @Override
    public boolean isEmpty() {
        return this.characterizedBy.length == 0;
    }

    @Override
    public int size() {
        return this.characterizedBy.length;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.indices.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        for (DefaultAttributeType<?> defaultAttributeType : this.characterizedBy) {
            if (!defaultAttributeType.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DefaultAttributeType<?> get(Object object) {
        Integer n = this.indices.get(object);
        return n != null ? this.characterizedBy[n] : null;
    }

    @Override
    protected AbstractMap.EntryIterator<String, DefaultAttributeType<?>> entryIterator() {
        return new AbstractMap.EntryIterator<String, DefaultAttributeType<?>>(){
            private int index;
            private DefaultAttributeType<?> value;

            @Override
            protected boolean next() {
                if (this.index < CharacteristicTypeMap.this.characterizedBy.length) {
                    this.value = CharacteristicTypeMap.this.characterizedBy[this.index++];
                    return true;
                }
                return false;
            }

            @Override
            protected String getKey() {
                return this.value.getName().toString();
            }

            @Override
            protected DefaultAttributeType<?> getValue() {
                return this.value;
            }
        };
    }
}

