## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::datasize;

our $DATE = '2024-08-03'; # DATE
our $VERSION = '0.010'; # VERSION

our $rschema = do{my$var={base=>"float",clsets_after_base=>[{description=>"\nFloat, in bytes.\n\nCan be coerced from string that contains units, e.g.:\n\n    2KB   -> 2048      (kilobyte, 1024-based)\n    2mb   -> 2097152   (megabyte, 1024-based)\n    1.5K  -> 1536      (kilobyte, 1024-based)\n    1.6ki -> 1600      (kibibyte, 1000-based)\n\n",examples=>[{valid=>1,validated_value=>2048,value=>"2KB"},{valid=>1,validated_value=>2048,value=>"2 kb"},{valid=>1,validated_value=>2097152,value=>"2mb"},{valid=>1,validated_value=>1536,value=>"1.5K"},{valid=>1,validated_value=>1600,value=>"1.6ki"},{valid=>0,value=>"1zzz"}],min=>0,summary=>"Data size","x.perl.coerce_rules"=>["From_str::suffix_datasize"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["float"],type=>"float",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Data size

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::datasize - Data size

=head1 VERSION

This document describes version 0.010 of Sah::SchemaR::datasize (from Perl distribution Sah-SchemaBundle-DataSizeSpeed), released on 2024-08-03.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-DataSizeSpeed>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-DataSizeSpeed>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2020, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-DataSizeSpeed>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
