/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ALinkImpl;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.LinkString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zoda1 {
    private final Map<String, ANodeImpl> nodes = new LinkedHashMap<String, ANodeImpl>();
    private final List<ALink> links = new ArrayList<ALink>();

    public ANodeImpl getNode(String string) {
        ANodeImpl aNodeImpl = this.nodes.get(string);
        if (aNodeImpl == null) {
            aNodeImpl = new ANodeImpl(string);
            this.nodes.put(string, aNodeImpl);
        }
        return aNodeImpl;
    }

    public ANodeImpl getExistingNode(String string) {
        return this.nodes.get(string);
    }

    public List<ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public List<ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANodeImpl>(this.nodes.values()));
    }

    public void addLink(String string) {
        LinkString linkString = new LinkString(string);
        ANodeImpl aNodeImpl = this.getNode(linkString.getNode1());
        ANodeImpl aNodeImpl2 = this.getNode(linkString.getNode2());
        this.links.add(new ALinkImpl(aNodeImpl, aNodeImpl2, 1, null));
    }

    public void computeRows() {
        this.getNodes().get(0).setRow(0);
        for (int i = 0; i < this.links.size(); ++i) {
            this.oneStep1();
            this.oneStep2();
        }
        this.removeUnplacedNodes();
    }

    private void removeUnplacedNodes() {
        Iterator<ANodeImpl> iterator = this.nodes.values().iterator();
        while (iterator.hasNext()) {
            ANodeImpl aNodeImpl = iterator.next();
            if (aNodeImpl.getRow() != Integer.MIN_VALUE) continue;
            this.removeLinksOf(aNodeImpl);
            iterator.remove();
        }
    }

    private void removeLinksOf(ANodeImpl aNodeImpl) {
        Iterator<ALink> iterator = this.links.iterator();
        while (iterator.hasNext()) {
            ALink aLink = iterator.next();
            if (aLink.getNode1() != aNodeImpl && aLink.getNode2() != aNodeImpl) continue;
            iterator.remove();
        }
    }

    public int getRowMax() {
        int n = 0;
        for (ANode aNode : this.getNodes()) {
            if (aNode.getRow() == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            if (aNode.getRow() <= n) continue;
            n = aNode.getRow();
        }
        return n;
    }

    private void oneStep1() {
        for (ALink aLink : this.links) {
            ANode aNode = aLink.getNode1();
            if (aNode.getRow() == Integer.MIN_VALUE) continue;
            ANode aNode2 = aLink.getNode2();
            if (aNode2.getRow() == Integer.MIN_VALUE) {
                aNode2.setRow(aNode.getRow() + 1);
                continue;
            }
            if (aNode2.getRow() >= aNode.getRow() + 1) continue;
            aNode2.setRow(aNode.getRow() + 1);
        }
    }

    private void oneStep2() {
        for (ALink aLink : this.links) {
            int n;
            ANode aNode = aLink.getNode1();
            ANode aNode2 = aLink.getNode2();
            if (aNode.getRow() != Integer.MIN_VALUE || aNode2.getRow() == Integer.MIN_VALUE) continue;
            if (aNode2.getRow() == 0) {
                this.allDown();
            }
            if ((n = aNode2.getRow() - 1) == -1) {
                throw new UnsupportedOperationException();
            }
            aNode.setRow(n);
        }
    }

    private void allDown() {
        for (ANodeImpl aNodeImpl : this.nodes.values()) {
            if (aNodeImpl.getRow() == Integer.MIN_VALUE) continue;
            aNodeImpl.setRow(aNodeImpl.getRow() + 1);
        }
    }
}

