/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BytesCapturingInputStream
extends FilterInputStream {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public BytesCapturingInputStream(InputStream input) {
        super(input);
    }

    public int read() throws IOException {
        int value = super.read();
        this.data.write(value);
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.data.write(b, off, read);
        }
        return read;
    }

    public byte[] getData() {
        return this.data.toByteArray();
    }
}

