/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Relationship;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.TableMetaData;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.CursorImpl;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DefaultCodecProvider;
import com.healthmarketscience.jackcess.impl.FKEnforcer;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.PropertyMaps;
import com.healthmarketscience.jackcess.impl.RelationshipCreator;
import com.healthmarketscience.jackcess.impl.RelationshipImpl;
import com.healthmarketscience.jackcess.impl.RowIdImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import com.healthmarketscience.jackcess.util.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.util.ColumnValidatorFactory;
import com.healthmarketscience.jackcess.util.ErrorHandler;
import com.healthmarketscience.jackcess.util.LinkResolver;
import com.healthmarketscience.jackcess.util.ReadOnlyFileChannel;
import com.healthmarketscience.jackcess.util.SimpleColumnValidatorFactory;
import com.healthmarketscience.jackcess.util.TableIterableBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseImpl
implements Database {
    private static final Log LOG = LogFactory.getLog(DatabaseImpl.class);
    private static final byte[] SYS_DEFAULT_SID = new byte[]{-90, 51};
    public static final String DEFAULT_RESOURCE_PATH = "com/healthmarketscience/jackcess/";
    static final String RESOURCE_PATH = System.getProperty("com.healthmarketscience.jackcess.resourcePath", "com/healthmarketscience/jackcess/");
    static final boolean BROKEN_NIO = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("com.healthmarketscience.jackcess.brokenNio"));
    private static final Map<Database.FileFormat, FileFormatDetails> FILE_FORMAT_DETAILS = new EnumMap<Database.FileFormat, FileFormatDetails>(Database.FileFormat.class);
    private static final int PAGE_SYSTEM_CATALOG = 2;
    private static final String TABLE_SYSTEM_CATALOG = "MSysObjects";
    private static final Integer SYS_FULL_ACCESS_ACM;
    private static final String ACE_COL_ACM = "ACM";
    private static final String ACE_COL_F_INHERITABLE = "FInheritable";
    private static final String ACE_COL_OBJECT_ID = "ObjectId";
    private static final String ACE_COL_SID = "SID";
    private static final String REL_COL_COLUMN_COUNT = "ccolumn";
    private static final String REL_COL_FLAGS = "grbit";
    private static final String REL_COL_COLUMN_INDEX = "icolumn";
    private static final String REL_COL_TO_COLUMN = "szColumn";
    private static final String REL_COL_TO_TABLE = "szObject";
    private static final String REL_COL_FROM_COLUMN = "szReferencedColumn";
    private static final String REL_COL_FROM_TABLE = "szReferencedObject";
    private static final String REL_COL_NAME = "szRelationship";
    private static final String CAT_COL_ID = "Id";
    private static final String CAT_COL_NAME = "Name";
    private static final String CAT_COL_OWNER = "Owner";
    private static final String CAT_COL_PARENT_ID = "ParentId";
    private static final String CAT_COL_TYPE = "Type";
    private static final String CAT_COL_DATE_CREATE = "DateCreate";
    private static final String CAT_COL_DATE_UPDATE = "DateUpdate";
    private static final String CAT_COL_FLAGS = "Flags";
    static final String CAT_COL_PROPS = "LvProp";
    private static final String CAT_COL_DATABASE = "Database";
    private static final String CAT_COL_FOREIGN_NAME = "ForeignName";
    private static final int DB_PARENT_ID = 0xF000000;
    private static final long MAX_EMPTYDB_SIZE = 370000L;
    static final int SYSTEM_OBJECT_FLAG = Integer.MIN_VALUE;
    static final int ALT_SYSTEM_OBJECT_FLAG = 2;
    public static final int HIDDEN_OBJECT_FLAG = 8;
    static final int SYSTEM_OBJECT_FLAGS = -2147483646;
    public static final String RO_CHANNEL_MODE = "r";
    public static final String RW_CHANNEL_MODE = "rw";
    private static final String SYSTEM_OBJECT_NAME_TABLES = "Tables";
    private static final String SYSTEM_OBJECT_NAME_DATABASES = "Databases";
    private static final String SYSTEM_OBJECT_NAME_RELATIONSHIPS = "Relationships";
    private static final String TABLE_SYSTEM_ACES = "MSysACEs";
    private static final String TABLE_SYSTEM_RELATIONSHIPS = "MSysRelationships";
    private static final String TABLE_SYSTEM_QUERIES = "MSysQueries";
    private static final String TABLE_SYSTEM_COMPLEX_COLS = "MSysComplexColumns";
    private static final String OBJECT_NAME_DB_PROPS = "MSysDb";
    private static final String OBJECT_NAME_SUMMARY_PROPS = "SummaryInfo";
    private static final String OBJECT_NAME_USERDEF_PROPS = "UserDefined";
    static final Short TYPE_TABLE;
    private static final Short TYPE_QUERY;
    private static final Short TYPE_LINKED_TABLE;
    private static final Short TYPE_RELATIONSHIP;
    private static final int MAX_CACHED_LOOKUP_TABLES = 50;
    private static Collection<String> SYSTEM_CATALOG_COLUMNS;
    private static Collection<String> SYSTEM_CATALOG_TABLE_DETAIL_COLUMNS;
    private static Collection<String> SYSTEM_CATALOG_PROPS_COLUMNS;
    private static final Pattern INVALID_IDENTIFIER_CHARS;
    private final File _file;
    private final String _name;
    private ByteBuffer _buffer;
    private Integer _tableParentId;
    private final JetFormat _format;
    private final Map<String, TableInfo> _tableLookup = new LinkedHashMap<String, TableInfo>(){
        private static final long serialVersionUID = 0L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TableInfo> e) {
            return this.size() > 50;
        }
    };
    private Set<String> _tableNames;
    private final PageChannel _pageChannel;
    private TableImpl _systemCatalog;
    private TableFinder _tableFinder;
    private TableImpl _accessControlEntries;
    private Integer _relParentId;
    private final List<byte[]> _newRelSIDs = new ArrayList<byte[]>();
    private TableImpl _relationships;
    private TableImpl _queries;
    private TableImpl _complexCols;
    private final List<byte[]> _newTableSIDs = new ArrayList<byte[]>();
    private ErrorHandler _dbErrorHandler;
    private Database.FileFormat _fileFormat;
    private Charset _charset;
    private TimeZone _timeZone;
    private ColumnImpl.SortOrder _defaultSortOrder;
    private Short _defaultCodePage;
    private Table.ColumnOrder _columnOrder;
    private boolean _enforceForeignKeys;
    private boolean _allowAutoNumInsert;
    private ColumnValidatorFactory _validatorFactory = SimpleColumnValidatorFactory.INSTANCE;
    private final TableCache _tableCache = new TableCache();
    private PropertyMaps.Handler _propsHandler;
    private Integer _dbParentId;
    private byte[] _newObjOwner;
    private PropertyMaps _dbPropMaps;
    private PropertyMaps _summaryPropMaps;
    private PropertyMaps _userDefPropMaps;
    private LinkResolver _linkResolver;
    private Map<String, Database> _linkedDbs;
    private final FKEnforcer.SharedState _fkEnforcerSharedState = FKEnforcer.initSharedState();
    private Calendar _calendar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseImpl open(File mdbFile, boolean readOnly, FileChannel channel, boolean autoSync, Charset charset, TimeZone timeZone, CodecProvider provider) throws IOException {
        boolean closeChannel = false;
        if (channel == null) {
            if (!mdbFile.exists() || !mdbFile.canRead()) {
                throw new FileNotFoundException("given file does not exist: " + mdbFile);
            }
            channel = DatabaseImpl.openChannel(mdbFile, readOnly |= !mdbFile.canWrite());
            closeChannel = true;
        }
        boolean success = false;
        try {
            if (!readOnly) {
                JetFormat jetFormat = JetFormat.getFormat(channel);
                if (jetFormat.READ_ONLY) {
                    channel = new ReadOnlyFileChannel(channel);
                    readOnly = true;
                }
            }
            DatabaseImpl db = new DatabaseImpl(mdbFile, channel, closeChannel, autoSync, null, charset, timeZone, provider);
            success = true;
            DatabaseImpl databaseImpl = db;
            return databaseImpl;
        }
        finally {
            if (!success && closeChannel) {
                ByteUtil.closeQuietly(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseImpl create(Database.FileFormat fileFormat, File mdbFile, FileChannel channel, boolean autoSync, Charset charset, TimeZone timeZone) throws IOException {
        FileFormatDetails details = DatabaseImpl.getFileFormatDetails(fileFormat);
        if (details.getFormat().READ_ONLY) {
            throw new IOException("File format " + (Object)((Object)fileFormat) + " does not support writing for " + mdbFile);
        }
        if (details.getEmptyFilePath() == null) {
            throw new IOException("File format " + (Object)((Object)fileFormat) + " does not support file creation for " + mdbFile);
        }
        boolean closeChannel = false;
        if (channel == null) {
            channel = DatabaseImpl.openChannel(mdbFile, false);
            closeChannel = true;
        }
        boolean success = false;
        try {
            channel.truncate(0L);
            DatabaseImpl.transferDbFrom(channel, DatabaseImpl.getResourceAsStream(details.getEmptyFilePath()));
            channel.force(true);
            DatabaseImpl db = new DatabaseImpl(mdbFile, channel, closeChannel, autoSync, fileFormat, charset, timeZone, null);
            success = true;
            DatabaseImpl databaseImpl = db;
            return databaseImpl;
        }
        finally {
            if (!success && closeChannel) {
                ByteUtil.closeQuietly(channel);
            }
        }
    }

    static FileChannel openChannel(File mdbFile, boolean readOnly) throws FileNotFoundException {
        String mode = readOnly ? RO_CHANNEL_MODE : RW_CHANNEL_MODE;
        return new RandomAccessFile(mdbFile, mode).getChannel();
    }

    protected DatabaseImpl(File file, FileChannel channel, boolean closeChannel, boolean autoSync, Database.FileFormat fileFormat, Charset charset, TimeZone timeZone, CodecProvider provider) throws IOException {
        this._file = file;
        this._name = DatabaseImpl.getName(file);
        this._format = JetFormat.getFormat(channel);
        this._charset = charset == null ? DatabaseImpl.getDefaultCharset(this._format) : charset;
        this._columnOrder = DatabaseImpl.getDefaultColumnOrder();
        this._enforceForeignKeys = DatabaseImpl.getDefaultEnforceForeignKeys();
        this._allowAutoNumInsert = DatabaseImpl.getDefaultAllowAutoNumberInsert();
        this._fileFormat = fileFormat;
        this._pageChannel = new PageChannel(channel, closeChannel, this._format, autoSync);
        TimeZone timeZone2 = this._timeZone = timeZone == null ? DatabaseImpl.getDefaultTimeZone() : timeZone;
        if (provider == null) {
            provider = DefaultCodecProvider.INSTANCE;
        }
        this._pageChannel.initialize(this, provider);
        this._buffer = this._pageChannel.createPageBuffer();
        this.readSystemCatalog();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this._name;
    }

    public PageChannel getPageChannel() {
        return this._pageChannel;
    }

    public JetFormat getFormat() {
        return this._format;
    }

    public TableImpl getSystemCatalog() {
        return this._systemCatalog;
    }

    public TableImpl getAccessControlEntries() throws IOException {
        if (this._accessControlEntries == null) {
            this._accessControlEntries = this.getRequiredSystemTable(TABLE_SYSTEM_ACES);
        }
        return this._accessControlEntries;
    }

    public TableImpl getSystemComplexColumns() throws IOException {
        if (this._complexCols == null) {
            this._complexCols = this.getRequiredSystemTable(TABLE_SYSTEM_COMPLEX_COLS);
        }
        return this._complexCols;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._dbErrorHandler != null ? this._dbErrorHandler : ErrorHandler.DEFAULT;
    }

    @Override
    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this._dbErrorHandler = newErrorHandler;
    }

    @Override
    public LinkResolver getLinkResolver() {
        return this._linkResolver != null ? this._linkResolver : LinkResolver.DEFAULT;
    }

    @Override
    public void setLinkResolver(LinkResolver newLinkResolver) {
        this._linkResolver = newLinkResolver;
    }

    @Override
    public Map<String, Database> getLinkedDatabases() {
        return this._linkedDbs == null ? Collections.emptyMap() : Collections.unmodifiableMap(this._linkedDbs);
    }

    @Override
    public boolean isLinkedTable(Table table) throws IOException {
        if (table == null || this == table.getDatabase()) {
            return false;
        }
        TableInfo tableInfo = this.lookupTable(table.getName());
        if (tableInfo != null && tableInfo.isLinked() && this.matchesLinkedTable(table, ((LinkedTableInfo)tableInfo).linkedTableName, ((LinkedTableInfo)tableInfo).linkedDbName)) {
            return true;
        }
        return this._tableFinder.isLinkedTable(table);
    }

    private boolean matchesLinkedTable(Table table, String linkedTableName, String linkedDbName) {
        return table.getName().equalsIgnoreCase(linkedTableName) && this._linkedDbs != null && this._linkedDbs.get(linkedDbName) == table.getDatabase();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    @Override
    public void setTimeZone(TimeZone newTimeZone) {
        if (newTimeZone == null) {
            newTimeZone = DatabaseImpl.getDefaultTimeZone();
        }
        this._timeZone = newTimeZone;
        this._calendar = null;
    }

    @Override
    public Charset getCharset() {
        return this._charset;
    }

    @Override
    public void setCharset(Charset newCharset) {
        if (newCharset == null) {
            newCharset = DatabaseImpl.getDefaultCharset(this.getFormat());
        }
        this._charset = newCharset;
    }

    @Override
    public Table.ColumnOrder getColumnOrder() {
        return this._columnOrder;
    }

    @Override
    public void setColumnOrder(Table.ColumnOrder newColumnOrder) {
        if (newColumnOrder == null) {
            newColumnOrder = DatabaseImpl.getDefaultColumnOrder();
        }
        this._columnOrder = newColumnOrder;
    }

    @Override
    public boolean isEnforceForeignKeys() {
        return this._enforceForeignKeys;
    }

    @Override
    public void setEnforceForeignKeys(Boolean newEnforceForeignKeys) {
        if (newEnforceForeignKeys == null) {
            newEnforceForeignKeys = DatabaseImpl.getDefaultEnforceForeignKeys();
        }
        this._enforceForeignKeys = newEnforceForeignKeys;
    }

    @Override
    public boolean isAllowAutoNumberInsert() {
        return this._allowAutoNumInsert;
    }

    @Override
    public void setAllowAutoNumberInsert(Boolean allowAutoNumInsert) {
        if (allowAutoNumInsert == null) {
            allowAutoNumInsert = DatabaseImpl.getDefaultAllowAutoNumberInsert();
        }
        this._allowAutoNumInsert = allowAutoNumInsert;
    }

    @Override
    public ColumnValidatorFactory getColumnValidatorFactory() {
        return this._validatorFactory;
    }

    @Override
    public void setColumnValidatorFactory(ColumnValidatorFactory newFactory) {
        if (newFactory == null) {
            newFactory = SimpleColumnValidatorFactory.INSTANCE;
        }
        this._validatorFactory = newFactory;
    }

    FKEnforcer.SharedState getFKEnforcerSharedState() {
        return this._fkEnforcerSharedState;
    }

    Calendar getCalendar() {
        if (this._calendar == null) {
            this._calendar = DatabaseBuilder.toCompatibleCalendar(Calendar.getInstance(this._timeZone));
        }
        return this._calendar;
    }

    private PropertyMaps.Handler getPropsHandler() {
        if (this._propsHandler == null) {
            this._propsHandler = new PropertyMaps.Handler(this);
        }
        return this._propsHandler;
    }

    @Override
    public Database.FileFormat getFileFormat() throws IOException {
        if (this._fileFormat == null) {
            Map<String, Database.FileFormat> possibleFileFormats = this.getFormat().getPossibleFileFormats();
            if (possibleFileFormats.size() == 1) {
                this._fileFormat = possibleFileFormats.get(null);
            } else {
                String accessVersion = (String)this.getDatabaseProperties().getValue("AccessVersion");
                if (DatabaseImpl.isBlank(accessVersion)) {
                    accessVersion = null;
                }
                this._fileFormat = possibleFileFormats.get(accessVersion);
                if (this._fileFormat == null) {
                    throw new IllegalStateException(this.withErrorContext("Could not determine FileFormat"));
                }
            }
        }
        return this._fileFormat;
    }

    private ByteBuffer takeSharedBuffer() {
        if (this._buffer != null) {
            ByteBuffer curBuffer = this._buffer;
            this._buffer = null;
            return curBuffer;
        }
        return this._pageChannel.createPageBuffer();
    }

    private void releaseSharedBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public ColumnImpl.SortOrder getDefaultSortOrder() throws IOException {
        if (this._defaultSortOrder == null) {
            this.initRootPageInfo();
        }
        return this._defaultSortOrder;
    }

    public short getDefaultCodePage() throws IOException {
        if (this._defaultCodePage == null) {
            this.initRootPageInfo();
        }
        return this._defaultCodePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRootPageInfo() throws IOException {
        ByteBuffer buffer = this.takeSharedBuffer();
        try {
            this._pageChannel.readPage(buffer, 0);
            this._defaultSortOrder = ColumnImpl.readSortOrder(buffer, this._format.OFFSET_SORT_ORDER, this._format);
            this._defaultCodePage = buffer.getShort(this._format.OFFSET_CODE_PAGE);
        }
        finally {
            this.releaseSharedBuffer(buffer);
        }
    }

    public PropertyMaps readProperties(byte[] propsBytes, int objectId, RowIdImpl rowId) throws IOException {
        return this.getPropsHandler().read(propsBytes, objectId, rowId);
    }

    private void readSystemCatalog() throws IOException {
        this._systemCatalog = this.readTable(TABLE_SYSTEM_CATALOG, 2, -2147483646);
        try {
            this._tableFinder = new DefaultTableFinder(this._systemCatalog.newCursor().setIndexByColumnNames(CAT_COL_PARENT_ID, CAT_COL_NAME).setColumnMatcher(CaseInsensitiveColumnMatcher.INSTANCE).toIndexCursor());
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.withErrorContext("Could not find expected index on table " + this._systemCatalog.getName()));
            }
            this._tableFinder = new FallbackTableFinder(this._systemCatalog.newCursor().setColumnMatcher(CaseInsensitiveColumnMatcher.INSTANCE).toCursor());
        }
        this._tableParentId = this._tableFinder.findObjectId(0xF000000, SYSTEM_OBJECT_NAME_TABLES);
        if (this._tableParentId == null) {
            throw new IOException(this.withErrorContext("Did not find required parent table id"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.withErrorContext("Finished reading system catalog.  Tables: " + this.getTableNames()));
        }
    }

    @Override
    public Set<String> getTableNames() throws IOException {
        if (this._tableNames == null) {
            this._tableNames = this.getTableNames(true, false, true);
        }
        return this._tableNames;
    }

    @Override
    public Set<String> getSystemTableNames() throws IOException {
        return this.getTableNames(false, true, false);
    }

    private Set<String> getTableNames(boolean normalTables, boolean systemTables, boolean linkedTables) throws IOException {
        TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this._tableFinder.getTableNames(tableNames, normalTables, systemTables, linkedTables);
        return tableNames;
    }

    @Override
    public Iterator<Table> iterator() {
        try {
            return new TableIterator(this.getTableNames());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public Iterator<Table> iterator(TableIterableBuilder builder) {
        try {
            return new TableIterator(this.getTableNames(builder.isIncludeNormalTables(), builder.isIncludeSystemTables(), builder.isIncludeLinkedTables()));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public TableIterableBuilder newIterable() {
        return new TableIterableBuilder(this);
    }

    @Override
    public TableImpl getTable(String name) throws IOException {
        return this.getTable(name, false);
    }

    @Override
    public TableMetaData getTableMetaData(String name) throws IOException {
        return this.getTableInfo(name, true);
    }

    public TableImpl getTable(int tableDefPageNumber) throws IOException {
        TableImpl table = this._tableCache.get(tableDefPageNumber);
        if (table != null) {
            return table;
        }
        Row objectRow = this._tableFinder.getObjectRow(tableDefPageNumber, SYSTEM_CATALOG_COLUMNS);
        if (objectRow == null) {
            return null;
        }
        String name = objectRow.getString(CAT_COL_NAME);
        int flags = objectRow.getInt(CAT_COL_FLAGS);
        return this.readTable(name, tableDefPageNumber, flags);
    }

    protected TableImpl getTable(String name, boolean includeSystemTables) throws IOException {
        TableInfo tableInfo = this.getTableInfo(name, includeSystemTables);
        return tableInfo != null ? this.getTable(tableInfo, includeSystemTables) : null;
    }

    private TableInfo getTableInfo(String name, boolean includeSystemTables) throws IOException {
        TableInfo tableInfo = this.lookupTable(name);
        if (tableInfo == null || tableInfo.pageNumber == null) {
            return null;
        }
        if (!includeSystemTables && tableInfo.isSystem()) {
            return null;
        }
        return tableInfo;
    }

    private TableImpl getTable(TableInfo tableInfo, boolean includeSystemTables) throws IOException {
        if (tableInfo.isLinked()) {
            if (this._linkedDbs == null) {
                this._linkedDbs = new HashMap<String, Database>();
            }
            String linkedDbName = ((LinkedTableInfo)tableInfo).linkedDbName;
            String linkedTableName = ((LinkedTableInfo)tableInfo).linkedTableName;
            Database linkedDb = this._linkedDbs.get(linkedDbName);
            if (linkedDb == null) {
                linkedDb = this.getLinkResolver().resolveLinkedDatabase(this, linkedDbName);
                this._linkedDbs.put(linkedDbName, linkedDb);
            }
            return ((DatabaseImpl)linkedDb).getTable(linkedTableName, includeSystemTables);
        }
        return this.readTable(tableInfo.tableName, tableInfo.pageNumber, tableInfo.flags);
    }

    @Deprecated
    public void createTable(String name, List<ColumnBuilder> columns) throws IOException {
        this.createTable(name, columns, null);
    }

    @Deprecated
    public void createTable(String name, List<ColumnBuilder> columns, List<IndexBuilder> indexes) throws IOException {
        new TableBuilder(name).addColumns(columns).addIndexes(indexes).toTable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLinkedTable(String name, String linkedDbName, String linkedTableName) throws IOException {
        if (this.lookupTable(name) != null) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot create linked table with name of existing table '" + name + "'"));
        }
        DatabaseImpl.validateIdentifierName(name, this.getFormat().MAX_TABLE_NAME_LENGTH, "table");
        DatabaseImpl.validateName(linkedDbName, DataType.MEMO.getMaxSize(), "linked database");
        DatabaseImpl.validateIdentifierName(linkedTableName, this.getFormat().MAX_TABLE_NAME_LENGTH, "linked table");
        this.getPageChannel().startWrite();
        try {
            int linkedTableId = this._tableFinder.getNextFreeSyntheticId();
            this.addNewTable(name, linkedTableId, TYPE_LINKED_TABLE, linkedDbName, linkedTableName);
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    void addNewTable(String name, int tdefPageNumber, Short type, String linkedDbName, String linkedTableName) throws IOException {
        this.addTable(name, tdefPageNumber, type, linkedDbName, linkedTableName);
        this.addToSystemCatalog(name, tdefPageNumber, type, linkedDbName, linkedTableName, this._tableParentId);
        this.addToAccessControlEntries(tdefPageNumber, this._tableParentId, this._newTableSIDs);
    }

    @Override
    public List<Relationship> getRelationships(Table table1, Table table2) throws IOException {
        return this.getRelationships((TableImpl)table1, (TableImpl)table2);
    }

    public List<Relationship> getRelationships(TableImpl table1, TableImpl table2) throws IOException {
        int nameCmp = table1.getName().compareTo(table2.getName());
        if (nameCmp == 0) {
            throw new IllegalArgumentException(this.withErrorContext("Must provide two different tables"));
        }
        if (nameCmp > 0) {
            TableImpl tmp = table1;
            table1 = table2;
            table2 = tmp;
        }
        return this.getRelationshipsImpl(table1, table2, true);
    }

    @Override
    public List<Relationship> getRelationships(Table table) throws IOException {
        if (table == null) {
            throw new IllegalArgumentException(this.withErrorContext("Must provide a table"));
        }
        return this.getRelationshipsImpl((TableImpl)table, null, true);
    }

    @Override
    public List<Relationship> getRelationships() throws IOException {
        return this.getRelationshipsImpl(null, null, false);
    }

    @Override
    public List<Relationship> getSystemRelationships() throws IOException {
        return this.getRelationshipsImpl(null, null, true);
    }

    private List<Relationship> getRelationshipsImpl(TableImpl table1, TableImpl table2, boolean includeSystemTables) throws IOException {
        this.initRelationships();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (table1 != null) {
            Cursor cursor = this.createCursorWithOptionalIndex(this._relationships, REL_COL_FROM_TABLE, table1.getName());
            this.collectRelationships(cursor, table1, table2, relationships, includeSystemTables);
            cursor = this.createCursorWithOptionalIndex(this._relationships, REL_COL_TO_TABLE, table1.getName());
            this.collectRelationships(cursor, table2, table1, relationships, includeSystemTables);
        } else {
            this.collectRelationships(new CursorBuilder(this._relationships).toCursor(), null, null, relationships, includeSystemTables);
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationshipImpl writeRelationship(RelationshipCreator creator) throws IOException {
        this.initRelationships();
        String name = this.createRelationshipName(creator);
        RelationshipImpl newRel = creator.createRelationshipImpl(name);
        ColumnImpl ccol = this._relationships.getColumn(REL_COL_COLUMN_COUNT);
        ColumnImpl flagCol = this._relationships.getColumn(REL_COL_FLAGS);
        ColumnImpl icol = this._relationships.getColumn(REL_COL_COLUMN_INDEX);
        ColumnImpl nameCol = this._relationships.getColumn(REL_COL_NAME);
        ColumnImpl fromTableCol = this._relationships.getColumn(REL_COL_FROM_TABLE);
        ColumnImpl fromColCol = this._relationships.getColumn(REL_COL_FROM_COLUMN);
        ColumnImpl toTableCol = this._relationships.getColumn(REL_COL_TO_TABLE);
        ColumnImpl toColCol = this._relationships.getColumn(REL_COL_TO_COLUMN);
        int numCols = newRel.getFromColumns().size();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numCols);
        for (int i = 0; i < numCols; ++i) {
            Object[] row = new Object[this._relationships.getColumnCount()];
            ccol.setRowValue(row, (Object)numCols);
            flagCol.setRowValue(row, (Object)newRel.getFlags());
            icol.setRowValue(row, (Object)i);
            nameCol.setRowValue(row, (Object)name);
            fromTableCol.setRowValue(row, (Object)newRel.getFromTable().getName());
            fromColCol.setRowValue(row, (Object)newRel.getFromColumns().get(i).getName());
            toTableCol.setRowValue(row, (Object)newRel.getToTable().getName());
            toColCol.setRowValue(row, (Object)newRel.getToColumns().get(i).getName());
            rows.add(row);
        }
        this.getPageChannel().startWrite();
        try {
            int relObjId = this._tableFinder.getNextFreeSyntheticId();
            this._relationships.addRows(rows);
            this.addToSystemCatalog(name, relObjId, TYPE_RELATIONSHIP, null, null, this._relParentId);
            this.addToAccessControlEntries(relObjId, this._relParentId, this._newRelSIDs);
        }
        finally {
            this.getPageChannel().finishWrite();
        }
        return newRel;
    }

    private void initRelationships() throws IOException {
        if (this._relationships == null) {
            this._relParentId = this._tableFinder.findObjectId(0xF000000, SYSTEM_OBJECT_NAME_RELATIONSHIPS);
            this._relationships = this.getRequiredSystemTable(TABLE_SYSTEM_RELATIONSHIPS);
        }
    }

    private String createRelationshipName(RelationshipCreator creator) throws IOException {
        String baseName;
        int maxIdLen = this.getFormat().MAX_INDEX_NAME_LENGTH;
        int limit = maxIdLen / 2 - 3;
        String origName = creator.getName();
        if (origName == null) {
            origName = creator.getPrimaryTable().getName();
            if (origName.length() > limit) {
                origName = origName.substring(0, limit);
            }
            origName = origName + creator.getSecondaryTable().getName();
        }
        limit = maxIdLen - 3;
        if (origName.length() > limit) {
            origName = origName.substring(0, limit);
        }
        HashSet<String> names = new HashSet<String>();
        for (Row row : CursorImpl.createCursor(this._systemCatalog).newIterable().setColumnNames(SYSTEM_CATALOG_COLUMNS)) {
            String name = row.getString(CAT_COL_NAME);
            if (name == null || !TYPE_RELATIONSHIP.equals(row.get(CAT_COL_TYPE))) continue;
            names.add(DatabaseImpl.toLookupName(name));
        }
        if (creator.hasReferentialIntegrity()) {
            for (IndexImpl idx : creator.getSecondaryTable().getIndexes()) {
                names.add(DatabaseImpl.toLookupName(idx.getName()));
            }
        }
        String name = baseName = DatabaseImpl.toLookupName(origName);
        int i = 0;
        while (names.contains(name)) {
            name = baseName + ++i;
        }
        return i == 0 ? origName : origName + i;
    }

    @Override
    public List<Query> getQueries() throws IOException {
        if (this._queries == null) {
            this._queries = this.getRequiredSystemTable(TABLE_SYSTEM_QUERIES);
        }
        ArrayList<Row> queryInfo = new ArrayList<Row>();
        HashMap queryRowMap = new HashMap();
        for (Row row : CursorImpl.createCursor(this._systemCatalog).newIterable().setColumnNames(SYSTEM_CATALOG_COLUMNS)) {
            String name = row.getString(CAT_COL_NAME);
            if (name == null || !TYPE_QUERY.equals(row.get(CAT_COL_TYPE))) continue;
            queryInfo.add(row);
            Integer id = row.getInt(CAT_COL_ID);
            queryRowMap.put(id, new ArrayList());
        }
        for (Row row : CursorImpl.createCursor(this._queries)) {
            QueryImpl.Row queryRow = new QueryImpl.Row(row);
            List queryRows = (List)queryRowMap.get(queryRow.objectId);
            if (queryRows == null) {
                LOG.warn(this.withErrorContext("Found rows for query with id " + queryRow.objectId + " missing from system catalog"));
                continue;
            }
            queryRows.add(queryRow);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Row row : queryInfo) {
            String name = row.getString(CAT_COL_NAME);
            Integer id = row.getInt(CAT_COL_ID);
            int flags = row.getInt(CAT_COL_FLAGS);
            List queryRows = (List)queryRowMap.get(id);
            queries.add(QueryImpl.create(flags, name, queryRows, id));
        }
        return queries;
    }

    @Override
    public TableImpl getSystemTable(String tableName) throws IOException {
        return this.getTable(tableName, true);
    }

    private TableImpl getRequiredSystemTable(String tableName) throws IOException {
        TableImpl table = this.getSystemTable(tableName);
        if (table == null) {
            throw new IOException(this.withErrorContext("Could not find system table " + tableName));
        }
        return table;
    }

    @Override
    public PropertyMap getDatabaseProperties() throws IOException {
        if (this._dbPropMaps == null) {
            this._dbPropMaps = this.getPropertiesForDbObject(OBJECT_NAME_DB_PROPS);
        }
        return this._dbPropMaps.getDefault();
    }

    @Override
    public PropertyMap getSummaryProperties() throws IOException {
        if (this._summaryPropMaps == null) {
            this._summaryPropMaps = this.getPropertiesForDbObject(OBJECT_NAME_SUMMARY_PROPS);
        }
        return this._summaryPropMaps.getDefault();
    }

    @Override
    public PropertyMap getUserDefinedProperties() throws IOException {
        if (this._userDefPropMaps == null) {
            this._userDefPropMaps = this.getPropertiesForDbObject(OBJECT_NAME_USERDEF_PROPS);
        }
        return this._userDefPropMaps.getDefault();
    }

    public PropertyMaps getPropertiesForObject(int objectId) throws IOException {
        Row objectRow = this._tableFinder.getObjectRow(objectId, SYSTEM_CATALOG_PROPS_COLUMNS);
        byte[] propsBytes = null;
        RowIdImpl rowId = null;
        if (objectRow != null) {
            propsBytes = objectRow.getBytes(CAT_COL_PROPS);
            rowId = (RowIdImpl)objectRow.getId();
        }
        return this.readProperties(propsBytes, objectId, rowId);
    }

    private Integer getDbParentId() throws IOException {
        if (this._dbParentId == null) {
            this._dbParentId = this._tableFinder.findObjectId(0xF000000, SYSTEM_OBJECT_NAME_DATABASES);
            if (this._dbParentId == null) {
                throw new IOException(this.withErrorContext("Did not find required parent db id"));
            }
        }
        return this._dbParentId;
    }

    private byte[] getNewObjectOwner() throws IOException {
        if (this._newObjOwner == null) {
            Row msysDbRow = this._tableFinder.getObjectRow(this.getDbParentId(), OBJECT_NAME_DB_PROPS, Collections.singleton(CAT_COL_OWNER));
            byte[] owner = null;
            if (msysDbRow != null) {
                owner = msysDbRow.getBytes(CAT_COL_OWNER);
            }
            this._newObjOwner = owner != null && owner.length > 0 ? owner : SYS_DEFAULT_SID;
        }
        return this._newObjOwner;
    }

    private PropertyMaps getPropertiesForDbObject(String dbName) throws IOException {
        Row objectRow = this._tableFinder.getObjectRow(this.getDbParentId(), dbName, SYSTEM_CATALOG_PROPS_COLUMNS);
        byte[] propsBytes = null;
        int objectId = -1;
        RowIdImpl rowId = null;
        if (objectRow != null) {
            propsBytes = objectRow.getBytes(CAT_COL_PROPS);
            objectId = objectRow.getInt(CAT_COL_ID);
            rowId = (RowIdImpl)objectRow.getId();
        }
        return this.readProperties(propsBytes, objectId, rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabasePassword() throws IOException {
        ByteBuffer buffer = this.takeSharedBuffer();
        try {
            this._pageChannel.readPage(buffer, 0);
            byte[] pwdBytes = new byte[this._format.SIZE_PASSWORD];
            buffer.position(this._format.OFFSET_PASSWORD);
            buffer.get(pwdBytes);
            byte[] pwdMask = DatabaseImpl.getPasswordMask(buffer, this._format);
            if (pwdMask != null) {
                for (int i = 0; i < pwdBytes.length; ++i) {
                    int n = i;
                    pwdBytes[n] = (byte)(pwdBytes[n] ^ pwdMask[i % pwdMask.length]);
                }
            }
            boolean hasPassword = false;
            for (int i = 0; i < pwdBytes.length; ++i) {
                if (pwdBytes[i] == 0) continue;
                hasPassword = true;
                break;
            }
            if (!hasPassword) {
                String i = null;
                return i;
            }
            String pwd = ColumnImpl.decodeUncompressedText(pwdBytes, this.getCharset());
            int idx = pwd.indexOf(0);
            if (idx >= 0) {
                pwd = pwd.substring(0, idx);
            }
            String string = pwd;
            return string;
        }
        finally {
            this.releaseSharedBuffer(buffer);
        }
    }

    private void collectRelationships(Cursor cursor, TableImpl fromTable, TableImpl toTable, List<Relationship> relationships, boolean includeSystemTables) throws IOException {
        String fromTableName = fromTable != null ? fromTable.getName() : null;
        String toTableName = toTable != null ? toTable.getName() : null;
        for (Row row : cursor) {
            TableImpl relToTable;
            TableImpl relFromTable;
            String fromName = row.getString(REL_COL_FROM_TABLE);
            String toName = row.getString(REL_COL_TO_TABLE);
            if (fromTableName != null && !fromTableName.equalsIgnoreCase(fromName) || toTableName != null && !toTableName.equalsIgnoreCase(toName)) continue;
            String relName = row.getString(REL_COL_NAME);
            Relationship rel = null;
            for (Relationship tmp : relationships) {
                if (!tmp.getName().equalsIgnoreCase(relName)) continue;
                rel = tmp;
                break;
            }
            if ((relFromTable = fromTable) == null && (relFromTable = this.getTable(fromName, includeSystemTables)) == null || (relToTable = toTable) == null && (relToTable = this.getTable(toName, includeSystemTables)) == null) continue;
            if (rel == null) {
                int numCols = row.getInt(REL_COL_COLUMN_COUNT);
                int flags = row.getInt(REL_COL_FLAGS);
                rel = new RelationshipImpl(relName, relFromTable, relToTable, flags, numCols);
                relationships.add(rel);
            }
            int colIdx = row.getInt(REL_COL_COLUMN_INDEX);
            ColumnImpl fromCol = relFromTable.getColumn(row.getString(REL_COL_FROM_COLUMN));
            ColumnImpl toCol = relToTable.getColumn(row.getString(REL_COL_TO_COLUMN));
            rel.getFromColumns().set(colIdx, fromCol);
            rel.getToColumns().set(colIdx, toCol);
        }
    }

    private void addToSystemCatalog(String name, int objectId, Short type, String linkedDbName, String linkedTableName, Integer parentId) throws IOException {
        byte[] owner = this.getNewObjectOwner();
        Object[] catalogRow = new Object[this._systemCatalog.getColumnCount()];
        int idx = 0;
        Date creationTime = new Date();
        for (ColumnImpl col : this._systemCatalog.getColumns()) {
            if (CAT_COL_ID.equals(col.getName())) {
                catalogRow[idx] = objectId;
            } else if (CAT_COL_NAME.equals(col.getName())) {
                catalogRow[idx] = name;
            } else if (CAT_COL_TYPE.equals(col.getName())) {
                catalogRow[idx] = type;
            } else if (CAT_COL_DATE_CREATE.equals(col.getName()) || CAT_COL_DATE_UPDATE.equals(col.getName())) {
                catalogRow[idx] = creationTime;
            } else if (CAT_COL_PARENT_ID.equals(col.getName())) {
                catalogRow[idx] = parentId;
            } else if (CAT_COL_FLAGS.equals(col.getName())) {
                catalogRow[idx] = 0;
            } else if (CAT_COL_OWNER.equals(col.getName())) {
                catalogRow[idx] = owner;
            } else if (CAT_COL_DATABASE.equals(col.getName())) {
                catalogRow[idx] = linkedDbName;
            } else if (CAT_COL_FOREIGN_NAME.equals(col.getName())) {
                catalogRow[idx] = linkedTableName;
            }
            ++idx;
        }
        this._systemCatalog.addRow(catalogRow);
    }

    private void addToAccessControlEntries(Integer objectId, Integer parentId, List<byte[]> sids) throws IOException {
        if (sids.isEmpty()) {
            this.collectNewObjectSIDs(parentId, sids);
        }
        TableImpl acEntries = this.getAccessControlEntries();
        ColumnImpl acmCol = acEntries.getColumn(ACE_COL_ACM);
        ColumnImpl inheritCol = acEntries.getColumn(ACE_COL_F_INHERITABLE);
        ColumnImpl objIdCol = acEntries.getColumn(ACE_COL_OBJECT_ID);
        ColumnImpl sidCol = acEntries.getColumn(ACE_COL_SID);
        ArrayList<Object[]> aceRows = new ArrayList<Object[]>(sids.size());
        for (byte[] sid : sids) {
            Object[] aceRow = new Object[acEntries.getColumnCount()];
            acmCol.setRowValue(aceRow, (Object)SYS_FULL_ACCESS_ACM);
            inheritCol.setRowValue(aceRow, (Object)Boolean.FALSE);
            objIdCol.setRowValue(aceRow, (Object)objectId);
            sidCol.setRowValue(aceRow, (Object)sid);
            aceRows.add(aceRow);
        }
        acEntries.addRows(aceRows);
    }

    private void collectNewObjectSIDs(Integer parentId, List<byte[]> sids) throws IOException {
        Cursor cursor = this.createCursorWithOptionalIndex(this.getAccessControlEntries(), ACE_COL_OBJECT_ID, parentId);
        for (Row row : cursor) {
            Integer objId = row.getInt(ACE_COL_OBJECT_ID);
            if (!parentId.equals(objId)) continue;
            sids.add(row.getBytes(ACE_COL_SID));
        }
        if (sids.isEmpty()) {
            sids.add(SYS_DEFAULT_SID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableImpl readTable(String name, int pageNumber, int flags) throws IOException {
        TableImpl table = this._tableCache.get(pageNumber);
        if (table != null) {
            return table;
        }
        ByteBuffer buffer = this.takeSharedBuffer();
        try {
            this._pageChannel.readPage(buffer, pageNumber);
            byte pageType = buffer.get(0);
            if (pageType != 2) {
                throw new IOException(this.withErrorContext("Looking for " + name + " at page " + pageNumber + ", but page type is " + pageType));
            }
            TableImpl tableImpl = this._tableCache.put(new TableImpl(this, buffer, pageNumber, name, flags));
            return tableImpl;
        }
        finally {
            this.releaseSharedBuffer(buffer);
        }
    }

    private Cursor createCursorWithOptionalIndex(TableImpl table, String colName, Object colValue) throws IOException {
        try {
            return table.newCursor().setIndexByColumnNames(colName).setSpecificEntry(colValue).toCursor();
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.withErrorContext("Could not find expected index on table " + table.getName()));
            }
            return CursorImpl.createCursor(table);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._linkedDbs != null) {
            for (Database linkedDb : this._linkedDbs.values()) {
                linkedDb.flush();
            }
        }
        this._pageChannel.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._linkedDbs != null) {
            for (Database linkedDb : this._linkedDbs.values()) {
                linkedDb.close();
            }
        }
        this._pageChannel.close();
    }

    public void validateNewTableName(String name) throws IOException {
        DatabaseImpl.validateIdentifierName(name, this.getFormat().MAX_TABLE_NAME_LENGTH, "table");
        if (this.lookupTable(name) != null) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot create table with name of existing table '" + name + "'"));
        }
    }

    public static void validateIdentifierName(String name, int maxLength, String identifierType) {
        DatabaseImpl.validateName(name, maxLength, identifierType);
        if (INVALID_IDENTIFIER_CHARS.matcher(name).find()) {
            throw new IllegalArgumentException(identifierType + " name '" + name + "' contains invalid characters");
        }
        if (name.charAt(0) == ' ') {
            throw new IllegalArgumentException(identifierType + " name '" + name + "' cannot start with a space character");
        }
    }

    private static void validateName(String name, int maxLength, String nameType) {
        if (DatabaseImpl.isBlank(name)) {
            throw new IllegalArgumentException(nameType + " must have non-blank name");
        }
        if (name.length() > maxLength) {
            throw new IllegalArgumentException(nameType + " name is longer than max length of " + maxLength + ": " + name);
        }
    }

    public static boolean isBlank(String name) {
        return name == null || name.trim().length() == 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    private void addTable(String tableName, Integer pageNumber, Short type, String linkedDbName, String linkedTableName) {
        this._tableLookup.put(DatabaseImpl.toLookupName(tableName), DatabaseImpl.createTableInfo(tableName, pageNumber, 0, type, linkedDbName, linkedTableName));
        this._tableNames = null;
    }

    private static TableInfo createTableInfo(String tableName, Integer pageNumber, int flags, Short type, String linkedDbName, String linkedTableName) {
        if (TYPE_LINKED_TABLE.equals(type)) {
            return new LinkedTableInfo(pageNumber, tableName, flags, linkedDbName, linkedTableName);
        }
        return new TableInfo(pageNumber, tableName, flags);
    }

    private TableInfo lookupTable(String tableName) throws IOException {
        String lookupTableName = DatabaseImpl.toLookupName(tableName);
        TableInfo tableInfo = this._tableLookup.get(lookupTableName);
        if (tableInfo != null) {
            return tableInfo;
        }
        tableInfo = this._tableFinder.lookupTable(tableName);
        if (tableInfo != null) {
            this._tableLookup.put(lookupTableName, tableInfo);
        }
        return tableInfo;
    }

    public static String toLookupName(String name) {
        return name != null ? name.toUpperCase() : null;
    }

    private static boolean isSystemObject(int flags) {
        return (flags & 0x80000002) != 0;
    }

    public static TimeZone getDefaultTimeZone() {
        String tzProp = System.getProperty("com.healthmarketscience.jackcess.timeZone");
        if (tzProp != null && (tzProp = tzProp.trim()).length() > 0) {
            return TimeZone.getTimeZone(tzProp);
        }
        return TimeZone.getDefault();
    }

    public static Charset getDefaultCharset(JetFormat format) {
        String csProp = System.getProperty("com.healthmarketscience.jackcess.charset." + format);
        if (csProp != null && (csProp = csProp.trim()).length() > 0) {
            return Charset.forName(csProp);
        }
        return format.CHARSET;
    }

    public static Table.ColumnOrder getDefaultColumnOrder() {
        String coProp = System.getProperty("com.healthmarketscience.jackcess.columnOrder");
        if (coProp != null && (coProp = coProp.trim()).length() > 0) {
            return Table.ColumnOrder.valueOf(coProp);
        }
        return DEFAULT_COLUMN_ORDER;
    }

    public static boolean getDefaultEnforceForeignKeys() {
        String prop = System.getProperty("com.healthmarketscience.jackcess.enforceForeignKeys");
        if (prop != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(prop);
        }
        return true;
    }

    public static boolean getDefaultAllowAutoNumberInsert() {
        String prop = System.getProperty("com.healthmarketscience.jackcess.allowAutoNumberInsert");
        if (prop != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(prop);
        }
        return false;
    }

    protected static void transferDbFrom(FileChannel channel, InputStream in) throws IOException {
        ReadableByteChannel readChannel = Channels.newChannel(in);
        if (!BROKEN_NIO) {
            channel.transferFrom(readChannel, 0L, 370000L);
        } else {
            ByteBuffer bb = ByteBuffer.allocate(8096);
            while (readChannel.read(bb) >= 0) {
                bb.flip();
                channel.write(bb);
                bb.clear();
            }
        }
    }

    static byte[] getPasswordMask(ByteBuffer buffer, JetFormat format) {
        int pwdMaskPos = format.OFFSET_HEADER_DATE;
        if (pwdMaskPos < 0) {
            return null;
        }
        buffer.position(pwdMaskPos);
        double dateVal = Double.longBitsToDouble(buffer.getLong());
        byte[] pwdMask = new byte[4];
        PageChannel.wrap(pwdMask).putInt((int)dateVal);
        return pwdMask;
    }

    protected static InputStream getResourceAsStream(String resourceName) throws IOException {
        InputStream stream = DatabaseImpl.class.getClassLoader().getResourceAsStream(resourceName);
        if (stream == null && (stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)) == null) {
            throw new IOException("Could not load jackcess resource " + resourceName);
        }
        return stream;
    }

    private static boolean isTableType(Short objType) {
        return TYPE_TABLE.equals(objType) || TYPE_LINKED_TABLE.equals(objType);
    }

    public static FileFormatDetails getFileFormatDetails(Database.FileFormat fileFormat) {
        return FILE_FORMAT_DETAILS.get((Object)fileFormat);
    }

    private static void addFileFormatDetails(Database.FileFormat fileFormat, String emptyFileName, JetFormat format) {
        String emptyFile = emptyFileName != null ? RESOURCE_PATH + emptyFileName + fileFormat.getFileExtension() : null;
        FILE_FORMAT_DETAILS.put(fileFormat, new FileFormatDetails(emptyFile, format));
    }

    private static String getName(File file) {
        if (file == null) {
            return "<UNKNOWN.DB>";
        }
        return file.getName();
    }

    private String withErrorContext(String msg) {
        return DatabaseImpl.withErrorContext(msg, this.getName());
    }

    private static String withErrorContext(String msg, String dbName) {
        return msg + " (Db=" + dbName + ")";
    }

    static {
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V1997, null, JetFormat.VERSION_3);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.GENERIC_JET4, null, JetFormat.VERSION_4);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V2000, "empty", JetFormat.VERSION_4);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V2003, "empty2003", JetFormat.VERSION_4);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V2007, "empty2007", JetFormat.VERSION_12);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V2010, "empty2010", JetFormat.VERSION_14);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.V2016, "empty2016", JetFormat.VERSION_16);
        DatabaseImpl.addFileFormatDetails(Database.FileFormat.MSISAM, null, JetFormat.VERSION_MSISAM);
        SYS_FULL_ACCESS_ACM = 1048575;
        TYPE_TABLE = 1;
        TYPE_QUERY = 5;
        TYPE_LINKED_TABLE = 6;
        TYPE_RELATIONSHIP = 8;
        SYSTEM_CATALOG_COLUMNS = new HashSet<String>(Arrays.asList(CAT_COL_NAME, CAT_COL_TYPE, CAT_COL_ID, CAT_COL_FLAGS, CAT_COL_PARENT_ID));
        SYSTEM_CATALOG_TABLE_DETAIL_COLUMNS = new HashSet<String>(Arrays.asList(CAT_COL_NAME, CAT_COL_TYPE, CAT_COL_ID, CAT_COL_FLAGS, CAT_COL_PARENT_ID, CAT_COL_DATABASE, CAT_COL_FOREIGN_NAME));
        SYSTEM_CATALOG_PROPS_COLUMNS = new HashSet<String>(Arrays.asList(CAT_COL_ID, CAT_COL_PROPS));
        INVALID_IDENTIFIER_CHARS = Pattern.compile("[\\p{Cntrl}.!`\\]\\[]");
    }

    public static final class FileFormatDetails {
        private final String _emptyFile;
        private final JetFormat _format;

        private FileFormatDetails(String emptyFile, JetFormat format) {
            this._emptyFile = emptyFile;
            this._format = format;
        }

        public String getEmptyFilePath() {
            return this._emptyFile;
        }

        public JetFormat getFormat() {
            return this._format;
        }
    }

    private static final class TableCache {
        private final Map<Integer, WeakTableReference> _tables = new HashMap<Integer, WeakTableReference>();
        private final ReferenceQueue<TableImpl> _queue = new ReferenceQueue();

        private TableCache() {
        }

        public TableImpl get(Integer pageNumber) {
            WeakTableReference ref = this._tables.get(pageNumber);
            return ref != null ? (TableImpl)ref.get() : null;
        }

        public TableImpl put(TableImpl table) {
            this.purgeOldRefs();
            Integer pageNumber = table.getTableDefPageNumber();
            WeakTableReference ref = new WeakTableReference(pageNumber, table, this._queue);
            this._tables.put(pageNumber, ref);
            return table;
        }

        private void purgeOldRefs() {
            WeakTableReference oldRef = null;
            while ((oldRef = (WeakTableReference)this._queue.poll()) != null) {
                this._tables.remove(oldRef.getPageNumber());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakTableReference
    extends WeakReference<TableImpl> {
        private final Integer _pageNumber;

        private WeakTableReference(Integer pageNumber, TableImpl table, ReferenceQueue<TableImpl> queue) {
            super(table, queue);
            this._pageNumber = pageNumber;
        }

        public Integer getPageNumber() {
            return this._pageNumber;
        }
    }

    private final class FallbackTableFinder
    extends TableFinder {
        private final Cursor _systemCatalogCursor;

        private FallbackTableFinder(Cursor systemCatalogCursor) {
            this._systemCatalogCursor = systemCatalogCursor;
        }

        protected Cursor findRow(Integer parentId, String name) throws IOException {
            HashMap<String, Object> rowPat = new HashMap<String, Object>();
            rowPat.put(DatabaseImpl.CAT_COL_PARENT_ID, parentId);
            rowPat.put(DatabaseImpl.CAT_COL_NAME, name);
            return this._systemCatalogCursor.findFirstRow(rowPat) ? this._systemCatalogCursor : null;
        }

        protected Cursor findRow(Integer objectId) throws IOException {
            ColumnImpl idCol = DatabaseImpl.this._systemCatalog.getColumn(DatabaseImpl.CAT_COL_ID);
            return this._systemCatalogCursor.findFirstRow(idCol, objectId) ? this._systemCatalogCursor : null;
        }

        public TableInfo lookupTable(String tableName) throws IOException {
            for (Row row : this._systemCatalogCursor.newIterable().setColumnNames(SYSTEM_CATALOG_TABLE_DETAIL_COLUMNS)) {
                String realName;
                int parentId;
                Short type = row.getShort(DatabaseImpl.CAT_COL_TYPE);
                if (!DatabaseImpl.isTableType(type) || (parentId = row.getInt(DatabaseImpl.CAT_COL_PARENT_ID).intValue()) != DatabaseImpl.this._tableParentId || !tableName.equalsIgnoreCase(realName = row.getString(DatabaseImpl.CAT_COL_NAME))) continue;
                Integer pageNumber = row.getInt(DatabaseImpl.CAT_COL_ID);
                int flags = row.getInt(DatabaseImpl.CAT_COL_FLAGS);
                String linkedDbName = row.getString(DatabaseImpl.CAT_COL_DATABASE);
                String linkedTableName = row.getString(DatabaseImpl.CAT_COL_FOREIGN_NAME);
                return DatabaseImpl.createTableInfo(realName, pageNumber, flags, type, linkedDbName, linkedTableName);
            }
            return null;
        }

        protected Cursor getTableNamesCursor() throws IOException {
            return this._systemCatalogCursor;
        }

        protected int findMaxSyntheticId() throws IOException {
            ColumnImpl idCol = DatabaseImpl.this._systemCatalog.getColumn(DatabaseImpl.CAT_COL_ID);
            this._systemCatalogCursor.reset();
            int curMaxSynthId = Integer.MIN_VALUE;
            while (this._systemCatalogCursor.moveToNextRow()) {
                int id = (Integer)this._systemCatalogCursor.getCurrentRowValue(idCol);
                if (id <= curMaxSynthId || id >= 0) continue;
                curMaxSynthId = id;
            }
            return curMaxSynthId;
        }
    }

    private final class DefaultTableFinder
    extends TableFinder {
        private final IndexCursor _systemCatalogCursor;
        private IndexCursor _systemCatalogIdCursor;

        private DefaultTableFinder(IndexCursor systemCatalogCursor) {
            this._systemCatalogCursor = systemCatalogCursor;
        }

        private void initIdCursor() throws IOException {
            if (this._systemCatalogIdCursor == null) {
                this._systemCatalogIdCursor = DatabaseImpl.this._systemCatalog.newCursor().setIndexByColumnNames(DatabaseImpl.CAT_COL_ID).toIndexCursor();
            }
        }

        protected Cursor findRow(Integer parentId, String name) throws IOException {
            return this._systemCatalogCursor.findFirstRowByEntry(parentId, name) ? this._systemCatalogCursor : null;
        }

        protected Cursor findRow(Integer objectId) throws IOException {
            this.initIdCursor();
            return this._systemCatalogIdCursor.findFirstRowByEntry(objectId) ? this._systemCatalogIdCursor : null;
        }

        public TableInfo lookupTable(String tableName) throws IOException {
            if (this.findRow(DatabaseImpl.this._tableParentId, tableName) == null) {
                return null;
            }
            Row row = this._systemCatalogCursor.getCurrentRow(SYSTEM_CATALOG_TABLE_DETAIL_COLUMNS);
            Integer pageNumber = row.getInt(DatabaseImpl.CAT_COL_ID);
            String realName = row.getString(DatabaseImpl.CAT_COL_NAME);
            int flags = row.getInt(DatabaseImpl.CAT_COL_FLAGS);
            Short type = row.getShort(DatabaseImpl.CAT_COL_TYPE);
            if (!DatabaseImpl.isTableType(type)) {
                return null;
            }
            String linkedDbName = row.getString(DatabaseImpl.CAT_COL_DATABASE);
            String linkedTableName = row.getString(DatabaseImpl.CAT_COL_FOREIGN_NAME);
            return DatabaseImpl.createTableInfo(realName, pageNumber, flags, type, linkedDbName, linkedTableName);
        }

        protected Cursor getTableNamesCursor() throws IOException {
            return this._systemCatalogCursor.getIndex().newCursor().setStartEntry(DatabaseImpl.this._tableParentId, IndexData.MIN_VALUE).setEndEntry(DatabaseImpl.this._tableParentId, IndexData.MAX_VALUE).toIndexCursor();
        }

        protected int findMaxSyntheticId() throws IOException {
            this.initIdCursor();
            this._systemCatalogIdCursor.reset();
            this._systemCatalogIdCursor.findClosestRowByEntry(0);
            if (!this._systemCatalogIdCursor.moveToPreviousRow()) {
                return Integer.MIN_VALUE;
            }
            ColumnImpl idCol = DatabaseImpl.this._systemCatalog.getColumn(DatabaseImpl.CAT_COL_ID);
            return (Integer)this._systemCatalogIdCursor.getCurrentRowValue(idCol);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TableFinder {
        private TableFinder() {
        }

        public Integer findObjectId(Integer parentId, String name) throws IOException {
            Cursor cur = this.findRow(parentId, name);
            if (cur == null) {
                return null;
            }
            ColumnImpl idCol = DatabaseImpl.this._systemCatalog.getColumn(DatabaseImpl.CAT_COL_ID);
            return (Integer)cur.getCurrentRowValue(idCol);
        }

        public Row getObjectRow(Integer parentId, String name, Collection<String> columns) throws IOException {
            Cursor cur = this.findRow(parentId, name);
            return cur != null ? cur.getCurrentRow(columns) : null;
        }

        public Row getObjectRow(Integer objectId, Collection<String> columns) throws IOException {
            Cursor cur = this.findRow(objectId);
            return cur != null ? cur.getCurrentRow(columns) : null;
        }

        public void getTableNames(Set<String> tableNames, boolean normalTables, boolean systemTables, boolean linkedTables) throws IOException {
            for (Row row : this.getTableNamesCursor().newIterable().setColumnNames(SYSTEM_CATALOG_COLUMNS)) {
                String tableName = row.getString(DatabaseImpl.CAT_COL_NAME);
                int flags = row.getInt(DatabaseImpl.CAT_COL_FLAGS);
                Short type = row.getShort(DatabaseImpl.CAT_COL_TYPE);
                int parentId = row.getInt(DatabaseImpl.CAT_COL_PARENT_ID);
                if (parentId != DatabaseImpl.this._tableParentId) continue;
                if (TYPE_TABLE.equals(type)) {
                    if (!DatabaseImpl.isSystemObject(flags)) {
                        if (!normalTables) continue;
                        tableNames.add(tableName);
                        continue;
                    }
                    if (!systemTables) continue;
                    tableNames.add(tableName);
                    continue;
                }
                if (!TYPE_LINKED_TABLE.equals(type) || !linkedTables) continue;
                tableNames.add(tableName);
            }
        }

        public boolean isLinkedTable(Table table) throws IOException {
            for (Row row : this.getTableNamesCursor().newIterable().setColumnNames(SYSTEM_CATALOG_TABLE_DETAIL_COLUMNS)) {
                Short type = row.getShort(DatabaseImpl.CAT_COL_TYPE);
                String linkedDbName = row.getString(DatabaseImpl.CAT_COL_DATABASE);
                String linkedTableName = row.getString(DatabaseImpl.CAT_COL_FOREIGN_NAME);
                if (!TYPE_LINKED_TABLE.equals(type) || !DatabaseImpl.this.matchesLinkedTable(table, linkedTableName, linkedDbName)) continue;
                return true;
            }
            return false;
        }

        protected abstract Cursor findRow(Integer var1, String var2) throws IOException;

        protected abstract Cursor findRow(Integer var1) throws IOException;

        protected abstract Cursor getTableNamesCursor() throws IOException;

        public abstract TableInfo lookupTable(String var1) throws IOException;

        protected abstract int findMaxSyntheticId() throws IOException;

        public int getNextFreeSyntheticId() throws IOException {
            int maxSynthId = this.findMaxSyntheticId();
            if (maxSynthId >= -1) {
                throw new IllegalStateException(DatabaseImpl.this.withErrorContext("Too many database objects!"));
            }
            return maxSynthId + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableIterator
    implements Iterator<Table> {
        private Iterator<String> _tableNameIter;

        private TableIterator(Set<String> tableNames) {
            this._tableNameIter = tableNames.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._tableNameIter.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Table next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return DatabaseImpl.this.getTable(this._tableNameIter.next(), true);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    private static class LinkedTableInfo
    extends TableInfo {
        private final String linkedDbName;
        private final String linkedTableName;

        private LinkedTableInfo(Integer newPageNumber, String newTableName, int newFlags, String newLinkedDbName, String newLinkedTableName) {
            super(newPageNumber, newTableName, newFlags);
            this.linkedDbName = newLinkedDbName;
            this.linkedTableName = newLinkedTableName;
        }

        public boolean isLinked() {
            return true;
        }

        public String getLinkedTableName() {
            return this.linkedTableName;
        }

        public String getLinkedDbName() {
            return this.linkedDbName;
        }
    }

    private static class TableInfo
    implements TableMetaData {
        public final Integer pageNumber;
        public final String tableName;
        public final int flags;

        private TableInfo(Integer newPageNumber, String newTableName, int newFlags) {
            this.pageNumber = newPageNumber;
            this.tableName = newTableName;
            this.flags = newFlags;
        }

        public String getName() {
            return this.tableName;
        }

        public boolean isLinked() {
            return false;
        }

        public boolean isSystem() {
            return DatabaseImpl.isSystemObject(this.flags);
        }

        public String getLinkedTableName() {
            return null;
        }

        public String getLinkedDbName() {
            return null;
        }

        public Table open(Database db) throws IOException {
            return ((DatabaseImpl)db).getTable(this, true);
        }

        public String toString() {
            ToStringBuilder sb = CustomToStringStyle.valueBuilder("TableMetaData").append("name", this.getName());
            if (this.isSystem()) {
                sb.append("isSystem", this.isSystem());
            }
            if (this.isLinked()) {
                sb.append("isLinked", this.isLinked()).append("linkedTableName", this.getLinkedTableName()).append("linkedDbName", this.getLinkedDbName());
            }
            return sb.toString();
        }
    }
}

