

%s NAME TYPE VALUE LINE
%s DQUOTE SQUOTE


WORD    [^, \t\n]*
VALU    [^,\"\'\n]*
DVAL	[^\\\"]*
SVAL	[^\\\']*

%top {
#ifdef __linux__
/* string.h: strdup */
#undef _XOPEN_SOURCE
#define _XOPEN_SOURCE 600
/* stdio.h: fileno */
#define _POSIX_C_SOURCE 2
#endif
}


%{
/*                                                                
**  Copyright (C) 2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* iparlex.l
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "ipar_yac.h"
#include "iraf.h"

extern char* str_duplicate(const char* in);

#define YY_SKIP_YYWRAP
#define YY_NO_INPUT
#define YY_NO_UNPUT

static char ipar_string[SZ_PFLINE];

extern int ipar_lineno;

#define StrCpy(res, str, len)	( strncpy((res=malloc(len + 1)), str, len+1),\
					res[len] = '\0')

#define StrpCpy(res, str, len)	( StrCpy(res,str,len), res)

/* This array and the field variable to cycle through the  context dependence
** of the current field that is expected.
**/
int	ipar_fields[7];
int	ipar_field = 0;
char	*ipar_inchar = NULL;


#define YY_USER_INIT	\
ipar_fields[0] = NAME;	\
ipar_fields[1] = TYPE;	\
ipar_fields[2] = NAME;	\
ipar_fields[3] = VALUE;	\
ipar_fields[4] = VALUE;	\
ipar_fields[5] = VALUE;	\
ipar_fields[6] = VALUE;	\
{ BEGIN(ipar_fields[ipar_field = 0]);		}
/**
#define YY_USER_ACTION  { printf("field = %d, state = %d\n", ipar_field, ipar_start); }
**/

#define P(x)	printf(x)

#define GetC(ipar_inchar)		(*(ipar_inchar++))
#undef  YY_INPUT
#define YY_INPUT(buffer, result, max)		\
	{					\
		 char ch;			\
		 ch = GetC(ipar_inchar);		\
		 if ( ch == '\\' ) {		\
		    ch = GetC(ipar_inchar);		\
		    if ( ch == '\n' ) ch = ' ';	\
		 }				\
		 if ( ch == '\0' )		\
		    result = 0;			\
		 else {				\
		    *buffer = ch;		\
		     result = 1;		\
		 }				\
	}

/* default iargwrap function - always treat EOF as an EOF */
static int ipar_wrap( void ) {
	return 1;
}



%}


%%
<TYPE>struct    {  StrCpy(ipar_lval.stri, ipar_text, ipar_leng);    return T_struct; }
<TYPE,NAME>{WORD} {	StrCpy(ipar_lval.stri, ipar_text, ipar_leng);	return T_word;}
<LINE>.*	{	StrCpy(ipar_lval.stri, ipar_text, ipar_leng);	return T_line;}
<VALUE>{VALU}	{	StrCpy(ipar_lval.stri, ipar_text, ipar_leng);	return T_word;}
<VALUE>[ \t]*\"	{	ipar_string[0] = '\0';  BEGIN(DQUOTE);  		}
<VALUE>[ \t]*\'	{	ipar_string[0] = '\0';  BEGIN(SQUOTE);		}
<DQUOTE>{DVAL}  { 	strncat(ipar_string, ipar_text, ipar_leng);              }
<SQUOTE>{SVAL}	{ 	strncat(ipar_string, ipar_text, ipar_leng);              }
<DQUOTE>\\.     {	strncat(ipar_string, ipar_text, ipar_leng);              }
<SQUOTE>\\.     {	strncat(ipar_string, ipar_text, ipar_leng);              }
<DQUOTE>\"      {	BEGIN(VALUE);
                        StrCpy(ipar_lval.stri, ipar_string, strlen(ipar_string) + 1); return T_word; }
<SQUOTE>\'      {	BEGIN(VALUE);
                        StrCpy(ipar_lval.stri, ipar_string, strlen(ipar_string) + 1); return T_word; }
^#.*$		{
			char	*value;
			int	mode = 0;

		  ipar_lval.param = ParamCreate(str_duplicate("#")
				, CommentType
				, &mode, StrpCpy(value, ipar_text, ipar_leng)
				, NULL);

		  return T_comment;
		}
^[ \t]+$       	{
			char	*value;
			int	mode = 0;
		  ipar_lval.param = ParamCreate(str_duplicate("")
				, CommentType
				, &mode, StrpCpy(value, ipar_text, ipar_leng)
				, NULL);

		  return T_comment;
		}
[ \t]+		{	;	}
,		{ 	BEGIN(ipar_fields[++ipar_field]);		return ','; }
[ \t]*\n	{
			ipar_lineno++;
			BEGIN(ipar_fields[ipar_field = 0]);		return T_nl;
		}


%%


/* Lexical tie called by grammar
**/
void ipar_begin(int state)
{
	BEGIN(state);

}

int ipar_reparse( void )
{
	BEGIN(ipar_fields[ipar_field = 0]);
        return 0;
}
