;;;
;;;
;;; zenirc-swedish-mode.el --- Swedish language interface for Zen Internet 
;;; Relay Chat client (bork bork bork)

;;; Copyright (C) 1993, 1994 Ben A. Mesander

;;; Author: Per Persson <pp@solace.mh.se>
;;;         Ben A. Mesander <ben@gnu.ai.mit.edu>
;;;         Noah Friedman <friedman@prep.ai.mit.edu>

;;; Maintainer: ben@gnu.ai.mit.edu
;;; Keywords: extensions
;;; Created: 1993/06/03

;;; $Id: zenirc-swedish-mode.el,v 1.7 1994/06/21 19:31:56 ben Exp $

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;;; "it's like operating a nazi sub or something."
;;;    --Ben A. Mesander <ben@gnu.ai.mit.edu>
;;;

;;; Code:

; your channel join message
(zenirc-set-text-list-ent 'join_you "[info] Du deltar nu i mtet: %s\n") 
; channel join message
(zenirc-set-text-list-ent 'join "[info] %s deltar nu i mtet %s\n") 
; welcome to irc message
(zenirc-set-text-list-ent 's001 "[info] Du kastar bort tid.\n") 
; server name & version # msg
(zenirc-set-text-list-ent 's002 
	      "[info] Din IRK server r %s och kr IRKD version %s\n")
; when the server was built
(zenirc-set-text-list-ent 's003 "[info] Den hr IRK servern skapades %s\n") 
; # users on connect message
(zenirc-set-text-list-ent 
 's251 
 "[info] Det finns %s synliga och %s osynliga klienter p %s serverar.\n")
; Version reply from /trace
(zenirc-set-text-list-ent 's200
			  "[info] %s Lnk -> version: %s\n")
; Trace handshake
(zenirc-set-text-list-ent 's202
			  "[info] %s H.S. -> %s\n")
; Unknown connection
(zenirc-set-text-list-ent 's203
			  "[info] %s Hmmm -> IP address: %s\n")
; Operator connection
(zenirc-set-text-list-ent 's204
			  "[info] %s Oper -> %s\n")
; User connection
(zenirc-set-text-list-ent 's205
			  "[info] %s Klie -> %s\n")
; Server connection
(zenirc-set-text-list-ent 's206
			  "[info] %s Serv -> %s %s %s %s \n")
; New type connection
(zenirc-set-text-list-ent 's208
			  "[info] %s %s -> %s\n")
; What the classes means
(zenirc-set-text-list-ent 's209
			  "Klas -> %s = %s\n")
; Linkinfo
(zenirc-set-text-list-ent 's211
			  "[info] %s lnk har varit uppe %s sekunder\nSnt %s/%s, Mottagit %s/%s, SndK: %s\n")
; Command stats
(zenirc-set-text-list-ent 's212
			  "[info] %s\t->\tgnger: %s\tbytes: %s\n")
; C-lines
(zenirc-set-text-list-ent 's213
			  "[info] C msk/nam/prt/kls: %s/%s/%s/%s\n")
; N-lines
(zenirc-set-text-list-ent 's214
			  "[info] N msk/nam/prt/kls: %s/%s/%s/%s\n")
; I-lines
(zenirc-set-text-list-ent 's215
			  "[info] I maskin/namn:\t%s/%s\n")
; K-lines
(zenirc-set-text-list-ent 's216
			  "[info] K maskin/anvndarnamn:\t%s/%s\n")
; Q-lines
(zenirc-set-text-list-ent 's217
			  "[info] Q %s/%s/%s/%s/%s\n")
; Y-lines
(zenirc-set-text-list-ent 's218
			  "[info] Klass: %s Ping frek: %s Lnk frek: %s Max lnkar: %s SndK: %s\n")
; End of /stats I guess
(zenirc-set-text-list-ent 's219
			  "[info] Slut p /stats.\n")
; user mode
(zenirc-set-text-list-ent 's221
			  "[info] Din nuvarande status r: %s\n")
; L-lines
(zenirc-set-text-list-ent 's241
			  "[info] LV  maskinmask/djup:\t\t%s/%s\n")
; Uptime of server
(zenirc-set-text-list-ent 's242
			  "[info] %s\n")
; O-lines
(zenirc-set-text-list-ent 's243
			  "[info] O smeknamn/anvndare@maskin:\t%s/%s\n")
; H-lines
(zenirc-set-text-list-ent 's244
			  "[info] GREN maskinmask/servernamn:\t%s/%s\n")
; # users on connect message
(zenirc-set-text-list-ent 's251
			  "[info] Det finns %s synliga och %s osynliga klienter p %s serverar.\n")
; irc operators msg
(zenirc-set-text-list-ent 's252 
			  "[info] Det finns %s verkliga nollor aktiva.\n") 
; unk connects msg
(zenirc-set-text-list-ent 's253 
			  "[info] Det finns %s oknda uppkopplingar.\n") 
; number of channels
(zenirc-set-text-list-ent 's254 "[info] Det finns %s mten.\n") 
; # of clients and servers
(zenirc-set-text-list-ent 
 's255 			
 "[info] Det finns %s klienter och %s servrar uppkopplade till den hr servern.\n")
; line 1 of admin information
(zenirc-set-text-list-ent 's256
			  "[info] Administrativ information fr %s:\n")
; line 2 of admin information
(zenirc-set-text-list-ent 's257
			  "[info] %s\n")
; line 3 of admin information
(zenirc-set-text-list-ent 's258
			  "[info] %s\n")
; line 4 of admin information
(zenirc-set-text-list-ent 's259
			  "[info] %s\n")
; Logfile trace
(zenirc-set-text-list-ent 's261
			  "[info] %s Fil -> %s %s\n")
; someone is away
(zenirc-set-text-list-ent 's301 "[info] %s r borta: %s\n") 
; userhost reply
(zenirc-set-text-list-ent 's302 "[info] anvndaraddress: %s\n") 
(zenirc-set-text-list-ent 's303 "[info] ` %s' slsar fr nrvarande tid.\n") 
(zenirc-set-text-list-ent 's305 "[info] Du r nu tillbaka.\n")
(zenirc-set-text-list-ent 's306 "[info] Du r borta.\n")
; user part of /whois list
(zenirc-set-text-list-ent 's311 "[info] %s (%s@%s) r %s\n") 
; server part of /whois list
(zenirc-set-text-list-ent 's312 "[info] %s anvnder servern %s (%s)\n") 
; /whois operator status
(zenirc-set-text-list-ent 's313 "[info] %s r en verklig nolla.\n") 
; user part of /whowas list
(zenirc-set-text-list-ent 's314 "[info] %s (%s@%s) var %s\n") 
; end of /who list replies
(zenirc-set-text-list-ent 's315 "[info] Slut p /who\n") 
; end of /whois list replies
(zenirc-set-text-list-ent 's318 "[info] Slut p /whois\n") 
; /whois idle time
(zenirc-set-text-list-ent 's317 
			  "[info] %s har varit inaktiv i %d sekunder.\n") 
; channel part of whois data
(zenirc-set-text-list-ent 's319 "[info] %s r p: %s\n") 
; header for LIST cmd
(zenirc-set-text-list-ent 's321 "[info] Mte\tAnvndare\tRubrik\n") 
; each channel in LIST cmd
(zenirc-set-text-list-ent 's322 "[info] %s\t%s\t%s\n")	
; trailer for LIST cmd 
(zenirc-set-text-list-ent 's323 "[info] Slut p /list\n") 
; channel mode
(zenirc-set-text-list-ent 's324 "[info] Status fr %s r %s %s\n") 
; no topic message
(zenirc-set-text-list-ent 's331 "[info] %s har ingen rubrik.\n") 
(zenirc-set-text-list-ent 's332 "[info] %s rubrik: %s\n") ; topic message
; invite reply
(zenirc-set-text-list-ent 's341 "[info] Du inbjuder %s till %s\n") 
; summon reply
(zenirc-set-text-list-ent 's342 "[info] Du ber %s att kasta bort tid.\n") 
(zenirc-set-text-list-ent 's351 "[info] Version: %s %s %s\n") ; version reply
; header for /who list reply
(zenirc-set-text-list-ent
 's352_header 
 "[info] Smeknamn  Stat Namn av Mte  Anvndare@adress        Namn\n") 
; /who list reply
(zenirc-set-text-list-ent 's352 "[info] %-9s %-3s  %-15s %s@%s (%s)\n") 
; displayed after channel join
(zenirc-set-text-list-ent 's353 "[info] Klienter p %s: %s\n") 
(zenirc-set-text-list-ent 's364 "[info] %s %s %s\n")    ; /links reply
; end of /links reply
(zenirc-set-text-list-ent 's365 "[info] slut p /links\n") 
; banlist reply
(zenirc-set-text-list-ent 's367 "[info] %s portningar %s\n")     
; end of banlist reply
(zenirc-set-text-list-ent 's368 "[info] slut p portningslistan.\n") 
(zenirc-set-text-list-ent 's371 "[info] %s\n")          ; info reply
(zenirc-set-text-list-ent 's372 "[motd] %s\n")		; message of the day
(zenirc-set-text-list-ent 's375 "[motd] Dagens meddelande:\n")	; start of motd
; displayed at end of motd
(zenirc-set-text-list-ent 's376 "[motd] Slut p dm.\n") 
; irc op status
(zenirc-set-text-list-ent 's381 "[info] Du r nu en verklig nolla.\n") 
; rehash server msg
(zenirc-set-text-list-ent 's382 "[info] ter brdgrdar: %s\n") 
(zenirc-set-text-list-ent 
 's391 "[info] Lokal tid p servern %s r: %s\n")   ; TIME reply
; header for users rpl
(zenirc-set-text-list-ent 's392 
			  "[info] Anvndar# Terminal  Address\n")  
(zenirc-set-text-list-ent 's393 "[info] %s\n") ; body of users rpl
; nobody for users rpl
(zenirc-set-text-list-ent 's395 "[info] Ingen r ploggad.\n")  
; there is no such nick/chan
(zenirc-set-text-list-ent 
 's401 "[info] Det finns inget sdant smeknamn/mte: %s\n") 
; there is no such server
(zenirc-set-text-list-ent 's402 "[info] Ingen server med det namnet: %s\n") 
; there is no such channel
(zenirc-set-text-list-ent 's403 "[info] Inget mte med det namnet: %s\n")
; you can't send to channel
(zenirc-set-text-list-ent 's404 "[info] Du kan inte snda till %s\n") 
; too many channels
(zenirc-set-text-list-ent 's405 "[info] Du deltar redan i tio mten: %s\n") 
(zenirc-set-text-list-ent ; no whowas data
 's406 
 "[info] Ngot sdant smeknamn finns inte i serverns databas: %s\n") 
(zenirc-set-text-list-ent 
 's407 "[info] Dubbla mottagare. Inget meddelande snt: %s\n") ; user@host
; ping error reply
(zenirc-set-text-list-ent 's409 "[info] Ingen sndare given.\n")
; no recipient given
(zenirc-set-text-list-ent 's411 "[info] Ingen mottagare given.\n")
; you didn't send anything.
(zenirc-set-text-list-ent 's412 "[info] Ingen text att snda.\n") 
; no toplevel domain spec
(zenirc-set-text-list-ent 's413 "[info] Ingen toppniv domain: %s\n")
(zenirc-set-text-list-ent 's414 ; wild toplevel
			  "[info] Jokertecken i toppniv domain: %s\n") 
(zenirc-set-text-list-ent ; you sent server spam
 's421 "[info] Det hr ser ut som nonsens fr mig: %s\n") 
(zenirc-set-text-list-ent 
 's422 			; deprecate operators
 "[info] Ngon verklig nolla har inte tillrckligt hg IQ fr att ha en dm fil.\n")
(zenirc-set-text-list-ent 
 's423 			; deprecate operators
 "[info] Ngon verklig nolla p %s r ignorant nog att inte lgga upp administrations info.\n")
; you didn't provide a nick
(zenirc-set-text-list-ent 's431 "[info] Inget smeknamn givet.\n") 
; invalid nick
(zenirc-set-text-list-ent 's432 "[info] Ogiltigt smeknamn: %s\n") 
; invalid nick
(zenirc-set-text-list-ent 's433 "[info] Smeknamnet %s anvnds redan.\n") 
(zenirc-set-text-list-ent 's436 "[info] Smeknamns kollision: %s\n") ; nickicide
; can't do it to those not present
(zenirc-set-text-list-ent 's441 "[info] %s r deltar inte i %s\n") 
; you can't do that dave.
(zenirc-set-text-list-ent 's442 "[info] Du r deltar inte i %s\n") 
; invite error
(zenirc-set-text-list-ent 's443 "[info] %s deltar redan i mtet %s\n") 
; SUMMON reply
(zenirc-set-text-list-ent 's444 "[info] %s r inte ploggad.\n")	
(zenirc-set-text-list-ent ; disabled summon
 's445 "[info] Ngon verklig nolla lter dig inte anvnda /summon\n")
(zenirc-set-text-list-ent 
 's446 ; disabld users
 "[info] Ngon verklig nolla lter dig inte anvnda /users\n") 
; gotta do the USER NICK thing
(zenirc-set-text-list-ent 's451 "[info] Du har inte registrerat dig.\n") 
; as 421
(zenirc-set-text-list-ent 's461 "[info] Inte nog med parametrar: %s\n") 
(zenirc-set-text-list-ent ; cannot USER twice
 's462 "[info] Du fr inte registrera dig flera gnger.\n") 
(zenirc-set-text-list-ent ; server refuses this client
 's463 "[info] Ngon fascistisk nolla lter dig inte koppla upp dig.\n")
; bad PASS command
(zenirc-set-text-list-ent 's464 "[info] Passordet r inkorrekt.\n") 
(zenirc-set-text-list-ent 
 's465 ; creep
 "[info] Du r inte omtyckt p den hr server, byt genast ditt krk.\n") 
; chan key set already
(zenirc-set-text-list-ent 's467 "[info] Nyckeln r redan satt fr %s\n") 
(zenirc-set-text-list-ent 's471 "[info] Du kan inte delta i %s (anvndar antalet verskridit).\n") ; too many ppl
(zenirc-set-text-list-ent 's472 "[info] %s r en oknd status flagga.\n") ; duh
(zenirc-set-text-list-ent 's473 "[info] Du kan inte delta i %s (mste vara inbjuden).\n") ; fascist nerds
(zenirc-set-text-list-ent 's474 "[info] Du kan inte delta i %s (portad).\n") ; you're banned
(zenirc-set-text-list-ent 's475 "[info] Du kan inte delta i %s (fel kanal nyckel).\n") ; bad key
(zenirc-set-text-list-ent 's481 "[info] Du r inte en verklig nolla.\n") ; oper only
(zenirc-set-text-list-ent 's482 "[info] Du r inte nog mktig att %s\n") ; chanop needed
(zenirc-set-text-list-ent 's483 "[info] Bl, du kan inte dda en server.\n") ; can't kill a server
(zenirc-set-text-list-ent 's491 "[info] Inga verkliga nollor tilltna frn din address.\n") ; no o-line
(zenirc-set-text-list-ent 's501 "[info] Oknd klient status flagga.\n") ; you did something silly
(zenirc-set-text-list-ent 's502 "[info] Kan inte ndra status fr andra klienter.\n") ; as above
(zenirc-set-text-list-ent 'action "(skickat till %s>\n") ; ctcp ACTION display
es
;; FIXME - ACTION should be in swedish
(zenirc-set-text-list-ent 'ctcp_action "[ACTION->%s] %s %s\n") ; ctcp ACTION display
(zenirc-set-text-list-ent 'ctcp_clientinfo "[frga] CLIENTINFO frn %s till %s\n") ; ctcp CLIENTINFO inform
(zenirc-set-text-list-ent 'ctcp_errmsg "[frga] ERRMSG frn %s till %s\n") ; ctcp ERRMSG inform
(zenirc-set-text-list-ent 'ctcp_finger "[frga] FINGER frn %s till %s\n") ; ctcp FINGER inform
(zenirc-set-text-list-ent 'ctcp_ping "[frga] PING frn %s till %s\n") ; ctcp PING inform
(zenirc-set-text-list-ent 'ctcp_source "[frga] SOURCE frn %s till %s\n") ; ctcp SOURCE inform
(zenirc-set-text-list-ent 'ctcp_time "[frga] TIME frn %s till %s\n") ; ctcp TIME inform
(zenirc-set-text-list-ent 'ctcp_userinfo "[frga] USERINFO frn %s till %s\n") ; ctcp USERINFO inform
(zenirc-set-text-list-ent 'ctcp_version "[frga] VERSION frn %s till %s\n") ; ctcp VERSION inform
(zenirc-set-text-list-ent 'debug  "[debug] %s\n")       ; displayed by debugging code
(zenirc-set-text-list-ent 'error "[%s] %s\n")           ; server error message
(zenirc-set-text-list-ent 'invite "[info] %s tycker att du borde komma till %s\n") ; invite
(zenirc-set-text-list-ent 'kick "[info] %s har blivit sparkad frn %s av %s\n") ; someone was peeved
(zenirc-set-text-list-ent 'kick_you "[info] Du har blivit sparkad frn %s av %s\n") ; loser
(zenirc-set-text-list-ent 'kill "[info] Du har blivit mrdad: %s") ; your time is up.
(zenirc-set-text-list-ent 'mode "[info] %s har ndrat statusen fr %s: %s\n") ; MODE change
(zenirc-set-text-list-ent 'nick "[info] %s har bytt smeknamn till %s\n") ; nick change
(zenirc-set-text-list-ent 'nosend "[info] du har inget nuvarande offer att snda till.\n") ; msg not sent
(zenirc-set-text-list-ent 'notice "{%s%s} %s\n")        ; NOTICE
(zenirc-set-text-list-ent 'notice_you "{%s} %s\n")      ; NOTICE sent to your nick
(zenirc-set-text-list-ent 'notify_list "[info] Din nuvarande radar lista: %s\n")
(zenirc-set-text-list-ent 'notify_on "[info] Aha! %s slsar viktig tid.\n")
(zenirc-set-text-list-ent 'notify_off "[info] Aha! %s slutade slsa viktig tid.\n")
(zenirc-set-text-list-ent 'now-querying "[info] Nuvarande offer r %s\n") ; /query foo 
(zenirc-set-text-list-ent 'part_you "[info] Lmnar: %s\n") ; your part from channel message
(zenirc-set-text-list-ent 'part "[info] %s har lmnat %s\n") ;part from channel message
(zenirc-set-text-list-ent 'pong "[info] %s sger ojnk.\n")
(zenirc-set-text-list-ent 'privmsg "<%s%s> %s\n")       ; PRIVMSG
(zenirc-set-text-list-ent 'privmsg_you "*%s* %s\n")     ; PRIVMSG sent to your nick
(zenirc-set-text-list-ent 'query "[frga] frn %s till %s innehllande %s\n") ; ctcp query
(zenirc-set-text-list-ent 'query_unknown "r en oknd CTCP frga.") ; we don't grok this
(zenirc-set-text-list-ent 'query_unbalanced 	; someone is being lame
			  "[OBALANCERAD frga] frn %s till %s innehllande %s\n")
(zenirc-set-text-list-ent 'query_unbalanced_reply 				"r en obalancerad CTCP frga.") ; odd number of ^A's
(zenirc-set-text-list-ent 'quit "[info] %s slutade slsa viktig tid: %s\n") ; user signoff
(zenirc-set-text-list-ent 'reply "[svar] frn %s till %s innehllande %s\n") ; ctcp reply
(zenirc-set-text-list-ent 'reply_unbalanced "[OBALANCERAT svar] frn %s till %s innehllande %s\n") ;weird
(zenirc-set-text-list-ent 'send "(skickat till %s)\n")       ; you sent a message/notice
(zenirc-set-text-list-ent 'server "[server] %s\n")      ; unknown server message
(zenirc-set-text-list-ent 'signal "[signal i %s]")     ; signal in echo area
(zenirc-set-text-list-ent 'topic "[info] %s bytte rubriken fr %s till: %s\n") ; topic message
(zenirc-set-text-list-ent 'wallops "-%s- %s\n")	; WALLOPS notice

;;; end of zenirc-swedish-mode.el
