#!/bin/sh
# $Id: all_dvi.cmd,v 1.3 1992/04/09 16:57:26 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

#all_dvi <
#   doc_dvi(.none) "Formatted files for the documents"*
#   index_dvi "Formatted index to all of the documents"*
#   > "Formatted files for a set of documents"* :
#	USER
#		: (:level_0_specs +typekey=tnf :extract ::dvi)
#		: (:level_0_specs +typekey=tnf :extract ::index_entries)

cd (|<RUNDIR|)

cp (|<(:level_0_specs +typekey=tnf :extract ::dvi)|) (|>doc_dvi|)

# Build the index.fns file from the individual sets of index_entries
# This might die with 'command line too long' if we have too many docs

touch tmp
if [ -s (|<(:level_0_specs +typekey=tnf :extract ::index_entries)|) ]
then
	cat `cat (|<(:level_0_specs +typekey=tnf :extract ::index_entries)|)` > tmp
fi
(|$/Tool/texinfo/texindex|) tmp
mv tmps index.fns

# Create the index.tnf file from which the index will be made

cat <<END > index.tnf 
\input (|$/Tool/texinfo|)/texinfo   @c -*-texinfo-*-
@comment Copyright, 1989, The Regents of the University of Colorado
@comment %**start of header
@setfilename gindex
@settitle Global Index
@setchapternewpage odd
@comment %**end of header

@unnumbered Global Index
@printindex fn
@bye
END

# Create the formatted index

tex index.tnf > /dev/null
cat index.dvi > (|>index_dvi|)

exit 0
