#! /bin/sh
# $Id: warn.cmd,v 1.4 1992/08/06 20:16:34 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado
#
# warn 'Standard presentation of warning messages' :
#	USER
#		: (:.warning :expand_hooks)

if test ! -s (|<(:.warning :expand_hooks)|); then exit 0; fi

umask 0
cd (|<RUNDIR|)

sed -e '/^@map/,/^@end map/{
			/^@/d
			w MAP
			d
		}
		/^$/d
		/^Unknown input macro/s/^\(.*\) in <\(.*\)>/\2 0 0 \1/
		/does not exist/s/^.*<.*>.*<\(.*\)>.*/. 0 0 \1 missing/
		/^---.*:\.cmd_ref.*---$/{
			s/^.*\(<.*\) :\.cmd_ref>.*/\1>/
			h
			d
		}
		/^---.*---$/d
		/syntax error at token/d
		/^Syntax error in macro/{
			G
			s/^\(.*\) <\(..*\)>.*<\(.*\)>/\3 0 0 \1 <\2>/
		}
		/^[^./]/s/^/. 0 0 /' (|<(:.warning :expand_hooks)|) \
	| (|$/Tool/skeleton/cat-n.exe|) \
	| sort +1 -2 +2n -3 +3n -4 +0n -1 \
	| sed -e 's/^[0-9 	]*'// \
	| uniq \
	> INFILE

if test -s MAP
then
	sort -u +0 -1 MAP \
		| sed -e 's/^\([^	]*\)	\(.*\)$/s;\2;\1;/' \
		> SCRIPT
else cp /dev/null SCRIPT
fi

cat >>SCRIPT <<END
/^\([^ ]*\) \([0-9]*\) \([0-9]*\) \(.*\)$/s//"\1", line \2,\3: \4/
END

sed -f SCRIPT INFILE > (|>warn|)

exit 0

