#!/bin/sh
# $Id: ligaExp.cmd,v 3.3 1992/03/09 08:45:18 cogito Exp $
# Copyright, 1989, The Regents of the University of Colorado

#ligaExp <
#   exp_idl 'idl representation after liga expansion'*
#   exp_info ! 'Messages from LIDO shorthand expansion'
#   optEoption 'options for LIGA optim'*
#  > 'LIDO shorthand expansion'* :
#	USER
#		: fe_idl
#		: exp_option
#               : (:lido.cmpd :cpp)

umask 0
cd (|<RUNDIR|)

(|$/Tool/liga/ligaExp.exe|) -i (|<fe_idl|) \
	-c (|<exp_option|) \
	-t (|>optEoption|) \
	-o (|>exp_idl|) \
	-p (|>exp_info|) 	> /dev/null 2> ERRORS

mv core* core >/dev/null 2>&1
if test -s core
then
        echo '".", line 0:0 DEADLY: Tool LIGA EXPAND failed' >> ERRORS
	tcsh
fi

if test -s ERRORS
then
        sed -n -f (|$/Tool/liga/Cmd/mess_sort|) ERRORS
fi

if test -s ERRS
then
        echo '(''|(|$/Tool/liga/Info/expand.err|):std_err:' > (|>ERROR|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRS >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
fi

if test -s WARN
then
        echo '(''|(|$/Tool/liga/Info/expand.err|):std_err:' > (|>WARNING|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>WARNING|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' WARN >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
fi

exit 0



